/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.ivy.ant.IvyPostResolveTask;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.IvyNodeCallers;
import org.apache.ivy.core.resolve.IvyNodeEviction;
import org.apache.tools.ant.BuildException;

public class IvyDependencyTree
extends IvyPostResolveTask {
    private Map dependencies = new HashMap();
    private boolean showEvicted = false;

    @Override
    public void doExecute() throws BuildException {
        this.prepareAndCheck();
        ResolveReport resolveReport = this.getResolvedReport();
        this.log("Dependency tree for " + resolveReport.getResolveId());
        ModuleRevisionId moduleRevisionId = resolveReport.getModuleDescriptor().getModuleRevisionId();
        for (IvyNode ivyNode : resolveReport.getDependencies()) {
            this.populateDependencyTree(ivyNode, moduleRevisionId, resolveReport);
        }
        this.printDependencies((List)this.dependencies.get(moduleRevisionId), 0);
    }

    private void printDependencies(List list, int n) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IvyNode ivyNode = (IvyNode)iterator.next();
            boolean bl = ivyNode.isEvicted(this.getConf());
            if (bl && !this.showEvicted) continue;
            StringBuffer stringBuffer = new StringBuffer();
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    if (i == n - 1 && !iterator.hasNext() && !this.hasDependencies(ivyNode)) {
                        stringBuffer.append("   ");
                        continue;
                    }
                    stringBuffer.append("|  ");
                }
            }
            if (iterator.hasNext()) {
                stringBuffer.append("+- ");
            } else {
                stringBuffer.append("\\- ");
            }
            stringBuffer.append(ivyNode.getId().toString());
            if (bl && this.showEvicted) {
                IvyNodeEviction.EvictionData evictionData = ivyNode.getEvictedData(this.getConf());
                if (evictionData.isTransitivelyEvicted()) {
                    stringBuffer.append(" transitively");
                } else {
                    stringBuffer.append(" evicted by ");
                    stringBuffer.append(evictionData.getSelected());
                    stringBuffer.append(" in ").append(evictionData.getParent());
                    if (evictionData.getDetail() != null) {
                        stringBuffer.append(" ").append(evictionData.getDetail());
                    }
                }
            }
            this.log(stringBuffer.toString());
            this.printDependencies((List)this.dependencies.get(ivyNode.getId()), n + 1);
        }
    }

    private boolean hasDependencies(IvyNode ivyNode) {
        List list = (List)this.dependencies.get(ivyNode.getId());
        return list.size() > 0;
    }

    private void populateDependencyTree(IvyNode ivyNode, ModuleRevisionId moduleRevisionId, ResolveReport resolveReport) {
        this.registerNodeIfNecessary(ivyNode.getId());
        for (int i = 0; i < ivyNode.getAllCallers().length; ++i) {
            IvyNodeCallers.Caller caller = ivyNode.getAllCallers()[i];
            this.addDependency(caller.getModuleRevisionId(), ivyNode);
        }
    }

    private void registerNodeIfNecessary(ModuleRevisionId moduleRevisionId) {
        if (!this.dependencies.containsKey(moduleRevisionId)) {
            this.dependencies.put(moduleRevisionId, new ArrayList());
        }
    }

    private void addDependency(ModuleRevisionId moduleRevisionId, IvyNode ivyNode) {
        this.registerNodeIfNecessary(moduleRevisionId);
        List list = (List)this.dependencies.get(moduleRevisionId);
        list.add(ivyNode);
    }

    public boolean isShowEvicted() {
        return this.showEvicted;
    }

    public void setShowEvicted(boolean bl) {
        this.showEvicted = bl;
    }
}

