/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import java.io.File;
import java.util.List;
import org.apache.ivy.ant.IvyCacheTask;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.osgi.core.BundleInfo;
import org.apache.ivy.osgi.core.ManifestParser;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Path;

public class IvyCachePath
extends IvyCacheTask {
    private String pathid;
    private String id;
    private boolean osgi = false;

    public String getPathid() {
        return this.pathid;
    }

    public void setPathid(String string) {
        this.pathid = string;
    }

    public void setOsgi(boolean bl) {
        this.osgi = bl;
    }

    @Deprecated
    public void setId(String string) {
        this.id = string;
    }

    @Override
    public void doExecute() throws BuildException {
        this.prepareAndCheck();
        if (this.pathid == null) {
            if (this.id != null) {
                this.pathid = this.id;
                this.log("ID IS DEPRECATED, PLEASE USE PATHID INSTEAD", 1);
            } else {
                throw new BuildException("pathid is required in ivy classpath");
            }
        }
        try {
            Path path = new Path(this.getProject());
            this.getProject().addReference(this.pathid, (Object)path);
            for (ArtifactDownloadReport artifactDownloadReport : this.getArtifactReports()) {
                File file = artifactDownloadReport.getLocalFile();
                if (artifactDownloadReport.getUnpackedLocalFile() != null) {
                    file = artifactDownloadReport.getUnpackedLocalFile();
                }
                this.addToPath(path, file);
            }
        }
        catch (Exception exception) {
            throw new BuildException("impossible to build ivy path: " + exception, (Throwable)exception);
        }
    }

    protected void addToPath(Path path, File file) throws Exception {
        if (!this.osgi || !file.isDirectory()) {
            path.createPathElement().setLocation(file);
            return;
        }
        File file2 = new File(file, "META-INF/MANIFEST.MF");
        if (!file2.exists()) {
            path.createPathElement().setLocation(file);
            return;
        }
        BundleInfo bundleInfo = ManifestParser.parseManifest(file2);
        List<String> list = bundleInfo.getClasspath();
        if (list == null) {
            path.createPathElement().setLocation(file);
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            if (string.equals(".")) {
                path.createPathElement().setLocation(file);
                continue;
            }
            path.createPathElement().setLocation(new File(file, string));
        }
    }
}

