/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.ivy.ant.IvyPostResolveTask;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorWriter;
import org.apache.tools.ant.BuildException;

public class FixDepsTask
extends IvyPostResolveTask {
    private File dest;
    private List keeps = new ArrayList();

    public void setToFile(File file) {
        this.dest = file;
    }

    public Keep createKeep() {
        Keep keep = new Keep();
        this.keeps.add(keep);
        return keep;
    }

    @Override
    public void doExecute() throws BuildException {
        this.prepareAndCheck();
        if (this.dest == null) {
            throw new BuildException("Missing required parameter 'tofile'");
        }
        if (this.dest.exists() && this.dest.isDirectory()) {
            throw new BuildException("The destination file '" + this.dest.getAbsolutePath() + "' already exist and is a folder");
        }
        ResolveReport resolveReport = this.getResolvedReport();
        ArrayList<ModuleId> arrayList = new ArrayList<ModuleId>();
        for (int i = 0; i < this.keeps.size(); ++i) {
            arrayList.add(ModuleId.newInstance(((Keep)this.keeps.get(i)).org, ((Keep)this.keeps.get(i)).module));
        }
        ModuleDescriptor moduleDescriptor = resolveReport.toFixedModuleDescriptor(this.getSettings(), arrayList);
        try {
            XmlModuleDescriptorWriter.write(moduleDescriptor, this.dest);
        }
        catch (IOException iOException) {
            throw new BuildException("Failed to write into the file " + this.dest.getAbsolutePath() + " (" + iOException.getMessage() + ")", (Throwable)iOException);
        }
    }

    public static class Keep {
        private String org;
        private String module;

        public void setOrg(String string) {
            this.org = string;
        }

        public void setModule(String string) {
            this.module = string;
        }
    }
}

