/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.ws.ssl;

import java.security.PublicKey;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.api.libs.ws.ssl.AlgorithmChecker$;
import play.api.libs.ws.ssl.AlgorithmConstraint;
import play.api.libs.ws.ssl.Algorithms$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u00055c\u0001B\u0001\u0003\u00015\u0011\u0001#\u00117h_JLG\u000f[7DQ\u0016\u001c7.\u001a:\u000b\u0005\r!\u0011aA:tY*\u0011QAB\u0001\u0003oNT!a\u0002\u0005\u0002\t1L'm\u001d\u0006\u0003\u0013)\t1!\u00199j\u0015\u0005Y\u0011\u0001\u00029mCf\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011qBF\u0007\u0002!)\u0011\u0011CE\u0001\u0005G\u0016\u0014HO\u0003\u0002\u0014)\u0005A1/Z2ve&$\u0018PC\u0001\u0016\u0003\u0011Q\u0017M^1\n\u0005]\u0001\"a\u0005)L\u0013b\u001bUM\u001d;QCRD7\t[3dW\u0016\u0014\b\u0002C\r\u0001\u0005\u000b\u0007I\u0011\u0001\u000e\u0002)MLwM\\1ukJ,7i\u001c8tiJ\f\u0017N\u001c;t+\u0005Y\u0002c\u0001\u000f#K9\u0011Q\u0004I\u0007\u0002=)\tq$A\u0003tG\u0006d\u0017-\u0003\u0002\"=\u00051\u0001K]3eK\u001aL!a\t\u0013\u0003\u0007M+GO\u0003\u0002\"=A\u0011aeJ\u0007\u0002\u0005%\u0011\u0001F\u0001\u0002\u0014\u00032<wN]5uQ6\u001cuN\\:ue\u0006Lg\u000e\u001e\u0005\tU\u0001\u0011\t\u0011)A\u00057\u0005)2/[4oCR,(/Z\"p]N$(/Y5oiN\u0004\u0003\u0002\u0003\u0017\u0001\u0005\u000b\u0007I\u0011\u0001\u000e\u0002\u001d-,\u0017pQ8ogR\u0014\u0018-\u001b8ug\"Aa\u0006\u0001B\u0001B\u0003%1$A\blKf\u001cuN\\:ue\u0006Lg\u000e^:!\u0011\u0015\u0001\u0004\u0001\"\u00012\u0003\u0019a\u0014N\\5u}Q\u0019!g\r\u001b\u0011\u0005\u0019\u0002\u0001\"B\r0\u0001\u0004Y\u0002\"\u0002\u00170\u0001\u0004Y\u0002b\u0002\u001c\u0001\u0005\u0004%IaN\u0001\u0007Y><w-\u001a:\u0016\u0003a\u0002\"!\u000f \u000e\u0003iR!a\u000f\u001f\u0002\u000bMdg\r\u000e6\u000b\u0003u\n1a\u001c:h\u0013\ty$H\u0001\u0004M_\u001e<WM\u001d\u0005\u0007\u0003\u0002\u0001\u000b\u0011\u0002\u001d\u0002\u000f1|wmZ3sA!91\t\u0001b\u0001\n\u0013!\u0015aF:jO:\fG/\u001e:f\u0007>t7\u000f\u001e:bS:$8/T1q+\u0005)\u0005\u0003\u0002\u000fG\u0011\u0016J!a\u0012\u0013\u0003\u00075\u000b\u0007\u000f\u0005\u0002\u001d\u0013&\u0011!\n\n\u0002\u0007'R\u0014\u0018N\\4\t\r1\u0003\u0001\u0015!\u0003F\u0003a\u0019\u0018n\u001a8biV\u0014XmQ8ogR\u0014\u0018-\u001b8ug6\u000b\u0007\u000f\t\u0005\b\u001d\u0002\u0011\r\u0011\"\u0003E\u0003EYW-_\"p]N$(/Y5oiNl\u0015\r\u001d\u0005\u0007!\u0002\u0001\u000b\u0011B#\u0002%-,\u0017pQ8ogR\u0014\u0018-\u001b8ug6\u000b\u0007\u000f\t\u0005\u0006%\u0002!\taU\u0001\u001bSN4uN]<be\u0012\u001c\u0005.Z2lS:<7+\u001e9q_J$X\r\u001a\u000b\u0002)B\u0011Q$V\u0005\u0003-z\u0011qAQ8pY\u0016\fg\u000eC\u0003Y\u0001\u0011\u0005\u0011,\u0001\fhKR\u001cV\u000f\u001d9peR,G-\u0012=uK:\u001c\u0018n\u001c8t)\u0005Q\u0006cA._\u00116\tAL\u0003\u0002^)\u0005!Q\u000f^5m\u0013\t\u0019C\fC\u0003a\u0001\u0011\u0005\u0011-\u0001\u0003j]&$HC\u00012f!\ti2-\u0003\u0002e=\t!QK\\5u\u0011\u00151w\f1\u0001U\u0003\u001d1wN]<be\u0012DQ\u0001\u001b\u0001\u0005\u0002%\fqCZ5oINKwM\\1ukJ,7i\u001c8tiJ\f\u0017N\u001c;\u0015\u0005)l\u0007cA\u000flK%\u0011AN\b\u0002\u0007\u001fB$\u0018n\u001c8\t\u000b9<\u0007\u0019\u0001%\u0002\u0013\u0005dwm\u001c:ji\"l\u0007\"\u00029\u0001\t\u0003\t\u0018!\u00054j]\u0012\\U-_\"p]N$(/Y5oiR\u0011!N\u001d\u0005\u0006]>\u0004\r\u0001\u0013\u0005\u0006i\u0002!\t!^\u0001\u0019G\",7m[*jO:\fG/\u001e:f\u00032<wN]5uQ6\u001cHC\u00012w\u0011\u001598\u000f1\u0001y\u0003!AX\u0007M\u001dDKJ$\bCA\bz\u0013\tQ\bCA\bYkAJ4)\u001a:uS\u001aL7-\u0019;f\u0011\u0015a\b\u0001\"\u0001~\u0003I\u0019\u0007.Z2l\u0017\u0016L\u0018\t\\4pe&$\b.\\:\u0015\u0005\tt\b\"B<|\u0001\u0004A\bbBA\u0001\u0001\u0011\u0005\u00111A\u0001\u0006G\",7m\u001b\u000b\u0006E\u0006\u0015\u0011Q\u0002\u0005\u0007#}\u0004\r!a\u0002\u0011\u0007=\tI!C\u0002\u0002\fA\u00111bQ3si&4\u0017nY1uK\"9\u0011qB@A\u0002\u0005E\u0011AE;oe\u0016\u001cx\u000e\u001c<fI\u000e\u0013\u0018\u000e^#yiN\u0004BaWA\n\u0011&\u0019\u0011Q\u0003/\u0003\u0015\r{G\u000e\\3di&|g\u000eC\u0004\u0002\u001a\u0001!\t!a\u0007\u00029M,hn]3u'\"\u000b\u0015gU5h]\u0006$XO]3BY\u001e|'/\u001b;i[R\u0019!-!\b\t\r]\f9\u00021\u0001y\u0011\u001d\t\t\u0003\u0001C\u0001\u0003G\tA\"\u001b8g_>s7+\u001e8tKR$RAYA\u0013\u0003OAaa^A\u0010\u0001\u0004A\b\u0002CA\u0015\u0003?\u0001\r!a\u000b\u0002\u001d\u0015D\b/\u001b:bi&|g\u000eR1uKB!\u0011QFA\u001c\u001b\t\tyC\u0003\u0003\u00022\u0005M\u0012\u0001\u0002;j[\u0016T1!!\u000e=\u0003\u0011Qw\u000eZ1\n\t\u0005e\u0012q\u0006\u0002\t\t\u0006$X\rV5nK\"9\u0011Q\b\u0001\u0005\u0002\u0005}\u0012\u0001D<be:|enU;og\u0016$H#\u00022\u0002B\u0005\r\u0003BB<\u0002<\u0001\u0007\u0001\u0010\u0003\u0005\u0002*\u0005m\u0002\u0019AA\u0016\u0011\u001d\t9\u0005\u0001C\u0001\u0003\u0013\nQbZ3u\u0007>lWn\u001c8OC6,Gc\u0001%\u0002L!1\u0011#!\u0012A\u0002a\u0004")
public class AlgorithmChecker
extends PKIXCertPathChecker {
    private final scala.collection.immutable.Set<AlgorithmConstraint> signatureConstraints;
    private final scala.collection.immutable.Set<AlgorithmConstraint> keyConstraints;
    private final Logger play$api$libs$ws$ssl$AlgorithmChecker$$logger;
    private final Map<String, AlgorithmConstraint> signatureConstraintsMap;
    private final Map<String, AlgorithmConstraint> keyConstraintsMap;

    public scala.collection.immutable.Set<AlgorithmConstraint> signatureConstraints() {
        return this.signatureConstraints;
    }

    public scala.collection.immutable.Set<AlgorithmConstraint> keyConstraints() {
        return this.keyConstraints;
    }

    public Logger play$api$libs$ws$ssl$AlgorithmChecker$$logger() {
        return this.play$api$libs$ws$ssl$AlgorithmChecker$$logger;
    }

    private Map<String, AlgorithmConstraint> signatureConstraintsMap() {
        return this.signatureConstraintsMap;
    }

    private Map<String, AlgorithmConstraint> keyConstraintsMap() {
        return this.keyConstraintsMap;
    }

    @Override
    public boolean isForwardCheckingSupported() {
        return false;
    }

    @Override
    public Set<String> getSupportedExtensions() {
        return Collections.emptySet();
    }

    @Override
    public void init(boolean forward) {
        this.play$api$libs$ws$ssl$AlgorithmChecker$$logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"init: forward = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)forward)})));
        if (forward) {
            throw new CertPathValidatorException("Forward checking not supported");
        }
    }

    public Option<AlgorithmConstraint> findSignatureConstraint(String algorithm2) {
        return this.signatureConstraintsMap().get((Object)algorithm2);
    }

    public Option<AlgorithmConstraint> findKeyConstraint(String algorithm2) {
        return this.keyConstraintsMap().get((Object)algorithm2);
    }

    public void checkSignatureAlgorithms(X509Certificate x509Cert) {
        String sigAlgName = x509Cert.getSigAlgName();
        scala.collection.immutable.Set<String> sigAlgorithms = Algorithms$.MODULE$.decomposes(sigAlgName);
        this.play$api$libs$ws$ssl$AlgorithmChecker$$logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"checkSignatureAlgorithms: sigAlgName = ", ", sigAlgName = ", ", sigAlgorithms = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sigAlgName, sigAlgName, sigAlgorithms})));
        sigAlgorithms.foreach((Function1)new Serializable(this, x509Cert){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AlgorithmChecker $outer;
            public final X509Certificate x509Cert$2;

            public final Option<BoxedUnit> apply(String a) {
                return this.$outer.findSignatureConstraint(a).map((Function1)new Serializable(this, a){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$checkSignatureAlgorithms$1 $outer;
                    private final String a$1;

                    public final void apply(AlgorithmConstraint constraint) {
                        if (constraint.matches(this.a$1)) {
                            this.$outer.play$api$libs$ws$ssl$AlgorithmChecker$$anonfun$$$outer().play$api$libs$ws$ssl$AlgorithmChecker$$logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"checkSignatureAlgorithms: x509Cert = ", " failed on constraint ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.x509Cert$2, constraint})));
                            String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Certificate failed: ", " matched constraint ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.a$1, constraint}));
                            throw new CertPathValidatorException(msg);
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.a$1 = a$1;
                    }
                });
            }

            public /* synthetic */ AlgorithmChecker play$api$libs$ws$ssl$AlgorithmChecker$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.x509Cert$2 = x509Cert$2;
            }
        });
    }

    public void checkKeyAlgorithms(X509Certificate x509Cert) {
        PublicKey key = x509Cert.getPublicKey();
        String keyAlgorithmName = key.getAlgorithm();
        int keySize = BoxesRunTime.unboxToInt((Object)Algorithms$.MODULE$.keySize(key).getOrElse((Function0)new Serializable(this, key){
            public static final long serialVersionUID = 0L;
            private final PublicKey key$1;

            public final Nothing$ apply() {
                throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No keySize found for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.key$1})));
            }
            {
                this.key$1 = key$1;
            }
        }));
        scala.collection.immutable.Set<String> keyAlgorithms = Algorithms$.MODULE$.decomposes(keyAlgorithmName);
        this.play$api$libs$ws$ssl$AlgorithmChecker$$logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"checkKeyAlgorithms: keyAlgorithmName = ", ", keySize = ", ", keyAlgorithms = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{keyAlgorithmName, BoxesRunTime.boxToInteger((int)keySize), keyAlgorithms})));
        keyAlgorithms.foreach((Function1)new Serializable(this, x509Cert, keySize){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AlgorithmChecker $outer;
            public final X509Certificate x509Cert$1;
            public final int keySize$1;

            public final Option<BoxedUnit> apply(String a) {
                return this.$outer.findKeyConstraint(a).map((Function1)new Serializable(this, a){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$checkKeyAlgorithms$1 $outer;
                    private final String a$2;

                    public final void apply(AlgorithmConstraint constraint) {
                        if (constraint.matches(this.a$2, this.$outer.keySize$1)) {
                            String certName = this.$outer.x509Cert$1.getSubjectX500Principal().getName();
                            this.$outer.play$api$libs$ws$ssl$AlgorithmChecker$$anonfun$$$outer().play$api$libs$ws$ssl$AlgorithmChecker$$logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"checkKeyAlgorithms: cert = \"", "\" failed on constraint ", ", algorithm = ", ", keySize = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{certName, constraint, this.a$2, BoxesRunTime.boxToInteger((int)this.$outer.keySize$1)})));
                            String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Certificate failed: cert = \"", "\" failed on constraint ", ", algorithm = ", ", keySize = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{certName, constraint, this.a$2, BoxesRunTime.boxToInteger((int)this.$outer.keySize$1)}));
                            throw new CertPathValidatorException(msg);
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.a$2 = a$2;
                    }
                });
            }

            public /* synthetic */ AlgorithmChecker play$api$libs$ws$ssl$AlgorithmChecker$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.x509Cert$1 = x509Cert$1;
                this.keySize$1 = keySize$1;
            }
        });
    }

    @Override
    public void check(Certificate cert, Collection<String> unresolvedCritExts) {
        Certificate certificate = cert;
        if (certificate instanceof X509Certificate) {
            X509Certificate x509Certificate = (X509Certificate)certificate;
            String commonName = this.getCommonName(x509Certificate);
            Collection<List<?>> subAltNames = x509Certificate.getSubjectAlternativeNames();
            String certName = x509Certificate.getSubjectX500Principal().getName();
            DateTime expirationDate = new DateTime(x509Certificate.getNotAfter().getTime());
            this.play$api$libs$ws$ssl$AlgorithmChecker$$logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"check: checking certificate commonName = ", ", subjAltName = ", ", certName = ", ", expirationDate = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{commonName, subAltNames, certName, expirationDate})));
            this.sunsetSHA1SignatureAlgorithm(x509Certificate);
            this.checkSignatureAlgorithms(x509Certificate);
            this.checkKeyAlgorithms(x509Certificate);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        throw new UnsupportedOperationException("check only works with x509 certificates!");
    }

    public void sunsetSHA1SignatureAlgorithm(X509Certificate x509Cert) {
        String sigAlgName = x509Cert.getSigAlgName();
        scala.collection.immutable.Set<String> sigAlgorithms = Algorithms$.MODULE$.decomposes(sigAlgName);
        if (sigAlgorithms.contains((Object)"SHA1") || sigAlgorithms.contains((Object)"SHA-1")) {
            DateTime january2017;
            DateTime june2016 = new DateTime(2016, 6, 1, 0, 0, 0, 0);
            DateTime december2016 = new DateTime(2016, 12, 31, 0, 0, 0, 0);
            Interval secureInterval = new Interval((ReadableInstant)june2016, (ReadableInstant)december2016);
            DateTime expirationDate = new DateTime(x509Cert.getNotAfter().getTime());
            if (secureInterval.contains((ReadableInstant)expirationDate)) {
                this.infoOnSunset(x509Cert, expirationDate);
            }
            if ((january2017 = new DateTime(2017, 1, 1, 0, 0, 0, 0)).isEqual((ReadableInstant)expirationDate) || january2017.isBefore((ReadableInstant)expirationDate)) {
                this.warnOnSunset(x509Cert, expirationDate);
            }
        }
    }

    public void infoOnSunset(X509Certificate x509Cert, DateTime expirationDate) {
        String certName = x509Cert.getSubjectX500Principal().getName();
        this.play$api$libs$ws$ssl$AlgorithmChecker$$logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Certificate ", " uses SHA-1 and expires ", ": this certificate expires soon, but SHA-1 is being sunsetted."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{certName, expirationDate})));
    }

    public void warnOnSunset(X509Certificate x509Cert, DateTime expirationDate) {
        String certName = x509Cert.getSubjectX500Principal().getName();
        this.play$api$libs$ws$ssl$AlgorithmChecker$$logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Certificate ", " uses SHA-1 and expires ", ": SHA-1 cannot be considered secure and this certificate should be replaced."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{certName, expirationDate})));
    }

    public String getCommonName(X509Certificate cert) {
        String string;
        try {
            LdapName ldapName = new LdapName(cert.getSubjectX500Principal().getName());
            ObjectRef cn = ObjectRef.create(null);
            ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(ldapName.getRdns()).asScala()).withFilter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Rdn check$ifrefutable$1) {
                    Rdn rdn = check$ifrefutable$1;
                    boolean bl = rdn != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable(this, cn){
                public static final long serialVersionUID = 0L;
                private final ObjectRef cn$1;

                public final void apply(Rdn rdn) {
                    if ("CN".equalsIgnoreCase(rdn.getType())) {
                        this.cn$1.elem = rdn.getValue().toString();
                    }
                }
                {
                    this.cn$1 = cn$1;
                }
            });
            string = (String)cn.elem;
        }
        catch (InvalidNameException invalidNameException) {
            string = null;
        }
        return string;
    }

    public AlgorithmChecker(scala.collection.immutable.Set<AlgorithmConstraint> signatureConstraints2, scala.collection.immutable.Set<AlgorithmConstraint> keyConstraints) {
        this.signatureConstraints = signatureConstraints2;
        this.keyConstraints = keyConstraints;
        this.play$api$libs$ws$ssl$AlgorithmChecker$$logger = LoggerFactory.getLogger(this.getClass());
        this.signatureConstraintsMap = signatureConstraints2.iterator().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, AlgorithmConstraint> apply(AlgorithmConstraint c) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)c.algorithm()), (Object)c);
            }
        }).toMap(Predef$.MODULE$.$conforms());
        this.keyConstraintsMap = keyConstraints.iterator().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, AlgorithmConstraint> apply(AlgorithmConstraint c) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)c.algorithm()), (Object)c);
            }
        }).toMap(Predef$.MODULE$.$conforms());
    }
}

