/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.internal;

import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.SelfDescribing;
import org.jmock.api.Expectation;
import org.jmock.api.ExpectationError;
import org.jmock.api.Invocation;
import org.jmock.internal.ExpectationCollector;
import org.jmock.internal.StateMachine;

public class InvocationDispatcher
implements ExpectationCollector,
SelfDescribing {
    private List<Expectation> expectations = new ArrayList<Expectation>();
    private List<StateMachine> stateMachines = new ArrayList<StateMachine>();

    public StateMachine newStateMachine(String name) {
        StateMachine stateMachine = new StateMachine(name);
        this.stateMachines.add(stateMachine);
        return stateMachine;
    }

    public void add(Expectation expectation) {
        this.expectations.add(expectation);
    }

    public void describeTo(Description description) {
        if (this.expectations.isEmpty()) {
            description.appendText("no expectations specified: did you...\n - forget to start an expectation with a cardinality clause?\n - call a mocked method to specify the parameter of an expectation?");
        } else {
            description.appendList("expectations:\n  ", "\n  ", "", this.expectations);
            if (!this.stateMachines.isEmpty()) {
                description.appendList("\nstates:\n  ", "\n  ", "", this.stateMachines);
            }
        }
    }

    public boolean isSatisfied() {
        for (Expectation expectation : this.expectations) {
            if (expectation.isSatisfied()) continue;
            return false;
        }
        return true;
    }

    public Object dispatch(Invocation invocation) throws Throwable {
        for (Expectation expectation : this.expectations) {
            if (!expectation.matches(invocation)) continue;
            return expectation.invoke(invocation);
        }
        throw new ExpectationError("unexpected invocation", invocation);
    }
}

