/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.arrays;

import java.nio.ByteBuffer;
import org.mozilla.javascript.arrays.ExternalArray;

public final class ExternalClampedByteArray
extends ExternalArray {
    private static final long serialVersionUID = -1883561335812409618L;
    private final ByteBuffer array;

    public ExternalClampedByteArray(ByteBuffer array) {
        this.array = array;
    }

    public ByteBuffer getArray() {
        return this.array;
    }

    protected Object getElement(int index) {
        return this.array.get(this.array.position() + index) & 0xFF;
    }

    protected void putElement(int index, Object value) {
        int val = ((Number)value).intValue();
        if (val < 0) {
            val = 0;
        } else if (val > 255) {
            val = 255;
        }
        this.array.put(this.array.position() + index, (byte)(val & 0xFF));
    }

    public int getLength() {
        return this.array.remaining();
    }
}

