/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.Serializable;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.StackStyle;

public final class ScriptStackElement
implements Serializable {
    static final long serialVersionUID = -6416688260860477449L;
    public final String fileName;
    public final String functionName;
    public final int lineNumber;
    public final int columnNumber;

    public ScriptStackElement(String fileName, String functionName, int lineNumber, int columnNumber) {
        this.fileName = fileName;
        this.functionName = functionName;
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
    }

    public ScriptStackElement(String fileName, String functionName, int lineNumber) {
        this(fileName, functionName, lineNumber, -1);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.renderMozillaStyle(sb);
        return sb.toString();
    }

    public void render(StringBuilder buffer) {
        if (RhinoException.getStackStyle() == StackStyle.MOZILLA) {
            this.renderMozillaStyle(buffer);
        } else if (RhinoException.getStackStyle() == StackStyle.V8) {
            this.renderV8Style(buffer, true);
        } else {
            this.renderJavaStyle(buffer);
        }
    }

    public void renderLocation(StringBuilder buffer) {
        if (RhinoException.getStackStyle() == StackStyle.MOZILLA) {
            this.renderMozillaStyle(buffer);
        } else if (RhinoException.getStackStyle() == StackStyle.V8) {
            this.renderV8Style(buffer, false);
        } else {
            this.renderJavaStyle(buffer);
        }
    }

    public void renderJavaStyle(StringBuilder sb) {
        sb.append("\tat ").append(this.fileName);
        if (this.lineNumber > -1) {
            sb.append(':').append(this.lineNumber);
        }
        if (this.functionName != null) {
            sb.append(" (").append(this.functionName).append(')');
        }
    }

    public void renderMozillaStyle(StringBuilder sb) {
        if (this.functionName != null) {
            sb.append(this.functionName).append("()");
        }
        sb.append('@').append(this.fileName);
        if (this.lineNumber > -1) {
            sb.append(':').append(this.lineNumber);
        }
    }

    private void renderV8Style(StringBuilder sb, boolean stackStyle) {
        if (stackStyle) {
            sb.append("    at ");
        }
        if (this.functionName == null || "anonymous".equals(this.functionName)) {
            this.appendV8Location(sb);
        } else {
            sb.append(this.functionName).append(" (");
            this.appendV8Location(sb);
            sb.append(')');
        }
    }

    private void appendV8Location(StringBuilder sb) {
        sb.append(this.fileName);
        if (this.lineNumber > -1) {
            sb.append(':').append(this.lineNumber);
        }
        if (this.columnNumber > -1) {
            sb.append(':').append(this.columnNumber);
        }
    }
}

