/*
 * Decompiled with CFR 0.152.
 */
package sbt;

import java.io.File;
import sbt.BasicCommandStrings$;
import sbt.Help;
import sbt.Help$;
import sbt.Path$;
import sbt.State;
import sbt.State$;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;

public final class CommandStrings$ {
    public static final CommandStrings$ MODULE$;
    private final String AboutCommand;
    private final String TasksCommand;
    private final String SettingsCommand;
    private final String ProjectCommand;
    private final String ProjectsCommand;
    private final String ShowCommand;
    private final String BootCommand;
    private final String EvalCommand;
    private final Tuple2<String, String> evalBrief;
    private final String evalDetailed;
    private final String LastCommand;
    private final String LastGrepCommand;
    private final String ExportCommand;
    private final Tuple2<String, String> lastGrepBrief;
    private final String lastGrepDetailed;
    private final Tuple2<String, String> lastBrief;
    private final String lastDetailed;
    private final Tuple2<String, String> exportBrief;
    private final String exportDetailed;
    private final String InspectCommand;
    private final Tuple2<String, String> inspectBrief;
    private final String inspectDetailed;
    private final String SetCommand;
    private final Tuple2<String, String> setBrief;
    private final String setDetailed;
    private final String CrossCommand;
    private final String SwitchCommand;

    static {
        new CommandStrings$();
    }

    public String AboutCommand() {
        return this.AboutCommand;
    }

    public String TasksCommand() {
        return this.TasksCommand;
    }

    public String SettingsCommand() {
        return this.SettingsCommand;
    }

    public String ProjectCommand() {
        return this.ProjectCommand;
    }

    public String ProjectsCommand() {
        return this.ProjectsCommand;
    }

    public String ShowCommand() {
        return this.ShowCommand;
    }

    public String BootCommand() {
        return this.BootCommand;
    }

    public String EvalCommand() {
        return this.EvalCommand;
    }

    public Tuple2<String, String> evalBrief() {
        return this.evalBrief;
    }

    public String evalDetailed() {
        return this.evalDetailed;
    }

    public Help showHelp() {
        return Help$.MODULE$.apply(this.ShowCommand(), new Tuple2((Object)new StringBuilder().append((Object)this.ShowCommand()).append((Object)" <key>").toString(), (Object)this.actBrief()), this.actDetailed());
    }

    public String actBrief() {
        return "Displays the result of evaluating the setting or task associated with 'key'.";
    }

    public String actDetailed() {
        return new StringBuilder().append((Object)this.ShowCommand()).append((Object)" <setting>\n\n\tDisplays the value of the specified setting.\n\n").append((Object)this.ShowCommand()).append((Object)" <task>\n\n\tEvaluates the specified task and display the value returned by the task.").toString();
    }

    public String LastCommand() {
        return this.LastCommand;
    }

    public String LastGrepCommand() {
        return this.LastGrepCommand;
    }

    public String ExportCommand() {
        return this.ExportCommand;
    }

    public Tuple2<String, String> lastGrepBrief() {
        return this.lastGrepBrief;
    }

    public String lastGrepDetailed() {
        return this.lastGrepDetailed;
    }

    public Tuple2<String, String> lastBrief() {
        return this.lastBrief;
    }

    public String lastDetailed() {
        return this.lastDetailed;
    }

    public Tuple2<String, String> exportBrief() {
        return this.exportBrief;
    }

    public String exportDetailed() {
        return this.exportDetailed;
    }

    public String InspectCommand() {
        return this.InspectCommand;
    }

    public Tuple2<String, String> inspectBrief() {
        return this.inspectBrief;
    }

    public String inspectDetailed() {
        return this.inspectDetailed;
    }

    public String SetCommand() {
        return this.SetCommand;
    }

    public Tuple2<String, String> setBrief() {
        return this.setBrief;
    }

    public String setDetailed() {
        return this.setDetailed;
    }

    public String SessionCommand() {
        return "session";
    }

    public Tuple2<String, String> sessionBrief() {
        return new Tuple2((Object)this.SessionCommand(), (Object)new StringBuilder().append((Object)"Manipulates session settings.  For details, run 'help ").append((Object)this.SessionCommand()).append((Object)"'.").toString());
    }

    public String settingsPreamble() {
        return this.commonPreamble("settings");
    }

    public String tasksPreamble() {
        return new StringBuilder().append((Object)this.commonPreamble("tasks")).append((Object)"\nTasks produce values.  Use the 'show' command to run the task and print the resulting value.").toString();
    }

    public String commonPreamble(String label) {
        return new StringOps(Predef$.MODULE$.augmentString("\nThis is a list of %s defined for the current project.\nIt does not list the scopes the %<s are defined in; use the 'inspect' command for that.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{label}));
    }

    public Tuple2<String, String> settingsBrief(String label) {
        return new Tuple2((Object)label, (Object)new StringBuilder().append((Object)"Lists the ").append((Object)label).append((Object)" defined for the current project.").toString());
    }

    public String settingsDetailed(String label) {
        return new StringOps(Predef$.MODULE$.augmentString("\nSyntax summary\n\t%s [-(v|-vv|...|-V)] [<filter>]\n\n%<s\n\tDisplays the main %<s defined directly or indirectly for the current project. \n\n-v\n\tDisplays additional tasks.  More 'v's increase the number of tasks displayed.\n\n-V\n\tdisplays all %<s\n\n<filter>\n\tRestricts the %<s that are displayed.  The names of %<s are searched for an exact match against the filter, in which case only the description of the exact match is displayed.  Otherwise, the filter is interpreted as a regular expression and all %<s whose name or description match the regular expression are displayed.  Note that this is an additional filter on top of the %<s selected by the -v style switches, so you must specify -V to search all %<s.  Use the %s command to search all commands, tasks, and settings at once.\n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{label, BasicCommandStrings$.MODULE$.HelpCommand()}));
    }

    public String moreAvailableMessage(String label, boolean search) {
        return new StringOps(Predef$.MODULE$.augmentString("More %s may be %s by increasing verbosity.  See '%s %s'.\n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{label, search ? "searched" : "viewed", BasicCommandStrings$.MODULE$.HelpCommand(), label}));
    }

    public String aboutBrief() {
        return "Displays basic information about sbt and the build.";
    }

    public String aboutDetailed() {
        return this.aboutBrief();
    }

    public Tuple2<String, String> projectBrief() {
        return new Tuple2((Object)this.ProjectCommand(), (Object)"Displays the current project or changes to the provided `project`.");
    }

    public String projectDetailed() {
        return new StringBuilder().append((Object)this.ProjectCommand()).append((Object)"\n\n\tDisplays the name of the current project.\n\n").append((Object)this.ProjectCommand()).append((Object)" name\n\n\tChanges to the project with the provided name.\n\tThis command fails if there is no project with the given name.\n\n").append((Object)this.ProjectCommand()).append((Object)" {uri}\n\n\tChanges to the root project in the build defined by `uri`.\n\t`uri` must have already been declared as part of the build, such as with Project.dependsOn.\n\n").append((Object)this.ProjectCommand()).append((Object)" {uri}name\n\n\tChanges to the project `name` in the build defined by `uri`.\n\t`uri` must have already been declared as part of the build, such as with Project.dependsOn.\n\n").append((Object)this.ProjectCommand()).append((Object)" /\n\n\tChanges to the initial project.\n\n").append((Object)this.ProjectCommand()).append((Object)" ..\n\n\tChanges to the parent project of the current project.\n\tIf there is no parent project, the current project is unchanged.\n\n\tUse n+1 dots to change to the nth parent.\n\tFor example, 'project ....' is equivalent to three consecutive 'project ..' commands.").toString();
    }

    public String projectsBrief() {
        return "Lists the names of available projects or temporarily adds/removes extra builds to the session.";
    }

    public String projectsDetailed() {
        return new StringBuilder().append((Object)this.ProjectsCommand()).append((Object)"\n\tList the names of available builds and the projects defined in those builds.\n\n").append((Object)this.ProjectsCommand()).append((Object)" add <URI>+\n\tAdds the builds at the provided URIs to this session.\n\tThese builds may be selected using the ").append((Object)this.ProjectCommand()).append((Object)" command.\n\tAlternatively, tasks from these builds may be run using the explicit syntax {URI}project/task\n\n").append((Object)this.ProjectsCommand()).append((Object)" remove <URI>+\n\tRemoves extra builds from this session.\n\tBuilds explicitly listed in the build definition are not affected by this command.\n").toString();
    }

    public String sbtrc() {
        return ".sbtrc";
    }

    public String DefaultsCommand() {
        return "add-default-commands";
    }

    public Tuple2<String, String> DefaultsBrief() {
        return new Tuple2((Object)this.DefaultsCommand(), (Object)this.DefaultsDetailed());
    }

    public String DefaultsDetailed() {
        return "Registers default built-in commands";
    }

    public String Load() {
        return "load";
    }

    public String LoadLabel() {
        return "a project";
    }

    public String LoadCommand() {
        return "load-commands";
    }

    public String LoadCommandLabel() {
        return "commands";
    }

    public String LoadFailed() {
        return "load-failed";
    }

    public String LoadProjectImpl() {
        return "loadp";
    }

    public String LoadProject() {
        return "reload";
    }

    public Tuple2<String, String> LoadProjectBrief() {
        return new Tuple2((Object)this.LoadProject(), (Object)this.LoadProjectDetailed());
    }

    public String LoadProjectDetailed() {
        return "(Re)loads the project in the current directory";
    }

    public String InitCommand() {
        return "initialize";
    }

    public Tuple2<String, String> InitBrief() {
        return new Tuple2((Object)this.InitCommand(), (Object)"Initializes command processing.");
    }

    public String InitDetailed() {
        return new StringBuilder().append((Object)this.InitCommand()).append((Object)"\n\tInitializes command processing.\n\nRuns the following commands.\n\ndefaults\n\tRegisters default commands.\n\nload-commands -base ~/.sbt/commands\n\tBuilds and loads command definitions from ~/.sbt/commands\n\n< ~/.sbtrc\n< .sbtrc\n\tRuns commands from ~/.sbtrc and ./.sbtrc if they exist\n").toString();
    }

    public Seq<File> sbtRCs(State s) {
        File file2 = Path$.MODULE$.richFile(Path$.MODULE$.userHome()).$div(this.sbtrc());
        File file3 = Path$.MODULE$.richFile(Path$.MODULE$.richFile(State$.MODULE$.stateOps(s).baseDir()).$div(this.sbtrc())).asFile();
        return Nil$.MODULE$.$colon$colon((Object)file3).$colon$colon((Object)file2);
    }

    public String CrossCommand() {
        return this.CrossCommand;
    }

    public String SwitchCommand() {
        return this.SwitchCommand;
    }

    public Help crossHelp() {
        return Help$.MODULE$.more(this.CrossCommand(), this.CrossDetailed());
    }

    public Help switchHelp() {
        return Help$.MODULE$.more(this.SwitchCommand(), this.SwitchDetailed());
    }

    public String CrossDetailed() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " <command>\n\tRuns <command> for each Scala version specified for cross-building.\n\n\tFor each string in `crossScalaVersions` in the current project, this command sets the\n\t`scalaVersion` of all projects to that version, reloads the build, and\n\texecutes <command>.  When finished, it reloads the build with the original\n\tScala version.\n\n\tSee also `help ", "`\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.CrossCommand(), this.SwitchCommand()}));
    }

    public String SwitchDetailed() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " <scala-version> [<command>]\n\tChanges the Scala version and runs a command.\n\n\tSets the `scalaVersion` of all projects to <scala-version> and reloads the build.\n\tIf <command> is provided, it is then executed.\n\n", " [<scala-version>=]<scala-home> [<command>]\n\tUses the Scala installation at <scala-home> by configuring the scalaHome setting for\n\tall projects.\n\n\tIf <scala-version> is specified, it is used as the value of the scalaVersion setting.\n\tThis is important when using managed dependencies.  This version will determine the\n\tcross-version used as well as transitive dependencies.\n\n\tIf <command> is provided, it is then executed.\n\n\tSee also `help ", "`\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.SwitchCommand(), this.SwitchCommand(), this.CrossCommand()}));
    }

    private CommandStrings$() {
        MODULE$ = this;
        this.AboutCommand = "about";
        this.TasksCommand = "tasks";
        this.SettingsCommand = "settings";
        this.ProjectCommand = "project";
        this.ProjectsCommand = "projects";
        this.ShowCommand = "show";
        this.BootCommand = "boot";
        this.EvalCommand = "eval";
        this.evalBrief = new Tuple2((Object)new StringBuilder().append((Object)this.EvalCommand()).append((Object)" <expression>").toString(), (Object)"Evaluates a Scala expression and prints the result and type.");
        this.evalDetailed = new StringBuilder().append((Object)this.EvalCommand()).append((Object)" <expression>\n\n\tEvaluates the given Scala expression and prints the result and type.").toString();
        this.LastCommand = "last";
        this.LastGrepCommand = "last-grep";
        this.ExportCommand = "export";
        this.lastGrepBrief = new Tuple2((Object)this.LastGrepCommand(), (Object)"Shows lines from the last output for 'key' that match 'pattern'.");
        this.lastGrepDetailed = new StringBuilder().append((Object)this.LastGrepCommand()).append((Object)" <pattern>\n\tDisplays lines from the logging of previous commands that match `pattern`.\n\n").append((Object)this.LastGrepCommand()).append((Object)" <pattern> [key]\n\tDisplays lines from logging associated with `key` that match `pattern`.  The key typically refers to a task (for example, test:compile).  The logging that is displayed is restricted to the logging for that particular task.\n\n\t<pattern> is a regular expression interpreted by java.util.Pattern.  Matching text is highlighted (when highlighting is supported and enabled).\n\tSee also '").append((Object)this.LastCommand()).append((Object)"'.").toString();
        this.lastBrief = new Tuple2((Object)this.LastCommand(), (Object)"Displays output from a previous command or the output from a specific task.");
        this.lastDetailed = new StringBuilder().append((Object)this.LastCommand()).append((Object)"\n\tPrints the logging for the previous command, typically at a more verbose level.\n\n").append((Object)this.LastCommand()).append((Object)" <key>\n\tPrints the logging associated with the provided key.  The key typically refers to a task (for example, test:compile).  The logging that is displayed is restricted to the logging for that particular task.\n\n\tSee also '").append((Object)this.LastGrepCommand()).append((Object)"'.").toString();
        this.exportBrief = new Tuple2((Object)new StringBuilder().append((Object)this.ExportCommand()).append((Object)" <tasks>+").toString(), (Object)"Executes tasks and displays the equivalent command lines.");
        this.exportDetailed = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " [--last] <task>+\n\tRuns the specified tasks and prints the equivalent command lines or other exportable information for those runs.\n\n\t--last\n\t\tUses information from the previous execution\n\n\tNOTES: These command lines are necessarily approximate.  Usually tasks do not actually\n\texecute the command line and the actual command line program may not be installed or\n\ton the PATH.  Incremental tasks will typically show the command line for an\n\tincremental run and not for a full run.  Many tasks have no direct command line\n\tequivalent and will show nothing at all.\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.ExportCommand()}));
        this.InspectCommand = "inspect";
        this.inspectBrief = new Tuple2((Object)new StringBuilder().append((Object)this.InspectCommand()).append((Object)" [uses|tree|definitions] <key>").toString(), (Object)"Prints the value for 'key', the defining scope, delegates, related definitions, and dependencies.");
        this.inspectDetailed = new StringBuilder().append((Object)this.InspectCommand()).append((Object)" <key>\n\n\tFor a plain setting, the value bound to the key argument is displayed using its toString method.\n\tOtherwise, the type of task (\"Task\" or \"Input task\") is displayed.\n\n\t\"Dependencies\" shows the settings that this setting depends on.\n\t\n\t\"Reverse dependencies\" shows the settings that depend on this setting.\n\n\tWhen a key is resolved to a value, it may not actually be defined in the requested scope.\n\tIn this case, there is a defined search sequence.\n\t\"Delegates\" shows the scopes that are searched for the key.\n\t\"Provided by\" shows the scope that contained the value returned for the key.\n\n\t\"Related\" shows all of the scopes in which the key is defined.\n\n").append((Object)this.InspectCommand()).append((Object)" tree <key>\n\n\tDisplays `key` and its dependencies in a tree structure.\n\tFor settings, the value bound to the setting is displayed and for tasks, the type of the task is shown.\n\n").append((Object)this.InspectCommand()).append((Object)" uses <key>\n\n\tDisplays the settings and tasks that directly depend on `key`.\n\n").append((Object)this.InspectCommand()).append((Object)" definitions <key>\n\n\tDisplays the scopes in which `key` is defined.\n").toString();
        this.SetCommand = "set";
        this.setBrief = new Tuple2((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " [every] <setting>"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.SetCommand()})), (Object)"Evaluates a Setting and applies it to the current project.");
        this.setDetailed = new StringBuilder().append((Object)this.SetCommand()).append((Object)" [every] <setting-expression>\n\n\tApplies the given setting to the current project:\n\t  1) Constructs the expression provided as an argument by compiling and loading it.\n\t  2) Appends the new setting to the current project's settings.\n\t  3) Re-evaluates the build's settings.\n\n\tThis command does not rebuild the build definitions, plugins, or configurations.\n\tIt does not automatically persist the setting(s) either.\n\tTo persist the setting(s), run 'session save' or 'session save-all'.\n\n\tIf 'every' is specified, the setting is evaluated in the current context\n\tand the resulting value is used in every scope.  This overrides the value\n\tbound to the key everywhere.\n").toString();
        this.CrossCommand = "+";
        this.SwitchCommand = "++";
    }
}

