/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.base.config;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeSet;
import org.jfree.base.config.ModifiableConfiguration;

public class HierarchicalConfiguration
implements ModifiableConfiguration {
    private Properties configuration = new Properties();
    private transient ModifiableConfiguration parentConfiguration;

    public HierarchicalConfiguration() {
    }

    public HierarchicalConfiguration(ModifiableConfiguration modifiableConfiguration) {
        this();
        this.parentConfiguration = modifiableConfiguration;
    }

    public String getConfigProperty(String string) {
        return this.getConfigProperty(string, null);
    }

    public String getConfigProperty(String string, String string2) {
        String string3 = this.configuration.getProperty(string);
        if (string3 == null) {
            string3 = this.isRootConfig() ? string2 : this.parentConfiguration.getConfigProperty(string, string2);
        }
        return string3;
    }

    public void setConfigProperty(String string, String string2) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (string2 == null) {
            this.configuration.remove(string);
        } else {
            this.configuration.setProperty(string, string2);
        }
    }

    private boolean isRootConfig() {
        return this.parentConfiguration == null;
    }

    public boolean isLocallyDefined(String string) {
        return this.configuration.containsKey(string);
    }

    protected Properties getConfiguration() {
        return this.configuration;
    }

    public void insertConfiguration(HierarchicalConfiguration hierarchicalConfiguration) {
        hierarchicalConfiguration.setParentConfig(this.getParentConfig());
        this.setParentConfig(hierarchicalConfiguration);
    }

    protected void setParentConfig(ModifiableConfiguration modifiableConfiguration) {
        if (this.parentConfiguration == this) {
            throw new IllegalArgumentException("Cannot add myself as parent configuration.");
        }
        this.parentConfiguration = modifiableConfiguration;
    }

    protected ModifiableConfiguration getParentConfig() {
        return this.parentConfiguration;
    }

    public Enumeration getConfigProperties() {
        return this.configuration.keys();
    }

    public Iterator findPropertyKeys(String string) {
        TreeSet treeSet = new TreeSet();
        this.collectPropertyKeys(string, this, treeSet);
        return Collections.unmodifiableSet(treeSet).iterator();
    }

    private void collectPropertyKeys(String string, ModifiableConfiguration modifiableConfiguration, TreeSet treeSet) {
        Object object;
        Enumeration enumeration = modifiableConfiguration.getConfigProperties();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (!((String)object).startsWith(string) || treeSet.contains(object)) continue;
            treeSet.add(object);
        }
        if (modifiableConfiguration instanceof HierarchicalConfiguration) {
            object = (HierarchicalConfiguration)modifiableConfiguration;
            if (((HierarchicalConfiguration)object).parentConfiguration != null) {
                this.collectPropertyKeys(string, ((HierarchicalConfiguration)object).parentConfiguration, treeSet);
            }
        }
    }
}

