/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.parser.lexparser.BinaryRule;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Index;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BinaryGrammar
implements Serializable,
Iterable<BinaryRule> {
    private final Index<String> index;
    private final List<BinaryRule> allRules;
    private transient List<BinaryRule>[] rulesWithParent;
    private transient List<BinaryRule>[] rulesWithLC;
    private transient List<BinaryRule>[] rulesWithRC;
    private transient Set<BinaryRule>[] ruleSetWithLC;
    private transient Set<BinaryRule>[] ruleSetWithRC;
    private transient BinaryRule[][] splitRulesWithLC;
    private transient BinaryRule[][] splitRulesWithRC;
    private transient Map<BinaryRule, BinaryRule> ruleMap;
    private transient boolean[] synthetic;
    private static final long serialVersionUID = 1L;

    public int numRules() {
        return this.allRules.size();
    }

    public List<BinaryRule> rules() {
        return this.allRules;
    }

    public boolean isSynthetic(int state) {
        return this.synthetic[state];
    }

    public void splitRules() {
        int numStates = this.index.size();
        this.synthetic = new boolean[numStates];
        for (int s = 0; s < numStates; ++s) {
            try {
                this.synthetic[s] = this.index.get(s).charAt(0) == '@';
                continue;
            }
            catch (NullPointerException e) {
                this.synthetic[s] = true;
            }
        }
        this.splitRulesWithLC = new BinaryRule[numStates][];
        this.splitRulesWithRC = new BinaryRule[numStates][];
        for (int state = 0; state < numStates; ++state) {
            if (this.isSynthetic(state)) {
                this.splitRulesWithLC[state] = this.rulesWithLC[state].toArray(new BinaryRule[this.rulesWithLC[state].size()]);
                this.splitRulesWithRC[state] = this.rulesWithRC[state].toArray(new BinaryRule[this.rulesWithRC[state].size()]);
                continue;
            }
            ArrayList<BinaryRule> ruleList = new ArrayList<BinaryRule>();
            for (BinaryRule br : this.rulesWithLC[state]) {
                if (this.isSynthetic(br.rightChild)) continue;
                ruleList.add(br);
            }
            this.splitRulesWithLC[state] = ruleList.toArray(new BinaryRule[ruleList.size()]);
            ruleList.clear();
            for (BinaryRule br : this.rulesWithRC[state]) {
                if (this.isSynthetic(br.leftChild)) continue;
                ruleList.add(br);
            }
            this.splitRulesWithRC[state] = ruleList.toArray(new BinaryRule[ruleList.size()]);
        }
    }

    public BinaryRule[] splitRulesWithLC(int state) {
        return this.splitRulesWithLC[state];
    }

    public BinaryRule[] splitRulesWithRC(int state) {
        return this.splitRulesWithRC[state];
    }

    public double scoreRule(BinaryRule br) {
        BinaryRule rule = this.ruleMap.get(br);
        return rule != null ? (double)rule.score : Double.NEGATIVE_INFINITY;
    }

    public void addRule(BinaryRule br) {
        this.rulesWithParent[br.parent].add(br);
        this.rulesWithLC[br.leftChild].add(br);
        this.rulesWithRC[br.rightChild].add(br);
        this.ruleSetWithLC[br.leftChild].add(br);
        this.ruleSetWithRC[br.rightChild].add(br);
        this.allRules.add(br);
        this.ruleMap.put(br, br);
    }

    @Override
    public Iterator<BinaryRule> iterator() {
        return this.allRules.iterator();
    }

    public Iterator<BinaryRule> ruleIteratorByParent(int state) {
        if (state >= this.rulesWithParent.length) {
            return Collections.emptyList().iterator();
        }
        return this.rulesWithParent[state].iterator();
    }

    public Iterator<BinaryRule> ruleIteratorByRightChild(int state) {
        if (state >= this.rulesWithRC.length) {
            return Collections.emptyList().iterator();
        }
        return this.rulesWithRC[state].iterator();
    }

    public Iterator<BinaryRule> ruleIteratorByLeftChild(int state) {
        if (state >= this.rulesWithLC.length) {
            return Collections.emptyList().iterator();
        }
        return this.rulesWithLC[state].iterator();
    }

    public List<BinaryRule> ruleListByParent(int state) {
        if (state >= this.rulesWithParent.length) {
            return Collections.emptyList();
        }
        return this.rulesWithParent[state];
    }

    public List<BinaryRule> ruleListByRightChild(int state) {
        if (state >= this.rulesWithRC.length) {
            return Collections.emptyList();
        }
        return this.rulesWithRC[state];
    }

    public List<BinaryRule> ruleListByLeftChild(int state) {
        if (state >= this.rulesWithRC.length) {
            return Collections.emptyList();
        }
        return this.rulesWithLC[state];
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.init();
        for (BinaryRule br : this.allRules) {
            this.rulesWithParent[br.parent].add(br);
            this.rulesWithLC[br.leftChild].add(br);
            this.rulesWithRC[br.rightChild].add(br);
            this.ruleMap.put(br, br);
        }
        this.splitRules();
    }

    private void init() {
        this.ruleMap = Generics.newHashMap();
        int numStates = this.index.size();
        this.rulesWithParent = new List[numStates];
        this.rulesWithLC = new List[numStates];
        this.rulesWithRC = new List[numStates];
        this.ruleSetWithLC = new Set[numStates];
        this.ruleSetWithRC = new Set[numStates];
        for (int s = 0; s < numStates; ++s) {
            this.rulesWithParent[s] = new ArrayList<BinaryRule>();
            this.rulesWithLC[s] = new ArrayList<BinaryRule>();
            this.rulesWithRC[s] = new ArrayList<BinaryRule>();
            this.ruleSetWithLC[s] = Generics.newHashSet();
            this.ruleSetWithRC[s] = Generics.newHashSet();
        }
    }

    public BinaryGrammar(Index<String> stateIndex) {
        this.index = stateIndex;
        this.allRules = new ArrayList<BinaryRule>();
        this.init();
    }

    public void readData(BufferedReader in) throws IOException {
        int lineNum = 1;
        String line = in.readLine();
        while (line != null && line.length() > 0) {
            try {
                this.addRule(new BinaryRule(line, this.index));
            }
            catch (Exception e) {
                throw new IOException("Error on line " + lineNum);
            }
            ++lineNum;
            line = in.readLine();
        }
        this.splitRules();
    }

    public void writeData(Writer w) throws IOException {
        PrintWriter out2 = new PrintWriter(w);
        for (BinaryRule br : this) {
            out2.println(br.toString(this.index));
        }
        out2.flush();
    }
}

