/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.international.arabic.pipeline;

import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeReader;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.trees.international.arabic.ArabicTreeReaderFactory;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import edu.stanford.nlp.trees.tregex.tsurgeon.Tsurgeon;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPattern;
import edu.stanford.nlp.util.Pair;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class ATBCorrector
implements TreeTransformer {
    private static final boolean DEBUG = false;
    private final List<Pair<TregexPattern, TsurgeonPattern>> ops = this.loadOps();
    private static final String editStr = "@PUNC=punc <: __ >>, (/^S/ > @ROOT) \nprune punc\n\n@PUNC=punc <: __ >>, (/^S/ > @ROOT) \nprune punc\n\n@PUNC=punc >>- (/^S/ > @ROOT) <: __ $, @PUNC \nprune punc\n\n@PUNC=punc >>- (/^S/ > @ROOT) <: __ $, @PUNC \nprune punc\n\n@PUNC=pos >>- (/^S/ > @ROOT) <: /[^\\.\\?!]/=term !$, @PUNC \nrelabel pos PUNC\nrelabel term /./\n\n@PUNC=punc <: /^[\\.!\\?]+$/ >>- (/^S/ > @ROOT <- __=sfpos) !> (/^S/ > @ROOT)\nmove punc $- sfpos\n\n";

    private List<Pair<TregexPattern, TsurgeonPattern>> loadOps() {
        ArrayList<Pair<TregexPattern, TsurgeonPattern>> ops = new ArrayList<Pair<TregexPattern, TsurgeonPattern>>();
        String line = null;
        try {
            BufferedReader br = new BufferedReader(new StringReader(editStr));
            ArrayList<TsurgeonPattern> tsp = new ArrayList<TsurgeonPattern>();
            while ((line = br.readLine()) != null) {
                TregexPattern matchPattern = TregexPattern.compile(line);
                tsp.clear();
                while (ATBCorrector.continuing(line = br.readLine())) {
                    TsurgeonPattern p = Tsurgeon.parseOperation(line);
                    tsp.add(p);
                }
                if (tsp.isEmpty()) continue;
                TsurgeonPattern tp = Tsurgeon.collectOperations(tsp);
                ops.add(new Pair<TregexPattern, TsurgeonPattern>(matchPattern, tp));
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return ops;
    }

    private static boolean continuing(String str) {
        return str != null && !str.matches("\\s*");
    }

    @Override
    public Tree transformTree(Tree t) {
        return Tsurgeon.processPatternsOnTree(this.ops, t);
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage: java " + ATBCorrector.class.getName() + " filename\n");
            System.exit(-1);
        }
        ATBCorrector tt = new ATBCorrector();
        File f = new File(args[0]);
        try {
            Tree t;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"));
            ArabicTreeReaderFactory.ArabicRawTreeReaderFactory trf = new ArabicTreeReaderFactory.ArabicRawTreeReaderFactory();
            TreeReader tr = trf.newTreeReader(br);
            int nTrees = 0;
            while ((t = tr.readTree()) != null) {
                Tree fixedT = tt.transformTree(t);
                System.out.println(fixedT.toString());
                ++nTrees;
            }
            tr.close();
            System.err.printf("Wrote %d trees%n", nTrees);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

