/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex.tsurgeon;

import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.tsurgeon.CoindexationGenerator;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonMatcher;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPattern;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPatternRoot;
import java.util.Map;

class CoindexNodes
extends TsurgeonPattern {
    private static final String coindexationIntroductionString = "-";

    public CoindexNodes(TsurgeonPattern[] children) {
        super("coindex", children);
    }

    @Override
    protected void setRoot(TsurgeonPatternRoot root) {
        super.setRoot(root);
        root.setCoindexes();
    }

    @Override
    public TsurgeonMatcher matcher(Map<String, Tree> newNodeNames, CoindexationGenerator coindexer) {
        return new Matcher(newNodeNames, coindexer);
    }

    private class Matcher
    extends TsurgeonMatcher {
        public Matcher(Map<String, Tree> newNodeNames, CoindexationGenerator coindexer) {
            super(CoindexNodes.this, newNodeNames, coindexer);
        }

        @Override
        public Tree evaluate(Tree tree, TregexMatcher tregex) {
            int newIndex = this.coindexer.generateIndex();
            for (TsurgeonMatcher child : this.childMatcher) {
                Tree node = child.evaluate(tree, tregex);
                node.label().setValue(node.label().value() + CoindexNodes.coindexationIntroductionString + newIndex);
            }
            return tree;
        }
    }
}

