// DO NOT EDIT
// Generated by JFlex 1.8.2 http://jflex.de/
// source: src/edu/stanford/nlp/process/PTB2TextLexer.flex

package edu.stanford.nlp.process;

/** Undoes the more common cases of Penn Treebank quoting to producing
 *  something resembling normal text.  That is, it is an approximate inverse
 *  of PTBTokenizer.
 *
 *  Jan 2008: This was both made better, and some quirky weird stuff was added
 *  so as to better handle the NIST MT08 translation system's output.
 *
 *  @author Joseph Smarr
 *  @author Christopher Manning
 */



// See https://github.com/jflex-de/jflex/issues/222
@SuppressWarnings("FallThrough")
class PTB2TextLexer {

  /** This character denotes the end of file. */
  public static final int YYEOF = -1;

  /** Initial size of the lookahead buffer. */
  private static final int ZZ_BUFFERSIZE = 16384;

  // Lexical states.
  public static final int YYINITIAL = 0;
  public static final int INQUOTE = 2;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = {
     0,  0,  1, 1
  };

  /**
   * Top-level table for translating characters to character classes
   */
  private static final int [] ZZ_CMAP_TOP = zzUnpackcmap_top();

  private static final String ZZ_CMAP_TOP_PACKED_0 =
    "\1\0\1\u0100\1\u0200\1\u0300\1\u0400\1\u0500\1\u0600\1\u0700"+
    "\1\u0800\1\u0900\1\u0a00\1\u0b00\1\u0c00\1\u0d00\1\u0e00\1\u0f00"+
    "\1\u1000\1\u1100\1\u1200\1\u1300\1\u1400\1\u1100\1\u1500\1\u1600"+
    "\1\u1700\1\u1800\1\u1900\1\u1a00\1\u1b00\1\u1c00\1\u1100\1\u1d00"+
    "\1\u1e00\1\u1f00\12\u2000\1\u2100\1\u2200\1\u2300\1\u2000\1\u2400"+
    "\1\u2500\2\u2000\31\u1100\1\u2600\121\u1100\1\u2700\4\u1100\1\u2800"+
    "\1\u1100\1\u2900\1\u2a00\1\u2b00\1\u2c00\1\u2d00\1\u2e00\53\u1100"+
    "\1\u2f00\41\u2000\1\u1100\1\u3000\1\u3100\1\u1100\1\u3200\1\u3300"+
    "\1\u3400\1\u3500\1\u2000\1\u3600\1\u3700\1\u3800\1\u3900\1\u1100"+
    "\1\u3a00\1\u3b00\1\u3c00\1\u3d00\1\u3e00\1\u3f00\1\u4000\1\u2000"+
    "\1\u4100\1\u4200\1\u4300\1\u4400\1\u4500\1\u4600\1\u4700\1\u4800"+
    "\1\u4900\1\u4a00\1\u4b00\1\u4c00\1\u2000\1\u4d00\1\u4e00\1\u4f00"+
    "\1\u2000\3\u1100\1\u5000\1\u5100\1\u5200\12\u2000\4\u1100\1\u5300"+
    "\17\u2000\2\u1100\1\u5400\41\u2000\2\u1100\1\u5500\1\u5600\2\u2000"+
    "\1\u5700\1\u5800\27\u1100\1\u5900\2\u1100\1\u5a00\45\u2000\1\u1100"+
    "\1\u5b00\1\u5c00\11\u2000\1\u5d00\27\u2000\1\u5e00\1\u5f00\1\u6000"+
    "\1\u6100\11\u2000\1\u6200\1\u6300\5\u2000\1\u6400\1\u6500\4\u2000"+
    "\1\u6600\21\u2000\246\u1100\1\u6700\20\u1100\1\u6800\1\u6900\25\u1100"+
    "\1\u6a00\34\u1100\1\u6b00\14\u2000\2\u1100\1\u6c00\u0e05\u2000";

  private static int [] zzUnpackcmap_top() {
    int [] result = new int[4352];
    int offset = 0;
    offset = zzUnpackcmap_top(ZZ_CMAP_TOP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackcmap_top(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Second-level tables for translating characters to character classes
   */
  private static final int [] ZZ_CMAP_BLOCKS = zzUnpackcmap_blocks();

  private static final String ZZ_CMAP_BLOCKS_PACKED_0 =
    "\12\0\1\1\2\2\1\3\22\0\1\4\1\5\1\6"+
    "\1\0\1\7\1\10\1\11\1\12\1\13\1\14\2\0"+
    "\1\5\1\15\1\16\1\17\1\20\1\21\10\22\1\5"+
    "\1\23\3\0\1\24\1\0\1\25\1\26\1\27\1\30"+
    "\1\31\1\32\1\33\1\34\1\35\2\36\1\37\1\40"+
    "\1\41\1\42\1\43\1\44\1\45\1\46\1\47\1\50"+
    "\1\51\1\52\1\36\1\53\1\36\1\0\1\54\3\0"+
    "\1\55\1\56\1\57\1\60\1\61\1\62\1\63\1\64"+
    "\1\65\1\66\2\67\1\70\1\71\1\72\1\73\1\74"+
    "\1\75\1\76\1\77\1\100\1\101\1\102\1\103\1\67"+
    "\1\104\1\67\1\105\1\0\1\106\7\0\1\2\44\0"+
    "\1\36\12\0\1\36\4\0\1\36\5\0\27\36\1\0"+
    "\37\36\1\0\70\36\2\35\115\36\1\46\u0142\36\4\0"+
    "\14\36\16\0\5\36\7\0\1\36\1\0\1\36\201\0"+
    "\5\36\1\0\2\36\2\0\4\36\1\0\1\36\6\0"+
    "\1\36\1\0\3\36\1\0\1\36\1\0\24\36\1\0"+
    "\123\36\1\0\213\36\10\0\246\36\1\0\46\36\2\0"+
    "\1\36\6\0\51\36\107\0\33\36\4\0\4\36\55\0"+
    "\53\36\25\0\12\21\4\0\2\36\1\0\143\36\1\0"+
    "\1\36\17\0\2\36\7\0\2\36\12\21\3\36\2\0"+
    "\1\36\20\0\1\36\1\0\36\36\35\0\131\36\13\0"+
    "\1\36\16\0\12\21\41\36\11\0\2\36\4\0\1\36"+
    "\5\0\26\36\4\0\1\36\11\0\1\36\3\0\1\36"+
    "\27\0\31\36\7\0\13\36\65\0\25\36\1\0\10\36"+
    "\106\0\66\36\3\0\1\36\22\0\1\36\7\0\12\36"+
    "\4\0\12\21\1\0\20\36\4\0\10\36\2\0\2\36"+
    "\2\0\26\36\1\0\7\36\1\0\1\36\3\0\4\36"+
    "\3\0\1\36\20\0\1\36\15\0\2\36\1\0\3\36"+
    "\4\0\12\21\2\36\12\0\1\36\10\0\6\36\4\0"+
    "\2\36\2\0\26\36\1\0\7\36\1\0\2\36\1\0"+
    "\2\36\1\0\2\36\37\0\4\36\1\0\1\36\7\0"+
    "\12\21\2\0\3\36\20\0\11\36\1\0\3\36\1\0"+
    "\26\36\1\0\7\36\1\0\2\36\1\0\5\36\3\0"+
    "\1\36\22\0\1\36\17\0\2\36\4\0\12\21\11\0"+
    "\1\36\13\0\10\36\2\0\2\36\2\0\26\36\1\0"+
    "\7\36\1\0\2\36\1\0\5\36\3\0\1\36\36\0"+
    "\2\36\1\0\3\36\4\0\12\21\1\0\1\36\21\0"+
    "\1\36\1\0\6\36\3\0\3\36\1\0\4\36\3\0"+
    "\2\36\1\0\1\36\1\0\2\36\3\0\2\36\3\0"+
    "\3\36\3\0\14\36\26\0\1\36\25\0\12\21\25\0"+
    "\10\36\1\0\3\36\1\0\27\36\1\0\20\36\3\0"+
    "\1\36\32\0\3\36\5\0\2\36\4\0\12\21\20\0"+
    "\1\36\4\0\10\36\1\0\3\36\1\0\27\36\1\0"+
    "\12\36\1\0\5\36\3\0\1\36\40\0\1\36\1\0"+
    "\2\36\4\0\12\21\1\0\2\36\22\0\10\36\1\0"+
    "\3\36\1\0\51\36\2\0\1\36\20\0\1\36\5\0"+
    "\3\36\10\0\3\36\4\0\12\21\12\0\6\36\5\0"+
    "\22\36\3\0\30\36\1\0\11\36\1\0\1\36\2\0"+
    "\7\36\37\0\12\21\21\0\60\36\1\0\2\36\14\0"+
    "\7\36\11\0\12\21\47\0\2\36\1\0\1\36\1\0"+
    "\5\36\1\0\30\36\1\0\1\36\1\0\12\36\1\0"+
    "\2\36\11\0\1\36\2\0\5\36\1\0\1\36\11\0"+
    "\12\21\2\0\4\36\40\0\1\36\37\0\12\21\26\0"+
    "\10\36\1\0\44\36\33\0\5\36\163\0\53\36\24\0"+
    "\1\36\12\21\6\0\6\36\4\0\4\36\3\0\1\36"+
    "\3\0\2\36\7\0\3\36\4\0\15\36\14\0\1\36"+
    "\1\0\12\21\6\0\46\36\1\0\1\36\5\0\1\36"+
    "\2\0\53\36\1\0\u014d\36\1\0\4\36\2\0\7\36"+
    "\1\0\1\36\1\0\4\36\2\0\51\36\1\0\4\36"+
    "\2\0\41\36\1\0\4\36\2\0\7\36\1\0\1\36"+
    "\1\0\4\36\2\0\17\36\1\0\71\36\1\0\4\36"+
    "\2\0\103\36\45\0\20\36\20\0\126\36\2\0\6\36"+
    "\3\0\u016c\36\2\0\21\36\1\0\32\36\5\0\113\36"+
    "\6\0\10\36\7\0\15\36\1\0\4\36\16\0\22\36"+
    "\16\0\22\36\16\0\15\36\1\0\3\36\17\0\64\36"+
    "\43\0\1\36\4\0\1\36\3\0\12\21\46\0\12\21"+
    "\6\0\131\36\7\0\5\36\2\0\42\36\1\0\1\36"+
    "\5\0\106\36\12\0\37\36\47\0\12\21\36\36\2\0"+
    "\5\36\13\0\54\36\4\0\32\36\6\0\12\21\46\0"+
    "\27\36\11\0\65\36\53\0\12\21\6\0\12\21\15\0"+
    "\1\36\135\0\57\36\21\0\7\36\4\0\12\21\51\0"+
    "\36\36\15\0\2\36\12\21\54\36\32\0\44\36\34\0"+
    "\12\21\3\0\3\36\12\21\44\36\2\0\11\36\7\0"+
    "\53\36\2\0\3\36\51\0\4\36\1\0\6\36\1\0"+
    "\2\36\3\0\1\36\5\0\300\36\100\0\26\36\2\0"+
    "\6\36\2\0\46\36\2\0\6\36\2\0\10\36\1\0"+
    "\1\36\1\0\1\36\1\0\1\36\1\0\37\36\2\0"+
    "\65\36\1\0\7\36\1\0\1\36\3\0\3\36\1\0"+
    "\7\36\3\0\4\36\2\0\6\36\4\0\15\36\5\0"+
    "\3\36\1\0\7\36\53\0\2\2\107\0\1\36\15\0"+
    "\1\36\20\0\15\36\145\0\1\36\4\0\1\36\2\0"+
    "\12\36\1\0\1\36\3\0\5\36\6\0\1\36\1\0"+
    "\1\36\1\0\1\36\1\0\4\36\1\0\13\36\2\0"+
    "\4\36\5\0\5\36\4\0\1\36\64\0\2\36\u017b\0"+
    "\57\36\1\0\57\36\1\0\205\36\6\0\4\36\3\0"+
    "\2\36\14\0\46\36\1\0\1\36\5\0\1\36\2\0"+
    "\70\36\7\0\1\36\20\0\27\36\11\0\7\36\1\0"+
    "\7\36\1\0\7\36\1\0\7\36\1\0\7\36\1\0"+
    "\7\36\1\0\7\36\1\0\7\36\120\0\1\36\325\0"+
    "\2\36\52\0\5\36\5\0\2\36\4\0\126\36\6\0"+
    "\3\36\1\0\132\36\1\0\4\36\5\0\53\36\1\0"+
    "\136\36\21\0\33\36\65\0\306\36\112\0\360\36\20\0"+
    "\215\36\103\0\56\36\2\0\15\36\3\0\20\36\12\21"+
    "\2\36\24\0\57\36\20\0\37\36\2\0\106\36\61\0"+
    "\11\36\2\0\147\36\2\0\65\36\2\0\5\36\60\0"+
    "\13\36\1\0\3\36\1\0\4\36\1\0\27\36\35\0"+
    "\64\36\16\0\62\36\34\0\12\21\30\0\6\36\3\0"+
    "\1\36\1\0\2\36\1\0\12\21\34\36\12\0\27\36"+
    "\31\0\35\36\7\0\57\36\34\0\1\36\12\21\6\0"+
    "\5\36\1\0\12\36\12\21\5\36\1\0\51\36\27\0"+
    "\3\36\1\0\10\36\4\0\12\21\6\0\27\36\3\0"+
    "\1\36\3\0\62\36\1\0\1\36\3\0\2\36\2\0"+
    "\5\36\2\0\1\36\1\0\1\36\30\0\3\36\2\0"+
    "\13\36\7\0\3\36\14\0\6\36\2\0\6\36\2\0"+
    "\6\36\11\0\7\36\1\0\7\36\1\0\53\36\1\0"+
    "\14\36\10\0\163\36\15\0\12\21\6\0\244\36\14\0"+
    "\27\36\4\0\61\36\4\0\156\36\2\0\152\36\46\0"+
    "\7\36\14\0\5\36\5\0\1\36\1\0\12\36\1\0"+
    "\15\36\1\0\5\36\1\0\1\36\1\0\2\36\1\0"+
    "\2\36\1\0\154\36\41\0\153\36\22\0\100\36\2\0"+
    "\66\36\50\0\14\36\164\0\5\36\1\0\207\36\23\0"+
    "\12\21\7\0\32\36\6\0\32\36\13\0\131\36\3\0"+
    "\6\36\2\0\6\36\2\0\6\36\2\0\3\36\43\0"+
    "\14\36\1\0\32\36\1\0\23\36\1\0\2\36\1\0"+
    "\17\36\2\0\16\36\42\0\173\36\205\0\35\36\3\0"+
    "\61\36\57\0\40\36\15\0\24\36\1\0\10\36\6\0"+
    "\46\36\12\0\36\36\2\0\44\36\4\0\10\36\60\0"+
    "\236\36\2\0\12\21\6\0\44\36\4\0\44\36\4\0"+
    "\50\36\10\0\64\36\234\0\67\36\11\0\26\36\12\0"+
    "\10\36\230\0\6\36\2\0\1\36\1\0\54\36\1\0"+
    "\2\36\3\0\1\36\2\0\27\36\12\0\27\36\11\0"+
    "\37\36\101\0\23\36\1\0\2\36\12\0\26\36\12\0"+
    "\32\36\106\0\70\36\6\0\2\36\100\0\1\36\17\0"+
    "\4\36\1\0\3\36\1\0\35\36\52\0\35\36\3\0"+
    "\35\36\43\0\10\36\1\0\34\36\33\0\66\36\12\0"+
    "\26\36\12\0\23\36\15\0\22\36\156\0\111\36\67\0"+
    "\63\36\15\0\63\36\15\0\44\36\14\0\12\21\306\0"+
    "\35\36\12\0\1\36\10\0\26\36\232\0\27\36\14\0"+
    "\65\36\56\0\12\21\23\0\55\36\40\0\31\36\7\0"+
    "\12\21\11\0\44\36\17\0\12\21\4\0\1\36\13\0"+
    "\43\36\3\0\1\36\14\0\60\36\16\0\4\36\13\0"+
    "\12\21\1\36\1\0\1\36\43\0\22\36\1\0\31\36"+
    "\124\0\7\36\1\0\1\36\1\0\4\36\1\0\17\36"+
    "\1\0\12\36\7\0\57\36\21\0\12\21\13\0\10\36"+
    "\2\0\2\36\2\0\26\36\1\0\7\36\1\0\2\36"+
    "\1\0\5\36\3\0\1\36\22\0\1\36\14\0\5\36"+
    "\236\0\65\36\22\0\4\36\5\0\12\21\5\0\1\36"+
    "\40\0\60\36\24\0\2\36\1\0\1\36\10\0\12\21"+
    "\246\0\57\36\51\0\4\36\44\0\60\36\24\0\1\36"+
    "\13\0\12\21\46\0\53\36\15\0\1\36\7\0\12\21"+
    "\66\0\33\36\25\0\12\21\306\0\54\36\164\0\100\36"+
    "\12\21\25\0\1\36\240\0\10\36\2\0\47\36\20\0"+
    "\1\36\1\0\1\36\34\0\1\36\12\0\50\36\7\0"+
    "\1\36\25\0\1\36\13\0\56\36\23\0\1\36\42\0"+
    "\71\36\7\0\11\36\1\0\45\36\21\0\1\36\17\0"+
    "\12\21\30\0\36\36\160\0\7\36\1\0\2\36\1\0"+
    "\46\36\25\0\1\36\11\0\12\21\6\0\6\36\1\0"+
    "\2\36\1\0\40\36\16\0\1\36\7\0\12\21\u0136\0"+
    "\23\36\15\0\232\36\346\0\304\36\274\0\57\36\321\0"+
    "\107\36\271\0\71\36\7\0\37\36\1\0\12\21\146\0"+
    "\36\36\22\0\60\36\20\0\4\36\14\0\12\21\11\0"+
    "\25\36\5\0\23\36\260\0\100\36\200\0\113\36\5\0"+
    "\1\36\102\0\15\36\100\0\2\36\1\0\1\36\34\0"+
    "\370\36\10\0\363\36\15\0\37\36\61\0\3\36\21\0"+
    "\4\36\10\0\u018c\36\4\0\153\36\5\0\15\36\3\0"+
    "\11\36\7\0\12\36\146\0\125\36\1\0\107\36\1\0"+
    "\2\36\2\0\1\36\2\0\2\36\2\0\4\36\1\0"+
    "\14\36\1\0\1\36\1\0\7\36\1\0\101\36\1\0"+
    "\4\36\2\0\10\36\1\0\7\36\1\0\34\36\1\0"+
    "\4\36\1\0\5\36\1\0\1\36\3\0\7\36\1\0"+
    "\u0154\36\2\0\31\36\1\0\31\36\1\0\37\36\1\0"+
    "\31\36\1\0\37\36\1\0\31\36\1\0\37\36\1\0"+
    "\31\36\1\0\37\36\1\0\31\36\1\0\10\36\2\0"+
    "\62\21\55\36\12\0\7\36\2\0\12\21\4\0\1\36"+
    "\u0171\0\54\36\4\0\12\21\6\0\305\36\73\0\104\36"+
    "\7\0\1\36\4\0\12\21\246\0\4\36\1\0\33\36"+
    "\1\0\2\36\1\0\1\36\2\0\1\36\1\0\12\36"+
    "\1\0\4\36\1\0\1\36\1\0\1\36\6\0\1\36"+
    "\4\0\1\36\1\0\1\36\1\0\1\36\1\0\3\36"+
    "\1\0\2\36\1\0\1\36\2\0\1\36\1\0\1\36"+
    "\1\0\1\36\1\0\1\36\1\0\1\36\1\0\2\36"+
    "\1\0\1\36\2\0\4\36\1\0\7\36\1\0\4\36"+
    "\1\0\4\36\1\0\1\36\1\0\12\36\1\0\21\36"+
    "\5\0\3\36\1\0\5\36\1\0\21\36\104\0\327\36"+
    "\51\0\65\36\13\0\336\36\2\0\u0182\36\16\0\u0131\36"+
    "\37\0\36\36\342\0";

  private static int [] zzUnpackcmap_blocks() {
    int [] result = new int[27904];
    int offset = 0;
    offset = zzUnpackcmap_blocks(ZZ_CMAP_BLOCKS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackcmap_blocks(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /**
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\2\0\1\1\1\2\1\1\1\3\1\1\1\4\2\1"+
    "\1\5\4\1\1\5\7\1\1\6\1\4\1\7\1\0"+
    "\1\10\2\0\1\11\1\0\2\7\1\0\1\12\1\0"+
    "\1\13\5\0\1\14\1\1\1\0\3\1\1\15\1\16"+
    "\5\1\1\17\1\6\4\0\2\20\3\0\1\21\6\0"+
    "\1\22\5\0\2\1\2\0\4\1\1\23\5\1\6\0"+
    "\1\24\4\0\1\25\5\0\1\4\1\0\1\26\1\0"+
    "\1\27\1\0\2\1\7\0\2\1\1\0\1\1\1\0"+
    "\1\1\1\0\2\1\1\0\1\1\3\0\1\4\5\0"+
    "\1\30\3\0\2\4\1\3\4\0\15\31\1\0\1\1"+
    "\1\0\1\1\1\0\3\1\3\0\2\4\1\6\10\0"+
    "\1\3\1\0\2\32\1\33\1\0\1\33\5\31\1\0"+
    "\20\31\1\0\1\1\2\0\3\1\2\0\1\6\3\0"+
    "\1\6\6\0\1\34\1\0\12\31\1\35\1\1\1\0"+
    "\1\31\1\0\2\1\1\0\1\6\3\0\5\31\1\36"+
    "\2\1\4\31\1\1\1\0\1\31\1\1\1\0\1\31"+
    "\1\1\1\0\1\31\1\1\1\31\22\1";

  private static int [] zzUnpackAction() {
    int [] result = new int[306];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\107\0\216\0\325\0\u011c\0\u0163\0\u01aa\0\u01f1"+
    "\0\u0238\0\u027f\0\325\0\u02c6\0\u030d\0\u0354\0\u039b\0\u03e2"+
    "\0\u0429\0\u0470\0\u04b7\0\u04fe\0\u0545\0\u058c\0\u05d3\0\325"+
    "\0\u061a\0\325\0\u0661\0\325\0\u06a8\0\u06ef\0\325\0\u0736"+
    "\0\u077d\0\u07c4\0\u080b\0\325\0\u0852\0\325\0\u0899\0\u08e0"+
    "\0\u0927\0\u096e\0\u09b5\0\325\0\u09fc\0\u0a43\0\u0a8a\0\u0ad1"+
    "\0\u0b18\0\325\0\325\0\u0b5f\0\u0ba6\0\u0bed\0\u0c34\0\u0c7b"+
    "\0\325\0\u0661\0\u0cc2\0\u0d09\0\u0d50\0\u0d97\0\325\0\u0dde"+
    "\0\u0e25\0\u0e6c\0\u0eb3\0\325\0\u0efa\0\u0f41\0\u03e2\0\u0f88"+
    "\0\u0fcf\0\u1016\0\325\0\u105d\0\u10a4\0\u10eb\0\u1132\0\u1179"+
    "\0\u11c0\0\u1207\0\u124e\0\u1295\0\u12dc\0\u1323\0\u136a\0\u13b1"+
    "\0\325\0\u13f8\0\u143f\0\u1486\0\u14cd\0\u1514\0\u155b\0\u15a2"+
    "\0\u15e9\0\u1630\0\u1677\0\u16be\0\325\0\u1705\0\u174c\0\u1793"+
    "\0\u17da\0\325\0\u1821\0\u1868\0\u18af\0\u18f6\0\u193d\0\u1984"+
    "\0\u19cb\0\325\0\u1a12\0\325\0\u1a59\0\u1aa0\0\u1ae7\0\u1b2e"+
    "\0\u1b75\0\u1bbc\0\u1c03\0\u1c4a\0\u1c91\0\u1cd8\0\u1d1f\0\u1d66"+
    "\0\u1dad\0\u1df4\0\u1e3b\0\u1e82\0\u1ec9\0\u1f10\0\u1f57\0\u1f9e"+
    "\0\u1fe5\0\u202c\0\u2073\0\u20ba\0\u2101\0\u2148\0\u218f\0\u21d6"+
    "\0\u221d\0\u2264\0\325\0\u22ab\0\u22f2\0\u2339\0\u2380\0\u23c7"+
    "\0\u240e\0\u2455\0\u249c\0\u24e3\0\u252a\0\u2571\0\u25b8\0\u25ff"+
    "\0\u2646\0\u268d\0\u26d4\0\u271b\0\u2762\0\u27a9\0\u27f0\0\u2837"+
    "\0\u287e\0\u28c5\0\u290c\0\u2953\0\u299a\0\u29e1\0\u2a28\0\u2a6f"+
    "\0\u2ab6\0\u2afd\0\u2b44\0\u2b8b\0\u2bd2\0\u2c19\0\u2c60\0\u2ca7"+
    "\0\u2cee\0\u2d35\0\u2d7c\0\u2dc3\0\u2e0a\0\u2e51\0\u23c7\0\u2e98"+
    "\0\u2edf\0\u2f26\0\325\0\u2f6d\0\325\0\u2fb4\0\u2ffb\0\u3042"+
    "\0\u3089\0\u30d0\0\u3117\0\u315e\0\u2ffb\0\u31a5\0\u31ec\0\u3233"+
    "\0\u327a\0\u32c1\0\u3308\0\u334f\0\u3396\0\u33dd\0\u3424\0\u346b"+
    "\0\u34b2\0\u34f9\0\u3540\0\u3587\0\u35ce\0\u3615\0\u365c\0\u36a3"+
    "\0\u36ea\0\u3731\0\u3778\0\u37bf\0\u3806\0\u384d\0\u3894\0\u38db"+
    "\0\u2c60\0\u3922\0\u3969\0\u39b0\0\u39f7\0\u3a3e\0\u3a85\0\u3acc"+
    "\0\u3b13\0\325\0\u3b5a\0\u3ba1\0\u3be8\0\u3c2f\0\u3c76\0\u3cbd"+
    "\0\u3d04\0\u3d4b\0\u3d92\0\u3dd9\0\u3e20\0\325\0\u3e67\0\u3eae"+
    "\0\u3ef5\0\u3f3c\0\u3f83\0\u3fca\0\u4011\0\u4058\0\u409f\0\u40e6"+
    "\0\u412d\0\u4174\0\u41bb\0\u4202\0\u4249\0\u4290\0\325\0\u42d7"+
    "\0\u431e\0\u4365\0\u43ac\0\u43f3\0\u443a\0\u4481\0\u44c8\0\u450f"+
    "\0\u4556\0\u459d\0\u45e4\0\u462b\0\u4672\0\u46b9\0\u4700\0\u4672"+
    "\0\u4747\0\u478e\0\u47d5\0\u481c\0\u4863\0\u48aa\0\u48f1\0\u4938"+
    "\0\u497f\0\u49c6\0\u4a0d\0\u4a54\0\u4a9b\0\u4ae2\0\u4b29\0\u4b70"+
    "\0\u4bb7\0\u4bfe";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[306];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /**
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\3\1\4\2\3\1\5\1\3\1\6\1\7\1\3"+
    "\1\10\1\3\1\11\1\3\1\12\1\3\1\13\3\14"+
    "\2\3\2\14\1\15\4\14\1\16\11\14\1\17\5\14"+
    "\1\20\1\21\2\22\1\23\4\22\1\24\11\22\1\25"+
    "\5\22\1\26\2\3\1\4\2\3\1\27\1\3\1\30"+
    "\1\7\1\3\1\31\1\3\1\11\1\3\1\12\1\3"+
    "\1\13\3\14\2\3\2\14\1\15\4\14\1\16\11\14"+
    "\1\17\5\14\1\20\1\21\2\22\1\23\4\22\1\24"+
    "\11\22\1\25\5\22\1\26\2\3\1\0\2\3\1\0"+
    "\1\3\1\0\2\3\1\0\5\3\1\0\34\3\1\0"+
    "\32\3\114\0\1\32\1\33\1\0\1\34\1\35\1\36"+
    "\1\0\1\37\1\40\1\41\4\0\1\32\1\42\14\0"+
    "\1\43\30\0\1\43\13\0\1\44\4\0\1\45\102\0"+
    "\1\3\1\0\2\3\1\46\1\3\1\0\2\3\1\0"+
    "\5\3\1\0\34\3\1\0\32\3\4\0\1\47\20\0"+
    "\1\50\5\0\1\51\3\0\1\52\4\0\1\53\11\0"+
    "\1\50\5\0\1\51\3\0\1\52\4\0\1\53\11\0"+
    "\1\3\1\0\2\3\1\54\1\3\1\0\2\3\1\0"+
    "\5\3\1\0\34\3\1\0\33\3\1\0\2\3\1\0"+
    "\1\3\1\0\2\3\1\0\5\3\1\0\17\3\1\55"+
    "\14\3\1\0\13\3\1\55\17\3\1\0\2\3\1\56"+
    "\1\3\1\0\2\3\1\0\5\3\1\0\3\14\2\3"+
    "\27\14\1\0\1\3\27\14\3\3\1\0\2\3\1\56"+
    "\1\3\1\0\2\3\1\0\5\3\1\0\3\14\2\3"+
    "\1\57\26\14\1\0\1\3\1\57\26\14\3\3\1\0"+
    "\2\3\1\56\1\3\1\0\2\3\1\0\5\3\1\0"+
    "\3\14\2\3\4\14\1\60\22\14\1\0\1\3\4\14"+
    "\1\60\22\14\3\3\1\0\2\3\1\56\1\3\1\0"+
    "\2\3\1\0\5\3\1\0\3\14\2\3\1\61\26\14"+
    "\1\0\1\3\1\61\26\14\2\3\17\0\1\62\67\0"+
    "\1\3\1\0\2\3\1\63\1\3\1\0\2\3\1\0"+
    "\5\3\1\0\34\3\1\0\1\64\32\3\1\0\2\3"+
    "\1\56\1\3\1\0\2\3\1\0\5\3\1\0\3\14"+
    "\2\3\27\14\1\0\1\3\27\65\3\3\1\0\2\3"+
    "\1\56\1\3\1\0\2\3\1\0\5\3\1\0\3\14"+
    "\2\3\1\57\26\14\1\0\1\3\1\66\26\65\3\3"+
    "\1\0\2\3\1\56\1\3\1\0\2\3\1\0\5\3"+
    "\1\0\3\14\2\3\4\14\1\60\22\14\1\0\1\3"+
    "\4\65\1\67\22\65\3\3\1\0\2\3\1\56\1\3"+
    "\1\0\2\3\1\0\5\3\1\0\3\14\2\3\1\61"+
    "\26\14\1\0\1\3\1\70\26\65\3\3\1\0\2\3"+
    "\1\71\1\3\1\0\2\3\1\0\5\3\1\0\34\3"+
    "\1\0\32\3\5\0\1\32\1\72\1\0\1\34\1\73"+
    "\1\36\1\0\1\37\1\40\1\41\4\0\1\32\1\42"+
    "\14\0\1\43\30\0\1\43\13\0\1\44\4\0\1\74"+
    "\20\0\1\75\5\0\1\51\3\0\1\52\4\0\1\76"+
    "\11\0\1\75\5\0\1\51\3\0\1\52\4\0\1\76"+
    "\12\0\2\77\1\100\107\0\1\101\20\0\1\102\16\0"+
    "\1\103\11\0\1\102\16\0\1\103\11\0\1\32\1\0"+
    "\10\32\1\104\74\32\45\0\1\105\30\0\1\105\26\0"+
    "\1\106\144\0\1\107\44\0\1\110\102\0\1\111\2\0"+
    "\1\112\13\0\27\113\2\0\27\113\27\0\1\114\16\0"+
    "\1\53\11\0\1\114\16\0\1\53\51\0\1\115\30\0"+
    "\1\115\64\0\1\116\30\0\1\116\55\0\1\117\30\0"+
    "\1\117\56\0\1\120\30\0\1\120\5\0\1\3\1\0"+
    "\2\3\1\0\1\3\1\0\2\3\1\0\5\3\1\0"+
    "\7\3\1\121\15\3\1\122\6\3\1\0\3\3\1\121"+
    "\15\3\1\122\10\3\12\0\1\123\2\0\1\124\71\0"+
    "\1\3\1\0\2\3\1\56\1\3\1\0\2\3\1\0"+
    "\5\3\1\0\3\14\2\3\14\14\1\125\12\14\1\0"+
    "\1\3\14\14\1\125\12\14\3\3\1\0\2\3\1\56"+
    "\1\3\1\0\2\3\1\0\5\3\1\0\3\14\2\3"+
    "\1\126\26\14\1\0\1\3\1\126\26\14\3\3\1\0"+
    "\2\3\1\56\1\3\1\0\2\3\1\0\5\3\1\0"+
    "\3\14\2\3\10\14\1\127\15\14\1\130\1\0\1\3"+
    "\10\14\1\127\15\14\1\130\3\3\1\0\2\3\1\131"+
    "\1\3\1\0\2\3\1\0\5\3\1\0\34\3\1\0"+
    "\33\3\1\0\2\3\1\56\1\3\1\0\2\3\1\0"+
    "\5\3\1\0\3\14\2\3\27\14\1\0\1\3\27\132"+
    "\3\3\1\0\2\3\1\56\1\3\1\0\2\3\1\0"+
    "\5\3\1\0\3\14\2\3\14\14\1\125\12\14\1\0"+
    "\1\3\14\132\1\133\12\132\3\3\1\0\2\3\1\56"+
    "\1\3\1\0\2\3\1\0\5\3\1\0\3\14\2\3"+
    "\1\126\26\14\1\0\1\3\1\134\26\132\3\3\1\0"+
    "\2\3\1\56\1\3\1\0\2\3\1\0\5\3\1\0"+
    "\3\14\2\3\10\14\1\127\15\14\1\130\1\0\1\3"+
    "\10\132\1\135\15\132\1\136\2\3\4\0\1\137\20\0"+
    "\1\140\16\0\1\141\11\0\1\140\16\0\1\141\36\0"+
    "\1\142\16\0\1\76\11\0\1\142\16\0\1\76\51\0"+
    "\1\143\30\0\1\143\65\0\1\144\30\0\1\144\6\0"+
    "\1\145\132\0\1\102\16\0\1\103\11\0\1\102\16\0"+
    "\1\103\51\0\1\146\30\0\1\146\65\0\1\147\30\0"+
    "\1\147\34\0\1\150\15\0\1\151\12\0\1\150\15\0"+
    "\1\151\26\0\1\32\137\0\1\152\30\0\1\152\12\0"+
    "\1\153\106\0\1\154\20\0\1\155\16\0\1\156\11\0"+
    "\1\155\16\0\1\156\51\0\1\157\30\0\1\157\60\0"+
    "\1\160\30\0\1\160\16\0\1\161\16\0\1\162\67\0"+
    "\1\163\16\0\1\164\125\0\1\165\30\0\1\165\13\0"+
    "\1\3\1\0\2\3\1\0\1\3\1\0\2\3\1\0"+
    "\5\3\1\0\6\3\1\166\25\3\1\0\2\3\1\166"+
    "\30\3\1\0\2\3\1\0\1\3\1\0\2\3\1\0"+
    "\5\3\1\0\6\3\1\167\25\3\1\0\2\3\1\167"+
    "\27\3\22\0\1\170\4\0\1\171\1\0\1\172\7\0"+
    "\1\173\5\0\1\174\10\0\1\171\1\0\1\172\7\0"+
    "\1\173\5\0\1\174\12\0\1\175\102\0\1\3\1\0"+
    "\2\3\1\176\1\3\1\0\2\3\1\0\5\3\1\0"+
    "\3\14\2\3\27\14\1\0\1\3\27\14\3\3\1\0"+
    "\2\3\1\56\1\3\1\0\2\3\1\0\5\3\1\0"+
    "\3\14\2\3\3\14\1\177\23\14\1\0\1\3\3\14"+
    "\1\177\23\14\3\3\1\0\2\3\1\56\1\3\1\0"+
    "\2\3\1\0\5\3\1\0\3\14\2\3\3\14\1\200"+
    "\23\14\1\0\1\3\3\14\1\200\23\14\3\3\1\0"+
    "\2\3\1\201\1\3\1\0\2\3\1\0\5\3\1\0"+
    "\3\14\2\3\10\14\1\202\10\14\1\200\5\14\1\0"+
    "\1\3\10\14\1\202\10\14\1\200\5\14\3\3\1\0"+
    "\2\3\1\203\1\3\1\0\2\3\1\0\5\3\1\0"+
    "\3\14\2\3\27\14\1\0\1\3\27\204\3\3\1\0"+
    "\2\3\1\205\1\3\1\0\2\3\1\0\5\3\1\0"+
    "\3\14\2\3\27\14\1\0\1\3\27\204\3\3\1\0"+
    "\2\3\1\203\1\3\1\0\2\3\1\0\5\3\1\0"+
    "\3\14\2\3\3\14\1\177\23\14\1\0\1\3\3\204"+
    "\1\206\23\204\3\3\1\0\2\3\1\203\1\3\1\0"+
    "\2\3\1\0\5\3\1\0\3\14\2\3\3\14\1\200"+
    "\23\14\1\0\1\3\3\204\1\207\23\204\3\3\1\0"+
    "\2\3\1\210\1\3\1\0\2\3\1\0\5\3\1\0"+
    "\3\14\2\3\10\14\1\202\10\14\1\200\5\14\1\0"+
    "\1\3\10\204\1\211\10\204\1\207\5\204\2\3\25\0"+
    "\1\140\16\0\1\141\11\0\1\140\16\0\1\141\51\0"+
    "\1\212\30\0\1\212\65\0\1\213\30\0\1\213\45\0"+
    "\1\214\30\0\1\214\60\0\1\215\30\0\1\215\54\0"+
    "\1\216\30\0\1\216\56\0\1\217\30\0\1\217\54\0"+
    "\1\220\30\0\1\220\41\0\1\221\30\0\1\221\55\0"+
    "\1\222\30\0\1\222\54\0\27\223\2\0\27\223\27\0"+
    "\1\155\16\0\1\156\11\0\1\155\16\0\1\156\51\0"+
    "\1\224\30\0\1\224\65\0\1\225\30\0\1\225\50\0"+
    "\1\226\30\0\1\226\16\0\1\227\16\0\1\230\106\0"+
    "\1\162\106\0\1\164\132\0\1\231\30\0\1\231\6\0"+
    "\1\3\1\0\2\3\1\0\1\3\1\0\2\3\1\0"+
    "\3\3\1\26\1\3\1\0\34\3\1\0\33\3\1\0"+
    "\2\3\1\0\1\3\1\0\2\3\1\0\3\3\1\11"+
    "\1\3\1\0\34\3\1\0\32\3\20\0\1\232\113\0"+
    "\1\233\30\0\1\233\70\0\1\234\30\0\1\234\27\0"+
    "\1\234\131\0\1\235\30\0\1\235\45\0\1\236\1\237"+
    "\3\240\1\241\1\240\1\242\1\243\3\240\1\244\1\245"+
    "\2\240\1\246\1\247\1\250\2\240\1\251\1\252\2\0"+
    "\1\236\1\237\3\240\1\241\1\240\1\242\1\243\3\240"+
    "\1\244\1\245\2\240\1\246\1\247\1\250\2\240\1\251"+
    "\1\252\14\0\1\123\2\0\1\124\23\0\1\253\30\0"+
    "\1\253\14\0\1\3\1\0\2\3\1\56\1\3\1\0"+
    "\2\3\1\0\5\3\1\0\3\14\2\3\12\14\1\254"+
    "\14\14\1\0\1\3\12\14\1\254\14\14\3\3\1\0"+
    "\2\3\1\201\1\3\1\0\2\3\1\0\5\3\1\0"+
    "\3\14\2\3\27\14\1\0\1\3\27\14\2\3\12\0"+
    "\1\123\2\0\1\255\71\0\1\3\1\0\2\3\1\56"+
    "\1\3\1\0\2\3\1\0\5\3\1\0\3\14\2\3"+
    "\14\14\1\256\12\14\1\0\1\3\14\14\1\256\12\14"+
    "\2\3\12\0\1\257\2\0\1\124\71\0\1\3\1\0"+
    "\2\3\1\203\1\3\1\0\2\3\1\0\5\3\1\0"+
    "\3\14\2\3\27\14\1\0\1\3\27\260\2\3\12\0"+
    "\1\257\2\0\1\124\23\0\1\253\30\0\1\253\14\0"+
    "\1\3\1\0\2\3\1\203\1\3\1\0\2\3\1\0"+
    "\5\3\1\0\3\14\2\3\12\14\1\254\14\14\1\0"+
    "\1\3\12\260\1\261\14\260\3\3\1\0\2\3\1\210"+
    "\1\3\1\0\2\3\1\0\5\3\1\0\3\14\2\3"+
    "\27\14\1\0\1\3\27\260\2\3\12\0\1\257\2\0"+
    "\1\255\71\0\1\3\1\0\2\3\1\203\1\3\1\0"+
    "\2\3\1\0\5\3\1\0\3\14\2\3\14\14\1\256"+
    "\12\14\1\0\1\3\14\260\1\262\12\260\2\3\43\0"+
    "\1\263\30\0\1\263\54\0\1\264\30\0\1\264\56\0"+
    "\1\265\30\0\1\265\16\0\1\266\16\0\1\267\132\0"+
    "\1\270\30\0\1\270\12\0\1\271\16\0\1\272\132\0"+
    "\1\273\30\0\1\273\23\0\1\44\106\0\1\37\134\0"+
    "\1\274\30\0\1\274\54\0\1\275\30\0\1\275\17\0"+
    "\1\276\16\0\1\277\106\0\1\230\67\0\1\300\37\0"+
    "\1\53\30\0\1\53\15\0\1\301\16\0\1\6\131\0"+
    "\1\234\30\0\1\234\57\0\1\302\30\0\1\302\6\0"+
    "\2\303\1\304\1\305\141\0\1\306\30\0\1\306\17\0"+
    "\2\303\1\304\1\307\20\0\2\240\1\310\2\240\1\311"+
    "\6\240\1\312\3\240\1\313\2\314\4\240\2\0\2\240"+
    "\1\310\2\240\1\311\6\240\1\312\3\240\1\313\2\314"+
    "\4\240\6\0\1\315\20\0\4\240\1\316\22\240\2\0"+
    "\4\240\1\316\22\240\6\0\1\315\20\0\27\240\2\0"+
    "\27\240\6\0\1\315\20\0\15\240\1\317\11\240\2\0"+
    "\15\240\1\317\11\240\6\0\1\315\20\0\1\320\3\240"+
    "\1\321\22\240\2\0\1\320\3\240\1\321\22\240\6\0"+
    "\1\315\20\0\14\240\1\322\4\240\1\314\5\240\2\0"+
    "\14\240\1\322\4\240\1\314\5\240\6\0\1\315\20\0"+
    "\4\240\1\323\22\240\2\0\4\240\1\323\22\240\6\0"+
    "\1\315\20\0\14\240\1\324\12\240\2\0\14\240\1\324"+
    "\12\240\6\0\1\315\20\0\4\240\1\325\22\240\2\0"+
    "\4\240\1\325\22\240\6\0\1\315\20\0\7\240\1\326"+
    "\5\240\1\327\5\240\1\330\3\240\2\0\7\240\1\326"+
    "\5\240\1\327\5\240\1\330\3\240\6\0\1\315\20\0"+
    "\7\240\1\331\5\240\1\314\11\240\2\0\7\240\1\331"+
    "\5\240\1\314\11\240\6\0\1\315\20\0\1\332\3\240"+
    "\1\321\2\240\1\333\5\240\1\334\11\240\2\0\1\332"+
    "\3\240\1\321\2\240\1\333\5\240\1\334\11\240\6\0"+
    "\1\315\20\0\15\240\1\335\11\240\2\0\15\240\1\335"+
    "\11\240\44\0\1\336\30\0\1\336\13\0\1\3\1\0"+
    "\2\3\1\56\1\3\1\0\2\3\1\0\5\3\1\0"+
    "\3\14\2\3\10\14\1\337\16\14\1\0\1\3\10\14"+
    "\1\337\16\14\2\3\4\0\1\340\102\0\1\3\1\0"+
    "\2\3\1\56\1\3\1\0\2\3\1\0\5\3\1\0"+
    "\3\14\2\3\6\14\1\200\20\14\1\0\1\3\6\14"+
    "\1\200\20\14\2\3\4\0\1\341\15\0\1\170\4\0"+
    "\1\171\1\0\1\172\7\0\1\173\5\0\1\174\10\0"+
    "\1\171\1\0\1\172\7\0\1\173\5\0\1\174\6\0"+
    "\1\3\1\0\2\3\1\203\1\3\1\0\2\3\1\0"+
    "\5\3\1\0\3\14\2\3\27\14\1\0\1\3\27\342"+
    "\3\3\1\0\2\3\1\203\1\3\1\0\2\3\1\0"+
    "\5\3\1\0\3\14\2\3\10\14\1\337\16\14\1\0"+
    "\1\3\10\342\1\343\16\342\3\3\1\0\2\3\1\203"+
    "\1\3\1\0\2\3\1\0\5\3\1\0\3\14\2\3"+
    "\6\14\1\200\20\14\1\0\1\3\6\342\1\344\20\342"+
    "\2\3\4\0\1\345\16\0\1\346\132\0\1\347\30\0"+
    "\1\347\12\0\1\350\16\0\1\351\106\0\1\267\67\0"+
    "\1\352\37\0\1\76\30\0\1\76\15\0\1\353\16\0"+
    "\1\30\106\0\1\272\67\0\1\354\37\0\1\103\30\0"+
    "\1\103\12\0\2\77\1\100\1\355\16\0\1\33\67\0"+
    "\1\356\16\0\1\357\132\0\1\360\30\0\1\360\31\0"+
    "\1\277\127\0\1\53\30\0\1\53\15\0\1\45\1\0"+
    "\1\111\2\0\1\112\11\0\1\6\1\0\27\113\2\0"+
    "\27\113\50\0\1\361\30\0\1\361\10\0\1\362\106\0"+
    "\2\303\1\304\1\305\32\0\1\234\30\0\1\234\33\0"+
    "\1\363\75\0\1\315\20\0\2\240\1\364\24\240\2\0"+
    "\2\240\1\364\24\240\6\0\1\315\20\0\16\240\1\314"+
    "\3\240\1\365\4\240\2\0\16\240\1\314\3\240\1\365"+
    "\4\240\6\0\1\315\20\0\3\240\1\314\23\240\2\0"+
    "\3\240\1\314\23\240\6\0\1\315\20\0\4\240\1\314"+
    "\22\240\2\0\4\240\1\314\22\240\3\0\2\303\1\304"+
    "\1\307\20\0\27\240\2\0\27\240\6\0\1\315\20\0"+
    "\5\240\1\366\21\240\2\0\5\240\1\366\21\240\6\0"+
    "\1\315\20\0\20\240\1\314\6\240\2\0\20\240\1\314"+
    "\6\240\6\0\1\315\20\0\21\240\1\314\2\240\1\313"+
    "\2\240\2\0\21\240\1\314\2\240\1\313\2\240\3\0"+
    "\2\303\1\304\1\307\20\0\20\240\1\313\6\240\2\0"+
    "\20\240\1\313\6\240\3\0\2\303\1\304\1\307\20\0"+
    "\2\240\1\367\24\240\2\0\2\240\1\367\24\240\6\0"+
    "\1\315\20\0\25\240\1\332\1\240\2\0\25\240\1\332"+
    "\1\240\3\0\2\303\1\304\1\307\20\0\4\240\1\314"+
    "\22\240\2\0\4\240\1\314\22\240\6\0\1\315\20\0"+
    "\23\240\1\370\3\240\2\0\23\240\1\370\3\240\6\0"+
    "\1\315\20\0\4\240\1\314\10\240\1\334\11\240\2\0"+
    "\4\240\1\314\10\240\1\334\11\240\3\0\2\303\1\304"+
    "\1\307\20\0\13\240\1\313\13\240\2\0\13\240\1\313"+
    "\13\240\6\0\1\315\20\0\2\240\1\371\24\240\2\0"+
    "\2\240\1\371\24\240\6\0\1\315\20\0\1\372\3\240"+
    "\1\373\3\240\1\332\4\240\1\374\5\240\1\332\3\240"+
    "\2\0\1\372\3\240\1\373\3\240\1\332\4\240\1\374"+
    "\5\240\1\332\3\240\6\0\1\315\20\0\21\240\1\314"+
    "\5\240\2\0\21\240\1\314\5\240\6\0\1\315\20\0"+
    "\10\240\1\330\4\240\1\314\11\240\2\0\10\240\1\330"+
    "\4\240\1\314\11\240\6\0\1\315\20\0\23\240\1\375"+
    "\3\240\2\0\23\240\1\375\3\240\6\0\1\315\20\0"+
    "\23\240\1\314\3\240\2\0\23\240\1\314\3\240\51\0"+
    "\1\376\30\0\1\376\6\0\1\3\1\0\2\3\1\56"+
    "\1\3\1\0\2\3\1\0\5\3\1\0\3\14\2\3"+
    "\14\14\1\377\12\14\1\0\1\3\14\14\1\377\12\14"+
    "\2\3\20\0\3\u0100\2\0\27\u0101\2\0\27\u0101\50\0"+
    "\1\u0102\30\0\1\u0102\7\0\1\3\1\0\2\3\1\203"+
    "\1\3\1\0\2\3\1\0\5\3\1\0\3\14\2\3"+
    "\27\14\1\0\1\3\27\u0103\3\3\1\0\2\3\1\203"+
    "\1\3\1\0\2\3\1\0\5\3\1\0\3\14\2\3"+
    "\14\14\1\377\12\14\1\0\1\3\14\u0103\1\u0104\12\u0103"+
    "\3\3\1\0\2\3\1\210\1\3\1\0\2\3\1\0"+
    "\5\3\1\0\3\14\2\3\27\14\1\0\1\3\27\u0103"+
    "\2\3\23\0\1\346\67\0\1\u0105\37\0\1\141\30\0"+
    "\1\141\12\0\2\77\1\100\1\u0106\16\0\1\72\106\0"+
    "\1\351\127\0\1\76\30\0\1\76\34\0\1\30\127\0"+
    "\1\103\30\0\1\103\12\0\2\77\1\100\17\0\1\33"+
    "\106\0\1\357\67\0\1\u0107\37\0\1\156\30\0\1\156"+
    "\15\0\1\u0108\16\0\1\111\114\0\1\234\30\0\1\234"+
    "\30\0\1\u0109\106\0\1\315\20\0\15\240\1\u010a\11\240"+
    "\2\0\15\240\1\u010a\11\240\6\0\1\315\20\0\4\240"+
    "\1\317\22\240\2\0\4\240\1\317\22\240\6\0\1\315"+
    "\20\0\15\240\1\u010b\11\240\2\0\15\240\1\u010b\11\240"+
    "\6\0\1\315\20\0\12\240\1\u010c\14\240\2\0\12\240"+
    "\1\u010c\14\240\6\0\1\315\20\0\22\240\1\u010d\4\240"+
    "\2\0\22\240\1\u010d\4\240\6\0\1\315\20\0\7\240"+
    "\1\314\17\240\2\0\7\240\1\314\17\240\6\0\1\315"+
    "\20\0\22\240\1\314\4\240\2\0\22\240\1\314\4\240"+
    "\3\0\2\303\1\304\1\307\20\0\20\240\1\u010e\1\313"+
    "\4\240\1\314\2\0\20\240\1\u010e\1\313\4\240\1\314"+
    "\6\0\1\315\20\0\21\240\1\313\5\240\2\0\21\240"+
    "\1\313\5\240\6\0\1\315\20\0\12\240\1\312\14\240"+
    "\2\0\12\240\1\312\14\240\2\0\1\3\1\0\2\3"+
    "\1\56\1\3\1\0\2\3\1\0\5\3\1\0\3\14"+
    "\2\3\4\14\1\200\22\14\1\0\1\3\4\14\1\200"+
    "\22\14\2\3\1\0\2\303\1\304\1\305\13\0\3\u0100"+
    "\2\0\27\u0100\2\0\27\u0100\3\0\2\303\1\304\1\307"+
    "\13\0\3\u0100\2\0\27\u0101\2\0\27\u0101\6\0\1\u010f"+
    "\102\0\1\3\1\0\2\3\1\203\1\3\1\0\2\3"+
    "\1\0\5\3\1\0\3\14\2\3\27\14\1\0\1\3"+
    "\27\u0110\3\3\1\0\2\3\1\203\1\3\1\0\2\3"+
    "\1\0\5\3\1\0\3\14\2\3\4\14\1\200\22\14"+
    "\1\0\1\3\4\u0110\1\u0111\22\u0110\2\3\44\0\1\141"+
    "\30\0\1\141\12\0\2\77\1\100\17\0\1\72\127\0"+
    "\1\156\30\0\1\156\15\0\1\153\16\0\1\111\1\0"+
    "\27\223\2\0\27\223\27\0\27\u0112\2\0\27\u0112\6\0"+
    "\1\315\20\0\20\240\1\u0113\6\240\2\0\20\240\1\u0113"+
    "\6\240\6\0\1\315\20\0\20\240\1\313\6\240\2\0"+
    "\20\240\1\313\6\240\6\0\1\315\20\0\23\240\1\u0113"+
    "\3\240\2\0\23\240\1\u0113\3\240\6\0\1\315\20\0"+
    "\4\240\1\u0114\22\240\2\0\4\240\1\u0114\22\240\6\0"+
    "\1\315\20\0\4\240\1\u0115\22\240\2\0\4\240\1\u0115"+
    "\22\240\2\0\1\3\1\0\2\3\1\203\1\3\1\0"+
    "\2\3\1\0\5\3\1\0\3\14\2\3\27\14\1\0"+
    "\1\3\27\u0116\3\3\1\0\2\3\1\210\1\3\1\0"+
    "\2\3\1\0\5\3\1\0\3\14\2\3\27\14\1\0"+
    "\1\3\27\u0116\2\3\4\0\1\u0117\20\0\27\u0112\2\0"+
    "\27\u0112\6\0\1\315\20\0\3\240\1\u0118\23\240\2\0"+
    "\3\240\1\u0118\23\240\6\0\1\315\20\0\20\240\1\332"+
    "\6\240\2\0\20\240\1\332\6\240\3\0\2\303\1\304"+
    "\1\307\20\0\5\240\1\366\21\240\2\0\5\240\1\366"+
    "\21\240\2\0\1\3\1\0\2\3\1\203\1\3\1\0"+
    "\2\3\1\0\5\3\1\0\3\14\2\3\27\14\1\0"+
    "\1\3\27\u0119\2\3\15\0\1\u011a\75\0\1\315\20\0"+
    "\10\240\1\u011b\16\240\2\0\10\240\1\u011b\16\240\2\0"+
    "\1\3\1\0\2\3\1\203\1\3\1\0\2\3\1\0"+
    "\5\3\1\0\3\14\2\3\27\14\1\0\1\3\27\u011c"+
    "\2\3\4\0\1\u011d\106\0\1\315\20\0\14\240\1\u011e"+
    "\12\240\2\0\14\240\1\u011e\12\240\2\0\1\3\1\0"+
    "\2\3\1\203\1\3\1\0\2\3\1\0\5\3\1\0"+
    "\3\14\2\3\27\14\1\0\1\3\27\u011f\2\3\25\0"+
    "\27\u0120\2\0\27\u0120\6\0\1\315\20\0\6\240\1\314"+
    "\20\240\2\0\6\240\1\314\20\240\2\0\1\3\1\0"+
    "\2\3\1\203\1\3\1\0\2\3\1\0\5\3\1\0"+
    "\3\14\2\3\27\14\1\0\1\3\27\u0121\3\3\1\0"+
    "\2\3\1\203\1\3\1\0\2\3\1\0\5\3\1\0"+
    "\3\14\2\3\27\14\1\0\1\3\27\u0122\3\3\1\0"+
    "\2\3\1\203\1\3\1\0\2\3\1\0\5\3\1\0"+
    "\3\14\2\3\27\14\1\0\1\3\27\u0123\3\3\1\0"+
    "\2\3\1\203\1\3\1\0\2\3\1\0\5\3\1\0"+
    "\3\14\2\3\27\14\1\0\1\3\27\u0124\3\3\1\0"+
    "\2\3\1\203\1\3\1\0\2\3\1\0\5\3\1\0"+
    "\3\14\2\3\27\14\1\0\1\3\27\u0125\3\3\1\0"+
    "\2\3\1\203\1\3\1\0\2\3\1\0\5\3\1\0"+
    "\3\14\2\3\27\14\1\0\1\3\27\u0126\3\3\1\0"+
    "\2\3\1\203\1\3\1\0\2\3\1\0\5\3\1\0"+
    "\3\14\2\3\27\14\1\0\1\3\27\u0127\3\3\1\0"+
    "\2\3\1\203\1\3\1\0\2\3\1\0\5\3\1\0"+
    "\3\14\2\3\27\14\1\0\1\3\27\u0128\3\3\1\0"+
    "\2\3\1\203\1\3\1\0\2\3\1\0\5\3\1\0"+
    "\3\14\2\3\27\14\1\0\1\3\27\u0129\3\3\1\0"+
    "\2\3\1\203\1\3\1\0\2\3\1\0\5\3\1\0"+
    "\3\14\2\3\27\14\1\0\1\3\27\u012a\3\3\1\0"+
    "\2\3\1\203\1\3\1\0\2\3\1\0\5\3\1\0"+
    "\3\14\2\3\27\14\1\0\1\3\27\u012b\3\3\1\0"+
    "\2\3\1\203\1\3\1\0\2\3\1\0\5\3\1\0"+
    "\3\14\2\3\27\14\1\0\1\3\27\u012c\3\3\1\0"+
    "\2\3\1\203\1\3\1\0\2\3\1\0\5\3\1\0"+
    "\3\14\2\3\27\14\1\0\1\3\27\u012d\3\3\1\0"+
    "\2\3\1\203\1\3\1\0\2\3\1\0\5\3\1\0"+
    "\3\14\2\3\27\14\1\0\1\3\27\u012e\3\3\1\0"+
    "\2\3\1\203\1\3\1\0\2\3\1\0\5\3\1\0"+
    "\3\14\2\3\27\14\1\0\1\3\27\u012f\3\3\1\0"+
    "\2\3\1\203\1\3\1\0\2\3\1\0\5\3\1\0"+
    "\3\14\2\3\27\14\1\0\1\3\27\u0130\3\3\1\0"+
    "\2\3\1\203\1\3\1\0\2\3\1\0\5\3\1\0"+
    "\3\14\2\3\27\14\1\0\1\3\27\u0131\3\3\1\0"+
    "\2\3\1\203\1\3\1\0\2\3\1\0\5\3\1\0"+
    "\3\14\2\3\27\14\1\0\1\3\27\u0132\3\3\1\0"+
    "\2\3\1\203\1\3\1\0\2\3\1\0\5\3\1\0"+
    "\3\14\2\3\27\14\1\0\1\3\27\14\2\3";

  private static int [] zzUnpackTrans() {
    int [] result = new int[19525];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** Error code for "Unknown internal scanner error". */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  /** Error code for "could not match input". */
  private static final int ZZ_NO_MATCH = 1;
  /** Error code for "pushback value was too large". */
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /**
   * Error messages for {@link #ZZ_UNKNOWN_ERROR}, {@link #ZZ_NO_MATCH}, and
   * {@link #ZZ_PUSHBACK_2BIG} respectively.
   */
  private static final String ZZ_ERROR_MSG[] = {
    "Unknown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state {@code aState}
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\2\0\1\1\1\11\6\1\1\11\14\1\1\11\1\1"+
    "\1\11\1\0\1\11\2\0\1\11\1\0\2\1\1\0"+
    "\1\11\1\0\1\11\5\0\1\11\1\1\1\0\3\1"+
    "\2\11\5\1\1\11\1\1\4\0\1\11\1\1\3\0"+
    "\1\11\6\0\1\11\5\0\2\1\2\0\4\1\1\11"+
    "\5\1\6\0\1\11\4\0\1\11\5\0\1\1\1\0"+
    "\1\11\1\0\1\11\1\0\2\1\7\0\2\1\1\0"+
    "\1\1\1\0\1\1\1\0\2\1\1\0\1\1\3\0"+
    "\1\1\5\0\1\11\3\0\3\1\4\0\15\1\1\0"+
    "\1\1\1\0\1\1\1\0\3\1\3\0\3\1\10\0"+
    "\1\1\1\0\1\11\1\1\1\11\1\0\6\1\1\0"+
    "\20\1\1\0\1\1\2\0\3\1\2\0\1\1\3\0"+
    "\1\1\6\0\1\11\1\0\12\1\1\11\1\1\1\0"+
    "\1\1\1\0\2\1\1\0\1\1\3\0\5\1\1\11"+
    "\7\1\1\0\2\1\1\0\2\1\1\0\25\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[306];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** Input device. */
  private java.io.Reader zzReader;

  /** Current state of the DFA. */
  private int zzState;

  /** Current lexical state. */
  private int zzLexicalState = YYINITIAL;

  /**
   * This buffer contains the current text to be matched and is the source of the {@link #yytext()}
   * string.
   */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** Text position at the last accepting state. */
  private int zzMarkedPos;

  /** Current text position in the buffer. */
  private int zzCurrentPos;

  /** Marks the beginning of the {@link #yytext()} string in the buffer. */
  private int zzStartRead;

  /** Marks the last character in the buffer, that has been read from input. */
  private int zzEndRead;

  /**
   * Whether the scanner is at the end of file.
   * @see #yyatEOF
   */
  private boolean zzAtEOF;

  /**
   * The number of occupied positions in {@link #zzBuffer} beyond {@link #zzEndRead}.
   *
   * <p>When a lead/high surrogate has been read from the input stream into the final
   * {@link #zzBuffer} position, this will have a value of 1; otherwise, it will have a value of 0.
   */
  private int zzFinalHighSurrogate = 0;

  /** Number of newlines encountered up to the start of the matched text. */
  @SuppressWarnings("unused")
  private int yyline;

  /** Number of characters from the last newline up to the start of the matched text. */
  @SuppressWarnings("unused")
  private int yycolumn;

  /** Number of characters up to the start of the matched text. */
  @SuppressWarnings("unused")
  private long yychar;

  /** Whether the scanner is currently at the beginning of a line. */
  @SuppressWarnings("unused")
  private boolean zzAtBOL = true;

  /** Whether the user-EOF-code has already been executed. */
  @SuppressWarnings("unused")
  private boolean zzEOFDone;

  /* user code: */

/*
"'T WAS"
{ return("'TWAS"); }
"'T was"
{ return("'Twas"); }
"'t was"
{ return("'twas"); }
"'T IS"
{ return("'TIS"); }
"'T is"
{ return("'Tis"); }
"'t is"
{ return("'tis"); }
*/

  private static String removeWhite(String in) {
    StringBuilder out = new StringBuilder();
    for (int i = 0, len = in.length(); i < len; i++) {
      char ch = in.charAt(i);
      if (ch != ' ') {
        out.append(ch);
      }
    }
    return out.toString();
  }



  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  PTB2TextLexer(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Translates raw input code points to DFA table row
   */
  private static int zzCMap(int input) {
    int offset = input & 255;
    return offset == input ? ZZ_CMAP_BLOCKS[offset] : ZZ_CMAP_BLOCKS[ZZ_CMAP_TOP[input >> 8] | offset];
  }

  /**
   * Refills the input buffer.
   *
   * @return {@code false} iff there was new input.
   * @exception java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead - zzStartRead);

      /* translate stored positions */
      zzEndRead -= zzStartRead;
      zzCurrentPos -= zzStartRead;
      zzMarkedPos -= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length - zzFinalHighSurrogate) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzBuffer.length * 2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
    }

    /* fill the buffer with new input */
    int requested = zzBuffer.length - zzEndRead;
    int numRead = zzReader.read(zzBuffer, zzEndRead, requested);

    /* not supposed to occur according to specification of java.io.Reader */
    if (numRead == 0) {
      throw new java.io.IOException(
          "Reader returned 0 characters. See JFlex examples/zero-reader for a workaround.");
    }
    if (numRead > 0) {
      zzEndRead += numRead;
      if (Character.isHighSurrogate(zzBuffer[zzEndRead - 1])) {
        if (numRead == requested) { // We requested too few chars to encode a full Unicode character
          --zzEndRead;
          zzFinalHighSurrogate = 1;
        } else {                    // There is room in the buffer for at least one more char
          int c = zzReader.read();  // Expecting to read a paired low surrogate char
          if (c == -1) {
            return true;
          } else {
            zzBuffer[zzEndRead++] = (char)c;
          }
        }
      }
      /* potentially more input available */
      return false;
    }

    /* numRead < 0 ==> end of stream */
    return true;
  }


  /**
   * Closes the input reader.
   *
   * @throws java.io.IOException if the reader could not be closed.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true; // indicate end of file
    zzEndRead = zzStartRead; // invalidate buffer

    if (zzReader != null) {
      zzReader.close();
    }
  }


  /**
   * Resets the scanner to read from a new input stream.
   *
   * <p>Does not close the old reader.
   *
   * <p>All internal variables are reset, the old input stream <b>cannot</b> be reused (internal
   * buffer is discarded and lost). Lexical state is set to {@code ZZ_INITIAL}.
   *
   * <p>Internal scan buffer is resized down to its initial length, if it has grown.
   *
   * @param reader The new input stream.
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzEOFDone = false;
    yyResetPosition();
    zzLexicalState = YYINITIAL;
    if (zzBuffer.length > ZZ_BUFFERSIZE) {
      zzBuffer = new char[ZZ_BUFFERSIZE];
    }
  }

  /**
   * Resets the input position.
   */
  private final void yyResetPosition() {
      zzAtBOL  = true;
      zzAtEOF  = false;
      zzCurrentPos = 0;
      zzMarkedPos = 0;
      zzStartRead = 0;
      zzEndRead = 0;
      zzFinalHighSurrogate = 0;
      yyline = 0;
      yycolumn = 0;
      yychar = 0L;
  }


  /**
   * Returns whether the scanner has reached the end of the reader it reads from.
   *
   * @return whether the scanner has reached EOF.
   */
  public final boolean yyatEOF() {
    return zzAtEOF;
  }


  /**
   * Returns the current lexical state.
   *
   * @return the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state.
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   *
   * @return the matched text.
   */
  public final String yytext() {
    return new String(zzBuffer, zzStartRead, zzMarkedPos-zzStartRead);
  }


  /**
   * Returns the character at the given position from the matched text.
   *
   * <p>It is equivalent to {@code yytext().charAt(pos)}, but faster.
   *
   * @param position the position of the character to fetch. A value from 0 to {@code yylength()-1}.
   *
   * @return the character at {@code position}.
   */
  public final char yycharat(int position) {
    return zzBuffer[zzStartRead + position];
  }


  /**
   * How many characters were matched.
   *
   * @return the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occurred while scanning.
   *
   * <p>In a well-formed scanner (no or only correct usage of {@code yypushback(int)} and a
   * match-all fallback rule) this method will only be called with things that
   * "Can't Possibly Happen".
   *
   * <p>If this method is called, something is seriously wrong (e.g. a JFlex bug producing a faulty
   * scanner etc.).
   *
   * <p>Usual syntax/scanner level error handling should be done in error fallback rules.
   *
   * @param errorCode the code of the error message to display.
   */
  private static void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    } catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  }


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * <p>They will be read again by then next call of the scanning method.
   *
   * @param number the number of characters to be read again. This number must not be greater than
   *     {@link #yylength()}.
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }




  /**
   * Resumes scanning until the next regular expression is matched, the end of input is encountered
   * or an I/O-Error occurs.
   *
   * @return the next token.
   * @exception java.io.IOException if any I/O-Error occurs.
   */
  public String next() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char[] zzBufferL = zzBuffer;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {

          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMap(zzInput) ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
              {
                return null;
              }
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1:
            { return(yytext());
            }
            // fall through
          case 31: break;
          case 2:
            { yybegin(YYINITIAL); return(yytext());
            }
            // fall through
          case 32: break;
          case 3:
            { yybegin(INQUOTE); return "\"";
            }
            // fall through
          case 33: break;
          case 4:
            { return "&";
            }
            // fall through
          case 34: break;
          case 5:
            { return yytext();
            }
            // fall through
          case 35: break;
          case 6:
            { yybegin(YYINITIAL); return "\"";
            }
            // fall through
          case 36: break;
          case 7:
            { return(yytext().substring(1, yytext().length()));
            }
            // fall through
          case 37: break;
          case 8:
            { return("%");
            }
            // fall through
          case 38: break;
          case 9:
            { return(")");
            }
            // fall through
          case 39: break;
          case 10:
            { return("}");
            }
            // fall through
          case 40: break;
          case 11:
            { return("$");
            }
            // fall through
          case 41: break;
          case 12:
            { return "(";
            }
            // fall through
          case 42: break;
          case 13:
            { return "/";
            }
            // fall through
          case 43: break;
          case 14:
            { return("`");
            }
            // fall through
          case 44: break;
          case 15:
            { return("{");
            }
            // fall through
          case 45: break;
          case 16:
            // lookahead expression with fixed lookahead length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL, zzStartRead, zzEndRead - zzStartRead, zzMarkedPos, -1);
            { return "\"";
            }
            // fall through
          case 46: break;
          case 17:
            { return "\"";
            }
            // fall through
          case 47: break;
          case 18:
            // lookahead expression with fixed lookahead length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL, zzStartRead, zzEndRead - zzStartRead, zzMarkedPos, -1);
            { yybegin(INQUOTE); return "\"";
            }
            // fall through
          case 48: break;
          case 19:
            { return("\"");
            }
            // fall through
          case 49: break;
          case 20:
            // lookahead expression with fixed lookahead length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL, zzStartRead, zzEndRead - zzStartRead, zzMarkedPos, -2);
            { return "\"";
            }
            // fall through
          case 50: break;
          case 21:
            { return("n't");
            }
            // fall through
          case 51: break;
          case 22:
            { return ">";
            }
            // fall through
          case 52: break;
          case 23:
            { return "<";
            }
            // fall through
          case 53: break;
          case 24:
            // lookahead expression with fixed lookahead length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL, zzStartRead, zzEndRead - zzStartRead, zzMarkedPos, -1);
            { yybegin(INQUOTE); return "\" \"";
            }
            // fall through
          case 54: break;
          case 25:
            { return removeWhite(yytext());
            }
            // fall through
          case 55: break;
          case 26:
            // lookahead expression with fixed lookahead length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL, zzStartRead, zzEndRead - zzStartRead, zzMarkedPos, -1);
            { return yytext();
            }
            // fall through
          case 56: break;
          case 27:
            // lookahead expression with fixed lookahead length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL, zzStartRead, zzEndRead - zzStartRead, zzMarkedPos, -1);
            { return yytext();
            }
            // fall through
          case 57: break;
          case 28:
            // lookahead expression with fixed lookahead length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL, zzStartRead, zzEndRead - zzStartRead, zzMarkedPos, -2);
            { return yytext();
            }
            // fall through
          case 58: break;
          case 29:
            { return "cannot";
            }
            // fall through
          case 59: break;
          case 30:
            // lookahead expression with fixed lookahead length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL, zzStartRead, zzEndRead - zzStartRead, zzMarkedPos, -1);
            { return removeWhite(yytext());
            }
            // fall through
          case 60: break;
          default:
            zzScanError(ZZ_NO_MATCH);
        }
      }
    }
  }


}
