/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

public final class Characters {
    private Characters() {
    }

    public static Character getCharacter(char c) {
        return Character.valueOf(c);
    }

    public static Character[] asCharacterArray(String s) {
        Character[] split = new Character[s.length()];
        for (int i = 0; i < split.length; ++i) {
            split[i] = Characters.getCharacter(s.charAt(i));
        }
        return split;
    }

    public static String unicodeBlockStringOf(char c) {
        Character.UnicodeBlock block = Character.UnicodeBlock.of(c);
        return block == null ? "Undefined" : block.toString();
    }

    public static String unicodeBlockStringOf(int codePoint) {
        Character.UnicodeBlock block = Character.UnicodeBlock.of(codePoint);
        return block == null ? "Undefined" : block.toString();
    }

    public static boolean isPunctuation(char c) {
        int cType = Character.getType(c);
        return cType == 21 || cType == 22 || cType == 24 || cType == 23 || cType == 20 || cType == 29 || cType == 30;
    }

    public static boolean isSymbol(char c) {
        int cType = Character.getType(c);
        return cType == 25 || cType == 26 || cType == 27 || cType == 28;
    }

    public static boolean isControl(char c) {
        return Character.getType(c) == 15;
    }
}

