/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.tagger.maxent.Dictionary;
import edu.stanford.nlp.tagger.maxent.History;
import edu.stanford.nlp.tagger.maxent.MaxentTagger;
import edu.stanford.nlp.tagger.maxent.PairsHolder;
import edu.stanford.nlp.tagger.maxent.RareExtractor;

class ExtractorMidSentenceCapC
extends RareExtractor {
    private transient Dictionary dict;
    private static final long serialVersionUID = 26L;

    @Override
    protected void setGlobalHolder(MaxentTagger tagger) {
        this.dict = tagger.dict;
    }

    @Override
    String extract(History h, PairsHolder pH) {
        String prevTag = pH.getTag(h, -1);
        if (prevTag == null || prevTag.equals("NA")) {
            return "0";
        }
        String s = pH.getWord(h, 0);
        if (ExtractorMidSentenceCapC.startsUpperCase(s)) {
            String s1 = s.toLowerCase();
            if (this.dict.isUnknown(s1)) {
                return "0";
            }
            return this.dict.getFirstTag(s1);
        }
        return "0";
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public boolean isDynamic() {
        return true;
    }
}

