/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.classify;

import edu.stanford.nlp.classify.Dataset;
import edu.stanford.nlp.classify.GeneralDataset;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.Triple;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.ToDoubleFunction;

public class CrossValidator<L, F> {
    private final GeneralDataset<L, F> originalTrainData;
    private final int kFold;
    private final SavedState[] savedStates;

    public CrossValidator(GeneralDataset<L, F> trainData) {
        this(trainData, 10);
    }

    public CrossValidator(GeneralDataset<L, F> trainData, int kFold) {
        this.originalTrainData = trainData;
        this.kFold = kFold;
        this.savedStates = new SavedState[kFold];
        for (int i = 0; i < this.savedStates.length; ++i) {
            this.savedStates[i] = new SavedState();
        }
    }

    private Iterator<Triple<GeneralDataset<L, F>, GeneralDataset<L, F>, SavedState>> iterator() {
        return new CrossValidationIterator();
    }

    public double computeAverage(ToDoubleFunction<Triple<GeneralDataset<L, F>, GeneralDataset<L, F>, SavedState>> function) {
        double sum = 0.0;
        Iterator<Triple<GeneralDataset<L, F>, GeneralDataset<L, F>, SavedState>> foldIt = this.iterator();
        while (foldIt.hasNext()) {
            sum += function.applyAsDouble(foldIt.next());
        }
        return sum / (double)this.kFold;
    }

    public static void main(String[] args) {
        Dataset<String, String> d = Dataset.readSVMLightFormat(args[0]);
        Iterator<Triple<GeneralDataset<String, String>, GeneralDataset<String, String>, SavedState>> it = super.iterator();
        while (it.hasNext()) {
            it.next();
        }
    }

    public static class SavedState {
        public Object state;
    }

    class CrossValidationIterator
    implements Iterator<Triple<GeneralDataset<L, F>, GeneralDataset<L, F>, SavedState>> {
        private int iter = 0;

        CrossValidationIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.iter < CrossValidator.this.kFold;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("CrossValidationIterator doesn't support remove()");
        }

        @Override
        public Triple<GeneralDataset<L, F>, GeneralDataset<L, F>, SavedState> next() {
            if (this.iter == CrossValidator.this.kFold) {
                throw new NoSuchElementException("CrossValidatorIterator exhausted.");
            }
            int start = CrossValidator.this.originalTrainData.size() * this.iter / CrossValidator.this.kFold;
            int end = CrossValidator.this.originalTrainData.size() * (this.iter + 1) / CrossValidator.this.kFold;
            Pair split = CrossValidator.this.originalTrainData.split(start, end);
            return new Triple(split.first(), split.second(), CrossValidator.this.savedStates[this.iter++]);
        }
    }
}

