/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.tagger.maxent.Dictionary;
import edu.stanford.nlp.tagger.maxent.TTags;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AmbiguityClass {
    private final List<Integer> sortedIds;
    private final String key;
    private final String word;
    private final boolean single;

    protected AmbiguityClass(String word, boolean single, Dictionary dict, TTags ttags) {
        this.single = single;
        if (single) {
            this.word = word;
            this.sortedIds = Collections.emptyList();
        } else {
            this.word = null;
            String[] tags = dict.getTags(word);
            this.sortedIds = new ArrayList<Integer>(tags.length);
            for (String tag : tags) {
                this.add(ttags.getIndex(tag));
            }
        }
        this.key = this.toString();
    }

    public String getWord() {
        return this.word;
    }

    private boolean add(int tagId) {
        for (int j = 0; j < this.sortedIds.size(); ++j) {
            if (tagId < this.sortedIds.get(j)) {
                this.sortedIds.add(j, tagId);
                return true;
            }
            if (tagId != this.sortedIds.get(j)) continue;
            return false;
        }
        this.sortedIds.add(tagId);
        return true;
    }

    public String toString() {
        if (this.single) {
            return this.word;
        }
        StringBuilder sb = new StringBuilder();
        for (Integer sID : this.sortedIds) {
            sb.append(':').append(sID);
        }
        return sb.toString();
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof AmbiguityClass && this.key.equals(((AmbiguityClass)o).key);
    }
}

