/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.CollectionFactory;
import edu.stanford.nlp.util.ErasureUtils;
import edu.stanford.nlp.util.Generics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class Maps {
    private Maps() {
    }

    public static <K, V> void putIntoValueHashSet(Map<K, Set<V>> map, K key, V value) {
        CollectionFactory factory = CollectionFactory.hashSetFactory();
        Maps.putIntoValueCollection(map, key, value, factory);
    }

    public static <K, V> void putIntoValueArrayList(Map<K, List<V>> map, K key, V value) {
        CollectionFactory factory = CollectionFactory.arrayListFactory();
        Maps.putIntoValueCollection(map, key, value, factory);
    }

    public static <K, V, C extends Collection<V>> void putIntoValueCollection(Map<K, C> map, K key, V value, CollectionFactory<V> cf) {
        Collection c = (Collection)map.get(key);
        if (c == null) {
            c = (Collection)ErasureUtils.uncheckedCast(cf.newCollection());
            map.put(key, c);
        }
        c.add(value);
    }

    public static <X, Y, Z> Map<X, Z> compose(Map<X, Y> map1, Map<Y, Z> map2) {
        Map<X, Z> composedMap = Generics.newHashMap();
        for (X key : map1.keySet()) {
            composedMap.put(key, map2.get(map1.get(key)));
        }
        return composedMap;
    }

    public static <X, Y> Map<Y, X> invert(Map<X, Y> map) {
        Map<Y, X> invertedMap = Generics.newHashMap();
        for (Map.Entry<X, Y> entry : map.entrySet()) {
            X key = entry.getKey();
            Y value = entry.getValue();
            invertedMap.put(value, key);
        }
        return invertedMap;
    }

    public static <X, Y> Map<Y, Set<X>> invertSet(Map<X, Y> map) {
        Map invertedMap = Generics.newHashMap();
        for (Map.Entry<X, Y> entry : map.entrySet()) {
            X key = entry.getKey();
            Y value = entry.getValue();
            Maps.putIntoValueHashSet(invertedMap, value, key);
        }
        return invertedMap;
    }

    public static <K extends Comparable<? super K>, V> List<Map.Entry<K, V>> sortedEntries(Collection<Map.Entry<K, V>> entries) {
        ArrayList<Map.Entry<K, V>> entriesList = new ArrayList<Map.Entry<K, V>>(entries);
        Collections.sort(entriesList, (e1, e2) -> ((Comparable)e1.getKey()).compareTo(e2.getKey()));
        return entriesList;
    }

    public static <K extends Comparable<? super K>, V> List<Map.Entry<K, V>> sortedEntries(Map<K, V> map) {
        return Maps.sortedEntries(map.entrySet());
    }

    public static <K extends Comparable<K>, V> void toStringSorted(Map<K, V> map, StringBuilder builder) {
        builder.append("{");
        List<Map.Entry<K, V>> sortedProperties = Maps.sortedEntries(map);
        int index = 0;
        for (Map.Entry<K, V> entry : sortedProperties) {
            if (index > 0) {
                builder.append(", ");
            }
            builder.append(entry.getKey()).append("=").append(entry.getValue());
            ++index;
        }
        builder.append("}");
    }

    public static <K extends Comparable<K>, V> String toStringSorted(Map<K, V> map) {
        StringBuilder builder = new StringBuilder();
        Maps.toStringSorted(map, builder);
        return builder.toString();
    }

    public static <K, V> void removeKeys(Map<K, V> map, Collection<K> removekeys) {
        for (K k : removekeys) {
            map.remove(k);
        }
    }

    public static <K, V1, V2> void addAll(Map<K, V1> to, Map<K, V2> from, Function<V2, V1> function) {
        for (Map.Entry<K, V2> entry : from.entrySet()) {
            to.put(entry.getKey(), function.apply(entry.getValue()));
        }
    }

    public static <T, V> Map<T, V> getAll(Map<T, V> map, Collection<T> indices) {
        HashMap<T, V> result = new HashMap<T, V>();
        for (T i : indices) {
            if (!map.containsKey(i)) continue;
            result.put(i, map.get(i));
        }
        return result;
    }

    public static <T, V> String toString(Map<T, V> map, String preAppend, String postAppend, String keyValSeparator, String itemSeparator) {
        StringBuilder sb = new StringBuilder();
        sb.append(preAppend);
        int i = 0;
        for (Map.Entry<T, V> en : map.entrySet()) {
            if (i != 0) {
                sb.append(itemSeparator);
            }
            sb.append(en.getKey());
            sb.append(keyValSeparator);
            sb.append(en.getValue());
            ++i;
        }
        sb.append(postAppend);
        return sb.toString();
    }

    public static void main(String[] args) {
        Map<String, String> map1 = Generics.newHashMap();
        map1.put("a", "1");
        map1.put("b", "2");
        map1.put("c", "2");
        map1.put("d", "4");
        Map<String, String> map2 = Generics.newHashMap();
        map2.put("1", "x");
        map2.put("2", "y");
        map2.put("3", "z");
        System.out.println("map1: " + map1);
        System.out.println("invert(map1): " + Maps.invert(map1));
        System.out.println("invertSet(map1): " + Maps.invertSet(map1));
        System.out.println("map2: " + map2);
        System.out.println("compose(map1,map2): " + Maps.compose(map1, map2));
        Map setValues = Generics.newHashMap();
        Map listValues = Generics.newHashMap();
        Maps.putIntoValueArrayList(listValues, "a", "1");
        Maps.putIntoValueArrayList(listValues, "a", "1");
        Maps.putIntoValueArrayList(listValues, "a", "2");
        Maps.putIntoValueHashSet(setValues, "a", "1");
        Maps.putIntoValueHashSet(setValues, "a", "1");
        Maps.putIntoValueHashSet(setValues, "a", "2");
        System.out.println("listValues: " + listValues);
        System.out.println("setValues: " + setValues);
    }
}

