/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.random;

import com.pholser.junit.quickcheck.internal.Ranges;
import java.math.BigInteger;
import java.util.Random;

public class SourceOfRandomness {
    private final Random delegate;

    public SourceOfRandomness(Random delegate) {
        this.delegate = delegate;
    }

    public boolean nextBoolean() {
        return this.delegate.nextBoolean();
    }

    public void nextBytes(byte[] bytes) {
        this.delegate.nextBytes(bytes);
    }

    public byte[] nextBytes(int count) {
        byte[] buffer = new byte[count];
        this.delegate.nextBytes(buffer);
        return buffer;
    }

    public double nextDouble() {
        return this.delegate.nextDouble();
    }

    public float nextFloat() {
        return this.delegate.nextFloat();
    }

    public double nextGaussian() {
        return this.delegate.nextGaussian();
    }

    public int nextInt() {
        return this.delegate.nextInt();
    }

    public int nextInt(int n) {
        return this.delegate.nextInt(n);
    }

    public long nextLong() {
        return this.delegate.nextLong();
    }

    public void setSeed(long seed) {
        this.delegate.setSeed(seed);
    }

    public byte nextByte(byte min, byte max) {
        return (byte)this.nextLong(min, max);
    }

    public char nextChar(char min, char max) {
        Ranges.checkRange(Ranges.Type.CHARACTER, Character.valueOf(min), Character.valueOf(max));
        return (char)this.nextLong(min, max);
    }

    public double nextDouble(double min, double max) {
        int comparison = Ranges.checkRange(Ranges.Type.FLOAT, min, max);
        return comparison == 0 ? min : min + (max - min) * this.nextDouble();
    }

    public float nextFloat(float min, float max) {
        int comparison = Ranges.checkRange(Ranges.Type.FLOAT, Float.valueOf(min), Float.valueOf(max));
        return comparison == 0 ? min : min + (max - min) * this.nextFloat();
    }

    public int nextInt(int min, int max) {
        return (int)this.nextLong(min, max);
    }

    public long nextLong(long min, long max) {
        int comparison = Ranges.checkRange(Ranges.Type.INTEGRAL, min, max);
        if (comparison == 0) {
            return min;
        }
        return Ranges.choose(this, BigInteger.valueOf(min), BigInteger.valueOf(max)).longValue();
    }

    public short nextShort(short min, short max) {
        return (short)this.nextLong(min, max);
    }

    public BigInteger nextBigInteger(int numberOfBits) {
        return new BigInteger(numberOfBits, this.delegate);
    }
}

