/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.config.java.plugin.context;

import org.springframework.jmx.support.MBeanRegistrationSupport;


/**
 * Indicates registration behavior when attempting to register an MBean that
 * already exists.
 *
 * @see MBeanExport#registration()
 *
 * @author Chris Beams
 */
public enum RegistrationPolicy {
    /** Fail with an exception */
    FAIL_ON_EXISTING(MBeanRegistrationSupport.REGISTRATION_FAIL_ON_EXISTING),

    /** Ignore new MBean, keep the existing one */
    IGNORE_EXISTING(MBeanRegistrationSupport.REGISTRATION_IGNORE_EXISTING),

    /** Replace existing MBean with the new one */
    REPLACE_EXISTING(MBeanRegistrationSupport.REGISTRATION_REPLACE_EXISTING);

    private final int policyCode;

    RegistrationPolicy(int policyCode) {
        this.policyCode = policyCode;
    }

    /**
     * Returns integer associated with constants in {@link MBeanRegistrationSupport}
     *
     * @see MBeanRegistrationSupport#REGISTRATION_FAIL_ON_EXISTING
     * @see MBeanRegistrationSupport#REGISTRATION_IGNORE_EXISTING
     * @see MBeanRegistrationSupport#REGISTRATION_REPLACE_EXISTING
     */
    public int getPolicyCode() {
        return policyCode;
    }

}
