/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.config.java.internal.model;

import static java.lang.String.format;

import org.springframework.config.java.annotation.Bean;
import org.springframework.config.java.model.ModelMethod;

import java.lang.annotation.Annotation;

import java.util.List;


/** TODO: JAVADOC */
public class NonJavaConfigMethod extends ModelMethod implements ValidatableMethod {

    public NonJavaConfigMethod(String name, int modifiers, Annotation... annotations) {
        super(name, modifiers, annotations);
    }

    NonJavaConfigMethod(String name) { this(name, 0); }

    public void detectUsageErrors(List<UsageError> errors) {
        for (Annotation anno : getAnnotations())
            errors.add(new InvalidAnnotationDeclarationError(anno));
    }


    public class InvalidAnnotationDeclarationError extends UsageError {
        private final Annotation invalidAnno;

        public InvalidAnnotationDeclarationError(Annotation invalidAnno) {
            super(getDeclaringClass(), getLineNumber());
            this.invalidAnno = invalidAnno;
        }

        @Override
        public String getDescription() {
            return format("Illegal placement of @%s annotation on method %s. "
                          + "Perhaps you meant for this method to be a @%s method? "
                          + "Remove the offending annotation or fix the declaration so it is compliant.",
                          invalidAnno.annotationType().getSimpleName(), getName(), Bean.class.getSimpleName());
        }
    }

}
