/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.config.java.context;

import org.springframework.config.java.annotation.Configuration;
import org.springframework.config.java.internal.factory.TypeSafeBeanFactory;

import org.springframework.context.ConfigurableApplicationContext;


public interface ConfigurableJavaConfigApplicationContext extends ConfigurableApplicationContext, TypeSafeBeanFactory {

    /**
     * Allows for incrementally building up the configuration classes to be processed by this
     * context. May only be called on a context still 'open for configuration' meaning that the user
     * will need to manually call refresh() after all classes have been added.
     *
     * @param  configClass a class annotated with {@link Configuration}
     */
    void addConfigClass(Class<?> configClass);

    /**
     * Allows for incrementally building up the base packages to be scanned by this
     * context. Packages are presumed to have one or more {@link Configuration} class
     * definitions within, but it is not considered an error if none are found.
     * 
     * This method may only be called on a context still 'open for configuration' meaning
     * that the user will need to manually call refresh() after all base packages have been
     * added.
     *
     * @param  basePackage a package to scan (recursively) for any classes annotated with
     *         {@link Configuration}
     */
    void addBasePackage(String basePackage);
}
