/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.config.java.annotation.valuesource;

import java.lang.annotation.Annotation;

import org.springframework.beans.factory.HierarchicalBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultBeanNameGenerator;
import org.springframework.config.java.plugin.ConfigurationPlugin;


/** TODO: JAVADOC */
abstract class AbstractValueSourceHandler<A extends Annotation> implements ConfigurationPlugin<A> {

    public final void handle(A annotation, BeanDefinitionRegistry registry) {
        BeanDefinition beanDef = doHandle(annotation, registry);

        // workaround related to hidden beans
        if(registry instanceof HierarchicalBeanFactory)
            if(((HierarchicalBeanFactory)registry).getParentBeanFactory() instanceof BeanDefinitionRegistry)
                registry = (BeanDefinitionRegistry)((HierarchicalBeanFactory)registry).getParentBeanFactory();

        // generate a unique bean name for this resolver
        String beanName =
            new DefaultBeanNameGenerator().generateBeanName(beanDef, registry);

        registry.registerBeanDefinition(beanName, beanDef);
    }

    abstract BeanDefinition doHandle(A annotation, BeanDefinitionRegistry registry);
}
