/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.samples.petclinic.jpa;

import java.util.List;

import org.springframework.samples.petclinic.aspects.UsageLogAspect;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.config.java.test.JavaConfigContextLoader;
import org.springframework.beans.factory.annotation.Autowired;
import org.junit.Test;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

/**
 * <p>
 * Tests for the DAO variant based on the shared EntityManager approach. Uses
 * TopLink Essentials (the reference implementation) for testing.
 * </p>
 * <p>
 * Specifically tests usage of an <code>orm.xml</code> file, loaded by the
 * persistence provider through the Spring-provided persistence unit root URL.
 * </p>
 *
 * @author Rod Johnson
 * @author Juergen Hoeller
 */
@ContextConfiguration(locations = "org.springframework.samples.petclinic.config.JpaPetclinicApplicationConfig",
        loader = JavaConfigContextLoader.class)
public class EntityManagerClinicTests extends AbstractJpaClinicTests {

    @Autowired
    private UsageLogAspect usageLogAspect;

    public void setUsageLogAspect(UsageLogAspect usageLogAspect) {
        this.usageLogAspect = usageLogAspect;
    }

    @Test
    public void testUsageLogAspectIsInvoked() {
        String name1 = "Schuurman";
        String name2 = "Greenwood";
        String name3 = "Leau";

        assertTrue(this.clinic.findOwners(name1).isEmpty());
        assertTrue(this.clinic.findOwners(name2).isEmpty());

        List<String> namesRequested = this.usageLogAspect.getNamesRequested();
        assertTrue(namesRequested.contains(name1));
        assertTrue(namesRequested.contains(name2));
        assertFalse(namesRequested.contains(name3));
    }
}
