/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package test.feature.xmlbootstrap.txmgmt;

import org.junit.Test;

import org.springframework.config.java.annotation.Bean;
import org.springframework.config.java.annotation.Configuration;

import org.springframework.context.support.ClassPathXmlApplicationContext;

import org.springframework.jdbc.datasource.UserCredentialsDataSourceAdapter;

import javax.sql.DataSource;


/** TODO: JAVADOC */
public class TxAnnotationTests {

    @Test
    public void testTxProxyingWithJavaConfigDependingOnXml() {
        ClassPathXmlApplicationContext ac = new ClassPathXmlApplicationContext("txannotations.xml", getClass());
        ac.getBean("myApplicationBean");
    }

    @Configuration
    public static class SampleConfig {

        private DataSource genericDataSource;

        private String password;

        private String username;

        public void setGenericDataSource(DataSource genericDataSource) { this.genericDataSource = genericDataSource; }

        public void setPassword(String password) { this.password = password; }

        public void setUsername(String username) { this.username = username; }

        @Bean
        public DataSource transactionalDataSource() {
            UserCredentialsDataSourceAdapter adapter = new UserCredentialsDataSourceAdapter();
            adapter.setTargetDataSource(genericDataSource);
            adapter.setUsername(username);
            adapter.setPassword(password);

            return adapter;
        }

        @Bean
        public Object myApplicationBean() {
            transactionalDataSource();

            return new Object();
        }
    }

}
