/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package test.feature.xmlbootstrap;

import static org.junit.Assert.assertEquals;

import org.junit.Test;

import org.springframework.beans.factory.BeanFactoryUtils;

import org.springframework.config.java.context.JavaConfigApplicationContext;

import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import test.feature.misc.GetBeansOfTypeTests.PropertiesConfig;


/**
 * System test for using an {@link JavaConfigApplicationContext} as the parent of a
 * {@link ClassPathXmlApplicationContext}.
 *
 * @author  Chris Beams
 * @see     test.feature.misc.ContextHierarchyTests
 */
public class JavaAndXmlContextHierarchyTests {

    @Test
    public void testGetBeansFromJavaAndXml() throws Exception {
        JavaConfigApplicationContext propertiesContext = new JavaConfigApplicationContext(PropertiesConfig.class);
        ApplicationContext xmlCtx =
            new ClassPathXmlApplicationContext(
                new String[] { "JavaAndXmlContextHierarchyTests.xml" }, getClass(), propertiesContext);
        String[] names = BeanFactoryUtils.beanNamesForTypeIncludingAncestors(xmlCtx, java.awt.Point.class);
        assertEquals(2, names.length);
    }

}
