/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package test.feature.plugin.tx.annotationdriven;

import static org.springframework.beans.factory.config.BeanDefinition.ROLE_INFRASTRUCTURE;

import javax.sql.DataSource;

import org.springframework.aop.framework.autoproxy.InfrastructureAdvisorAutoProxyCreator;
import org.springframework.config.java.annotation.Bean;
import org.springframework.config.java.annotation.Configuration;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.annotation.AnnotationTransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionAttributeSourceAdvisor;
import org.springframework.transaction.interceptor.TransactionInterceptor;

import test.common.dataaccess.DummyDataSource;


/**
 * Irreducible configuration that causes the issue tested by
 * {@link MultipleSingletonRegistrationBugTests}
 *
 * @author Chris Beams
 */
@Configuration
class Config {

    @Bean
    public DataSource dataSource() {
        return new DummyDataSource();
    }

    @Bean(role = ROLE_INFRASTRUCTURE)
    public DataSourceTransactionManager transactionManager() {
        return new DataSourceTransactionManager(dataSource());
    }

    @Bean(role = ROLE_INFRASTRUCTURE)
    public AnnotationTransactionAttributeSource transactionAttributeSource() {
        return new AnnotationTransactionAttributeSource();
    }

    @Bean(role = ROLE_INFRASTRUCTURE)
    public TransactionInterceptor transactionInterceptor() {
        return new TransactionInterceptor(transactionManager(), transactionAttributeSource());
    }

    @Bean(role = ROLE_INFRASTRUCTURE)
    public TransactionAttributeSourceAdvisor internalTransactionAdvisor() {
        return new TransactionAttributeSourceAdvisor(transactionInterceptor());
    }

    @Bean(role = ROLE_INFRASTRUCTURE, dependsOn="internalTransactionAdvisor")
    public InfrastructureAdvisorAutoProxyCreator internalAutoProxyCreator() {
        return new InfrastructureAdvisorAutoProxyCreator();
    }

}
