/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package test.feature.lifecycle.bpp.sjc118;


import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.junit.Before;
import org.junit.Test;

import org.springframework.beans.factory.annotation.Autowired;

import org.springframework.context.support.ClassPathXmlApplicationContext;


/** TODO: JAVADOC */
public class BppTests {

    private static final Log logger = LogFactory.getLog(BppTests.class);
    private CustomBean demoBean;

    @Before
    public void setUp() {
        ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext("applicationContext.xml", getClass());
        setDemoBean((CustomBean) ctx.getBean("demoBean"));
    }

    @Autowired
    public void setDemoBean(CustomBean demoBean) { this.demoBean = demoBean; }

    @Test
    public void testBppInjection() {
        if (logger.isInfoEnabled())
            logger.info(demoBean.getMessage());
    }

}
