/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.config.java.annotation.valuesource;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.springframework.config.java.annotation.ExternalValue;
import org.springframework.config.java.plugin.Plugin;

/**
 * Enables resolving {@link ExternalValue} fields/methods against one or more properties files.
 * 
 * @author Chris Beams
 * 
 * @see SystemPropertiesValueSource
 * @see EnvironmentValueSource
 * @see PropertiesValueSourceHandler
 * @see ExternalValue
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
@Documented
@Plugin(handler=PropertiesValueSourceHandler.class)
public @interface PropertiesValueSource {

    String[] locations();

    Class<?> relativeTo() default Object.class;

}
