/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.internal.parsing.asm;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import org.springframework.asm.AnnotationVisitor;
import org.springframework.asm.ClassAdapter;
import org.springframework.asm.ClassReader;
import org.springframework.asm.ClassVisitor;
import org.springframework.asm.MethodVisitor;
import org.springframework.config.java.annotation.Configuration;
import org.springframework.config.java.annotation.Import;
import org.springframework.config.java.internal.model.ConfigurationClass;
import org.springframework.config.java.internal.model.ConfigurationModel;
import org.springframework.config.java.internal.parsing.CircularImportException;
import org.springframework.config.java.internal.parsing.asm.AsmUtils;
import org.springframework.config.java.internal.parsing.asm.ConfigurationClassMethodVisitor;
import org.springframework.config.java.internal.parsing.asm.ImportAnnotationVisitor;
import org.springframework.config.java.internal.parsing.asm.ImportStack;
import org.springframework.config.java.internal.parsing.asm.ImportStackHolder;
import org.springframework.config.java.internal.parsing.asm.MutableAnnotation;
import org.springframework.config.java.internal.parsing.asm.MutableAnnotationUtils;
import org.springframework.config.java.internal.parsing.asm.MutableAnnotationVisitor;
import org.springframework.config.java.plugin.Plugin;
import org.springframework.util.ClassUtils;

class ConfigurationClassVisitor
extends ClassAdapter {
    private static final String OBJECT_DESC = ClassUtils.convertClassNameToResourcePath((String)Object.class.getName());
    private final ConfigurationClass configClass;
    private final ConfigurationModel model;
    private final HashMap<String, ConfigurationClass> innerClasses = new HashMap();
    private boolean processInnerClasses = true;

    public ConfigurationClassVisitor(ConfigurationClass configClass, ConfigurationModel model) {
        super((ClassVisitor)AsmUtils.EMPTY_VISITOR);
        this.configClass = configClass;
        this.model = model;
    }

    public void setProcessInnerClasses(boolean processInnerClasses) {
        this.processInnerClasses = processInnerClasses;
    }

    public void visitSource(String sourceFile, String debug) {
        String resourcePath = ClassUtils.convertClassNameToResourcePath((String)this.configClass.getName()).substring(0, this.configClass.getName().lastIndexOf(46) + 1).concat(sourceFile);
        this.configClass.setSource(resourcePath);
    }

    public void visit(int classVersion, int modifiers, String classTypeDesc, String arg3, String superTypeDesc, String[] arg5) {
        this.visitSuperType(superTypeDesc);
        this.configClass.setName(ClassUtils.convertResourcePathToClassName((String)classTypeDesc));
        this.configClass.setModifiers(modifiers - 32);
    }

    private void visitSuperType(String superTypeDesc) {
        if (OBJECT_DESC.equals(superTypeDesc)) {
            return;
        }
        ConfigurationClassVisitor ccVisitor = new ConfigurationClassVisitor(this.configClass, this.model);
        ClassReader reader = AsmUtils.newClassReader(superTypeDesc);
        reader.accept((ClassVisitor)ccVisitor, false);
    }

    public AnnotationVisitor visitAnnotation(String annoTypeDesc, boolean arg1) {
        String annoTypeName = AsmUtils.convertTypeDescriptorToClassName(annoTypeDesc);
        if (Configuration.class.getName().equals(annoTypeName)) {
            Configuration mutableConfiguration = MutableAnnotationUtils.createMutableAnnotation(Configuration.class);
            this.configClass.setMetadata(mutableConfiguration);
            return new MutableAnnotationVisitor((MutableAnnotation)((Object)mutableConfiguration));
        }
        if (Import.class.getName().equals(annoTypeName)) {
            ImportStack importStack = ImportStackHolder.getImportStack();
            if (importStack.contains(this.configClass)) {
                throw new CircularImportException(this.configClass, importStack);
            }
            importStack.push(this.configClass);
            return new ImportAnnotationVisitor(this.configClass, this.model);
        }
        PluginAnnotationDetectingClassVisitor classVisitor = new PluginAnnotationDetectingClassVisitor();
        String className = AsmUtils.convertTypeDescriptorToClassName(annoTypeDesc);
        String resourcePath = ClassUtils.convertClassNameToResourcePath((String)className);
        ClassReader reader = AsmUtils.newClassReader(resourcePath);
        reader.accept((ClassVisitor)classVisitor, false);
        if (classVisitor.hasPluginAnnotation()) {
            Object pluginAnno;
            try {
                Class<?> annoType = ClassUtils.getDefaultClassLoader().loadClass(annoTypeName);
                pluginAnno = MutableAnnotationUtils.createMutableAnnotation(annoType);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
            this.configClass.addPluginAnnotation((Annotation)pluginAnno);
            return new MutableAnnotationVisitor((MutableAnnotation)pluginAnno);
        }
        return super.visitAnnotation(annoTypeDesc, arg1);
    }

    public MethodVisitor visitMethod(int modifiers, String methodName, String methodDescriptor, String arg3, String[] arg4) {
        return new ConfigurationClassMethodVisitor(this.configClass, methodName, methodDescriptor, modifiers);
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        String configClassName;
        if (!this.processInnerClasses) {
            return;
        }
        String innerClassName = ClassUtils.convertResourcePathToClassName((String)name);
        if (innerClassName.equals(configClassName = this.configClass.getName())) {
            if (this.innerClasses.containsKey(outerName)) {
                this.configClass.setDeclaringClass(this.innerClasses.get(outerName));
            }
            return;
        }
        ConfigurationClass innerConfigClass = new ConfigurationClass();
        ConfigurationClassVisitor ccVisitor = new ConfigurationClassVisitor(innerConfigClass, new ConfigurationModel());
        ccVisitor.setProcessInnerClasses(false);
        ClassReader reader = AsmUtils.newClassReader(name);
        reader.accept((ClassVisitor)ccVisitor, false);
        if (this.innerClasses.containsKey(outerName)) {
            innerConfigClass.setDeclaringClass(this.innerClasses.get(outerName));
        }
        if (innerConfigClass.getMetadata() != null) {
            this.innerClasses.put(name, innerConfigClass);
        }
    }

    private static class PluginAnnotationDetectingClassVisitor
    extends ClassAdapter {
        private boolean hasPluginAnnotation = false;
        private final Plugin pluginAnnotation = MutableAnnotationUtils.createMutableAnnotation(Plugin.class);

        public PluginAnnotationDetectingClassVisitor() {
            super((ClassVisitor)AsmUtils.EMPTY_VISITOR);
        }

        public AnnotationVisitor visitAnnotation(String typeDesc, boolean arg1) {
            if (Plugin.class.getName().equals(AsmUtils.convertTypeDescriptorToClassName(typeDesc))) {
                this.hasPluginAnnotation = true;
                return new MutableAnnotationVisitor((MutableAnnotation)((Object)this.pluginAnnotation));
            }
            return super.visitAnnotation(typeDesc, arg1);
        }

        public boolean hasPluginAnnotation() {
            return this.hasPluginAnnotation;
        }

        public Plugin getPluginAnnotation() {
            return this.pluginAnnotation;
        }
    }
}

