/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.internal.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.config.java.internal.model.UsageError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MalformedJavaConfigurationException
extends RuntimeException {
    private final List<? extends UsageError> errors;

    public MalformedJavaConfigurationException(String message) {
        super(message);
        this.errors = new ArrayList<UsageError>();
    }

    public MalformedJavaConfigurationException(UsageError ... errors) {
        super(MalformedJavaConfigurationException.toString(errors));
        this.errors = Arrays.asList(errors);
    }

    public boolean containsError(Class<? extends UsageError> errorType) {
        for (UsageError usageError : this.errors) {
            if (!usageError.getClass().isAssignableFrom(errorType)) continue;
            return true;
        }
        return false;
    }

    private static String toString(UsageError ... errors) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        if (errors.length == 1) {
            sb.append("A usage error has ");
        } else {
            sb.append(String.valueOf(errors.length) + " usage errors have ");
        }
        sb.append("been detected:\n");
        int i = 0;
        while (i < errors.length) {
            sb.append(errors[i].toString());
            if (i + 1 < errors.length) {
                sb.append('\n');
            }
            ++i;
        }
        return sb.toString();
    }
}

