/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.internal.factory;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.springframework.beans.BeanMetadataAttribute;
import org.springframework.beans.BeanMetadataAttributeAccessor;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.config.java.internal.factory.BeanFactoryProvider;
import org.springframework.config.java.internal.factory.BeanVisibility;
import org.springframework.config.java.internal.factory.ExternalValueInjectingBeanPostProcessor;
import org.springframework.config.java.internal.factory.JavaConfigBeanFactory;
import org.springframework.config.java.naming.BeanNamingStrategy;
import org.springframework.config.java.naming.MethodNameStrategy;

public class DefaultJavaConfigBeanFactory
extends DefaultListableBeanFactory
implements JavaConfigBeanFactory {
    BeanNamingStrategy beanNamingStrategy = new MethodNameStrategy();

    public DefaultJavaConfigBeanFactory(ConfigurableListableBeanFactory externalBeanFactory, BeanFactoryProvider beanFactoryProvider) {
        super((BeanFactory)externalBeanFactory);
        this.copyConfigurationFrom((ConfigurableBeanFactory)externalBeanFactory);
        this.getParentBeanFactory().addBeanPostProcessor((BeanPostProcessor)new ExternalValueInjectingBeanPostProcessor(this));
        beanFactoryProvider.registerBeanDefinition(this);
    }

    public boolean isCurrentlyInCreation(String beanName) {
        if (super.isCurrentlyInCreation(beanName)) {
            return true;
        }
        if (this.getParentBeanFactory() != null) {
            return this.getParentBeanFactory().isCurrentlyInCreation(beanName);
        }
        return super.isCurrentlyInCreation(beanName);
    }

    public DefaultListableBeanFactory getParentBeanFactory() {
        return (DefaultListableBeanFactory)super.getParentBeanFactory();
    }

    public void registerSingleton(String beanName, Object singletonObject) throws IllegalStateException {
        this.registerSingleton(beanName, singletonObject, BeanVisibility.HIDDEN);
    }

    public void registerSingleton(String beanName, Object bean, BeanVisibility visibility) {
        switch (visibility) {
            case HIDDEN: {
                super.registerSingleton(beanName, bean);
                break;
            }
            case PUBLIC: {
                this.getParentBeanFactory().registerSingleton(beanName, bean);
            }
        }
    }

    public void registerBeanDefinition(String beanName, BeanDefinition beanDef) throws BeanDefinitionStoreException {
        if (beanDef.getAttribute("JAVA_CONFIG_IGNORE") != null) {
            this.registerBeanDefinition(beanName, beanDef, BeanVisibility.HIDDEN);
        } else {
            this.registerBeanDefinition(beanName, beanDef, BeanVisibility.PUBLIC);
        }
    }

    public void registerBeanDefinition(String beanName, BeanDefinition beanDef, BeanVisibility visibility) {
        ((BeanMetadataAttributeAccessor)beanDef).addMetadataAttribute(new BeanMetadataAttribute("org.springframework.config.java", (Object)true));
        switch (visibility) {
            case HIDDEN: {
                super.registerBeanDefinition(beanName, beanDef);
                break;
            }
            case PUBLIC: {
                this.getParentBeanFactory().registerBeanDefinition(beanName, beanDef);
            }
        }
    }

    public void registerAlias(String beanName, String alias) {
        this.registerAlias(beanName, alias, BeanVisibility.PUBLIC);
    }

    public void registerAlias(String beanName, String alias, BeanVisibility visibility) {
        switch (visibility) {
            case HIDDEN: {
                super.registerAlias(beanName, alias);
                break;
            }
            case PUBLIC: {
                this.getParentBeanFactory().registerAlias(beanName, alias);
            }
        }
    }

    public boolean containsBeanDefinition(String beanName, BeanVisibility visibility) {
        switch (visibility) {
            case HIDDEN: {
                return this.containsBeanDefinition(beanName);
            }
            case PUBLIC: {
                return this.getParentBeanFactory().containsBeanDefinition(beanName);
            }
        }
        throw new IllegalArgumentException();
    }

    public BeanDefinition getBeanDefinition(String beanName, BeanVisibility visibility) {
        switch (visibility) {
            case HIDDEN: {
                return this.getBeanDefinition(beanName);
            }
            case PUBLIC: {
                return this.getParentBeanFactory().getBeanDefinition(beanName);
            }
        }
        throw new IllegalArgumentException();
    }

    public void setBeanNamingStrategy(BeanNamingStrategy beanNamingStrategy) {
        this.beanNamingStrategy = beanNamingStrategy;
    }

    public BeanNamingStrategy getBeanNamingStrategy() {
        return this.beanNamingStrategy;
    }

    public List getBeanPostProcessors() {
        LinkedHashSet mergedBeanPostProcessors = new LinkedHashSet();
        mergedBeanPostProcessors.addAll(this.getParentBeanFactory().getBeanPostProcessors());
        mergedBeanPostProcessors.addAll(super.getBeanPostProcessors());
        return new ArrayList(mergedBeanPostProcessors);
    }

    protected boolean hasInstantiationAwareBeanPostProcessors() {
        return super.hasInstantiationAwareBeanPostProcessors() || this.parentHasInstantiationAwareBeanPostProcessors();
    }

    private boolean parentHasInstantiationAwareBeanPostProcessors() {
        for (Object bpp : this.getParentBeanFactory().getBeanPostProcessors()) {
            if (!(bpp instanceof InstantiationAwareBeanPostProcessor)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasDestructionAwareBeanPostProcessors() {
        return super.hasDestructionAwareBeanPostProcessors() || this.parentHasDestructionAwareBeanPostProcessors();
    }

    private boolean parentHasDestructionAwareBeanPostProcessors() {
        for (Object bpp : this.getParentBeanFactory().getBeanPostProcessors()) {
            if (!(bpp instanceof DestructionAwareBeanPostProcessor)) continue;
            return true;
        }
        return false;
    }
}

