/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.internal.enhancement;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.config.java.internal.enhancement.ThreadLocalUtils;
import org.springframework.util.Assert;

class ThreadLocalMapEntryData {
    private static final Log log = LogFactory.getLog(ThreadLocalMapEntryData.class);
    final ThreadLocal<?> threadLocal;
    final Thread owningThread;
    final Object owningThreadLocalMap;
    final Object value;

    public ThreadLocalMapEntryData(Thread owningThread, Object owningMap, Object mapEntry) {
        Assert.notNull((Object)owningThread, (String)"owningThread must be non-null");
        Assert.notNull((Object)owningMap, (String)"owningMap must be non-null");
        Assert.isInstanceOf(ThreadLocalUtils.CLASS_THREAD_LOCAL_MAP, (Object)owningMap);
        Assert.notNull((Object)mapEntry, (String)"mapEntry must be non-null");
        Assert.isInstanceOf(ThreadLocalUtils.CLASS_THREAD_LOCAL_MAP_ENTRY, (Object)mapEntry);
        this.owningThread = owningThread;
        this.owningThreadLocalMap = owningMap;
        try {
            this.threadLocal = (ThreadLocal)ThreadLocalUtils.FIELD_REFERENT.get(mapEntry);
            this.value = ThreadLocalUtils.FIELD_VALUE.get(mapEntry);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void removeFromOwningMap() {
        log.debug((Object)String.format("removing threadlocal [%s] having value [%s] from thread %s", this.threadLocal, this.value, this.owningThread));
        try {
            ThreadLocalUtils.METHOD_REMOVE.invoke(this.owningThreadLocalMap, this.threadLocal);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

