/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.SmartContextLoader;
import org.springframework.test.context.support.AnnotationConfigContextLoader;
import org.springframework.test.context.support.GenericXmlContextLoader;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingSmartContextLoader
implements SmartContextLoader {
    private static final Log logger = LogFactory.getLog(DelegatingSmartContextLoader.class);
    private final SmartContextLoader xmlLoader = new GenericXmlContextLoader();
    private final SmartContextLoader annotationConfigLoader = new AnnotationConfigContextLoader();

    private static String name(SmartContextLoader loader) {
        return loader.getClass().getSimpleName();
    }

    private static void delegateProcessing(SmartContextLoader loader, ContextConfigurationAttributes configAttributes) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("Delegating to %s to process context configuration %s.", DelegatingSmartContextLoader.name(loader), configAttributes));
        }
        loader.processContextConfiguration(configAttributes);
    }

    private static boolean supports(SmartContextLoader loader, MergedContextConfiguration mergedConfig) {
        if (loader instanceof AnnotationConfigContextLoader) {
            return ObjectUtils.isEmpty((Object[])mergedConfig.getLocations()) && !ObjectUtils.isEmpty((Object[])mergedConfig.getClasses());
        }
        return !ObjectUtils.isEmpty((Object[])mergedConfig.getLocations()) && ObjectUtils.isEmpty((Object[])mergedConfig.getClasses());
    }

    @Override
    public void processContextConfiguration(ContextConfigurationAttributes configAttributes) {
        Assert.notNull((Object)configAttributes, (String)"configAttributes must not be null");
        Assert.isTrue((!configAttributes.hasLocations() || !configAttributes.hasClasses() ? 1 : 0) != 0, (String)String.format("Cannot process locations AND configuration classes for context configuration %s; configure one or the other, but not both.", configAttributes));
        if (configAttributes.hasLocations()) {
            DelegatingSmartContextLoader.delegateProcessing(this.xmlLoader, configAttributes);
        } else if (configAttributes.hasClasses()) {
            DelegatingSmartContextLoader.delegateProcessing(this.annotationConfigLoader, configAttributes);
        } else {
            DelegatingSmartContextLoader.delegateProcessing(this.xmlLoader, configAttributes);
            boolean xmlLoaderDetectedDefaults = configAttributes.hasLocations();
            if (xmlLoaderDetectedDefaults && logger.isInfoEnabled()) {
                logger.info((Object)String.format("%s detected default locations for context configuration %s.", DelegatingSmartContextLoader.name(this.xmlLoader), configAttributes));
            }
            if (configAttributes.hasClasses()) {
                throw new IllegalStateException(String.format("%s should NOT have detected default configuration classes for context configuration %s.", DelegatingSmartContextLoader.name(this.xmlLoader), configAttributes));
            }
            DelegatingSmartContextLoader.delegateProcessing(this.annotationConfigLoader, configAttributes);
            if (configAttributes.hasClasses() && logger.isInfoEnabled()) {
                logger.info((Object)String.format("%s detected default configuration classes for context configuration %s.", DelegatingSmartContextLoader.name(this.annotationConfigLoader), configAttributes));
            }
            if (!xmlLoaderDetectedDefaults && configAttributes.hasLocations()) {
                throw new IllegalStateException(String.format("%s should NOT have detected default locations for context configuration %s.", DelegatingSmartContextLoader.name(this.annotationConfigLoader), configAttributes));
            }
            if (!configAttributes.hasResources()) {
                throw new IllegalStateException(String.format("Neither %s nor %s was able to detect defaults for context configuration %s.", DelegatingSmartContextLoader.name(this.xmlLoader), DelegatingSmartContextLoader.name(this.annotationConfigLoader), configAttributes));
            }
            if (configAttributes.hasLocations() && configAttributes.hasClasses()) {
                String message = String.format("Configuration error: both default locations AND default configuration classes were detected for context configuration %s; configure one or the other, but not both.", configAttributes);
                logger.error((Object)message);
                throw new IllegalStateException(message);
            }
        }
    }

    @Override
    public ApplicationContext loadContext(MergedContextConfiguration mergedConfig) throws Exception {
        Assert.notNull((Object)mergedConfig, (String)"mergedConfig must not be null");
        List<SmartContextLoader> candidates = Arrays.asList(this.xmlLoader, this.annotationConfigLoader);
        for (SmartContextLoader loader : candidates) {
            if (!DelegatingSmartContextLoader.supports(loader, mergedConfig)) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Delegating to %s to load context from %s.", DelegatingSmartContextLoader.name(loader), mergedConfig));
            }
            return loader.loadContext(mergedConfig);
        }
        throw new IllegalStateException(String.format("Neither %s nor %s was able to load an ApplicationContext from %s.", DelegatingSmartContextLoader.name(this.xmlLoader), DelegatingSmartContextLoader.name(this.annotationConfigLoader), mergedConfig));
    }

    @Override
    public String[] processLocations(Class<?> clazz, String ... locations) {
        throw new UnsupportedOperationException("DelegatingSmartContextLoader does not support the ContextLoader SPI. Call processContextConfiguration(ContextConfigurationAttributes) instead.");
    }

    @Override
    public ApplicationContext loadContext(String ... locations) throws Exception {
        throw new UnsupportedOperationException("DelegatingSmartContextLoader does not support the ContextLoader SPI. Call loadContext(MergedContextConfiguration) instead.");
    }
}

