/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.parsing;

import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.internal.parsing.GenerationContext;
import oracle.toplink.essentials.internal.parsing.Node;
import oracle.toplink.essentials.internal.parsing.ParseTreeContext;
import oracle.toplink.essentials.internal.parsing.SimpleConditionalExpressionNode;
import oracle.toplink.essentials.internal.parsing.TypeHelper;

public class BetweenNode
extends SimpleConditionalExpressionNode {
    protected Node rightForBetween;
    protected Node rightForAnd;

    public Node qualifyAttributeAccess(ParseTreeContext context) {
        if (this.left != null) {
            this.left = this.left.qualifyAttributeAccess(context);
        }
        if (this.rightForBetween != null) {
            this.rightForBetween = this.rightForBetween.qualifyAttributeAccess(context);
        }
        if (this.rightForAnd != null) {
            this.rightForAnd = this.rightForAnd.qualifyAttributeAccess(context);
        }
        return this;
    }

    public void validate(ParseTreeContext context) {
        Object type = null;
        if (this.left != null) {
            this.left.validate(context);
            type = this.left.getType();
        }
        if (this.rightForBetween != null) {
            this.rightForBetween.validate(context);
            this.rightForBetween.validateParameter(context, type);
        }
        if (this.rightForAnd != null) {
            this.rightForAnd.validate(context);
            this.rightForAnd.validateParameter(context, type);
        }
        TypeHelper typeHelper = context.getTypeHelper();
        this.setType(typeHelper.getBooleanType());
    }

    public Expression generateExpression(GenerationContext context) {
        Expression whereClause = this.getLeft().generateExpression(context);
        whereClause = whereClause.between(this.getRightForBetween().generateExpression(context), this.getRightForAnd().generateExpression(context));
        return whereClause;
    }

    public Node getRightForAnd() {
        return this.rightForAnd;
    }

    public Node getRightForBetween() {
        return this.rightForBetween;
    }

    public boolean hasRightForAnd() {
        return this.rightForAnd != null;
    }

    public boolean hasRightForBetween() {
        return this.rightForBetween != null;
    }

    public void setRightForAnd(Node newRightForAnd) {
        this.rightForAnd = newRightForAnd;
    }

    public void setRightForBetween(Node newRightForBetween) {
        this.rightForBetween = newRightForBetween;
    }
}

