/*
 * Decompiled with CFR 0.152.
 */
package slothLib.NLP;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import slothLib.NLP.ChaSenMorpheme;
import slothLib.NLP.IMorphologicalAnalyzerResult;
import slothLib.NLP.RemainOriginalFilter;
import slothLib.NLP.RemainPosFilter;
import slothLib.NLP.RemainRawFilter;

public class ChaSenResult
implements IMorphologicalAnalyzerResult {
    private List<ChaSenMorpheme> morphemeList = new ArrayList<ChaSenMorpheme>();
    private String rawResult;
    private List<ChaSenResult> sequenceResults;
    private static RemainOriginalFilter remainOriginalFilter = new RemainOriginalFilter();
    private static RemainPosFilter remainPosFilter = new RemainPosFilter();
    private static RemainRawFilter remainRawFilter = new RemainRawFilter();
    private static Pattern regexResultLine = Pattern.compile("^(.*)\\t(.*)\\t(.*)\\t(.*)\\t(.*)\\t(.*)$");

    public ChaSenResult(String rawResult) {
        this.rawResult = rawResult;
        this.sequenceResults = new ArrayList<ChaSenResult>();
        String[] resultList = rawResult.split("\\n");
        StringBuffer sequenceRawResult = new StringBuffer();
        ArrayList<ChaSenMorpheme> sequenceMorphemes = new ArrayList<ChaSenMorpheme>();
        String[] stringArray = resultList;
        int n = resultList.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            Matcher match = regexResultLine.matcher(line);
            if (match.matches()) {
                String raw = match.group(1).toString();
                String reading = match.group(2).toString();
                String original = match.group(3).toString();
                String pos = match.group(4).toString();
                String conjugationPattern = match.group(5).toString();
                String conjugationForm = match.group(6).toString();
                ChaSenMorpheme morpheme = new ChaSenMorpheme(raw, reading, original, pos, conjugationPattern, conjugationForm);
                this.morphemeList.add(morpheme);
                sequenceRawResult.append(String.valueOf(line) + "\r\n");
                sequenceMorphemes.add(morpheme);
            } else if (line == "EOS") {
                this.sequenceResults.add(new ChaSenResult(sequenceRawResult.toString(), sequenceMorphemes));
                sequenceRawResult = new StringBuffer();
                sequenceMorphemes = new ArrayList();
            }
            ++n2;
        }
    }

    private ChaSenResult(String rawResult, List<ChaSenMorpheme> sequenceMorphemes) {
        this.rawResult = rawResult;
        for (ChaSenMorpheme morpheme : sequenceMorphemes) {
            this.morphemeList.add(morpheme);
        }
    }

    public String getRawResult() {
        return this.rawResult;
    }

    public int getSequenceCount() {
        return this.sequenceResults.size();
    }

    public ChaSenResult[] getSequenceResults() {
        return this.sequenceResults.toArray(new ChaSenResult[0]);
    }

    public ChaSenMorpheme get(int index) {
        return this.morphemeList.get(index);
    }

    public ChaSenMorpheme[] getMorphemes() {
        return this.morphemeList.toArray(new ChaSenMorpheme[0]);
    }

    @Override
    public String[] getRawArray() {
        return remainRawFilter.doFilter(this.getMorphemes());
    }

    @Override
    public String[] getOriginalArray() {
        return remainOriginalFilter.doFilter(this.getMorphemes());
    }

    @Override
    public String[] getPOSArray() {
        return remainPosFilter.doFilter(this.getMorphemes());
    }
}

