/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.cache;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.cache.DefaultResolutionCacheManager$CacheParserSettings;
import org.apache.ivy.core.cache.ResolutionCacheManager;
import org.apache.ivy.core.module.descriptor.ExtendsDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.IvySettingsAware;
import org.apache.ivy.plugins.parser.ParserSettings;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorParser;

public final class DefaultResolutionCacheManager
implements ResolutionCacheManager,
IvySettingsAware {
    private String resolvedIvyPattern = "resolved-[organisation]-[module]-[revision].xml";
    private String resolvedIvyPropertiesPattern = "resolved-[organisation]-[module]-[revision].properties";
    private File basedir;
    private String name = "resolution-cache";
    private IvySettings settings;

    public DefaultResolutionCacheManager() {
    }

    public DefaultResolutionCacheManager(File file2) {
        File file3;
        this.basedir = file3 = file2;
    }

    public final void setSettings(IvySettings ivySettings) {
        this.settings = ivySettings;
    }

    public final void setBasedir(File file2) {
        this.basedir = file2;
    }

    private File getResolvedIvyFileInCache(ModuleRevisionId moduleRevisionId) {
        String string = IvyPatternHelper.substitute(this.resolvedIvyPattern, moduleRevisionId.getOrganisation(), moduleRevisionId.getName(), moduleRevisionId.getRevision(), "ivy", "ivy", "xml");
        return new File(this.basedir, string);
    }

    public final File getResolvedIvyPropertiesInCache(ModuleRevisionId moduleRevisionId) {
        String string = IvyPatternHelper.substitute(this.resolvedIvyPropertiesPattern, moduleRevisionId.getOrganisation(), moduleRevisionId.getName(), moduleRevisionId.getRevision(), "ivy", "ivy", "xml");
        return new File(this.basedir, string);
    }

    public final File getConfigurationResolveReportInCache(String string, String string2) {
        return new File(this.basedir, string + "-" + string2 + ".xml");
    }

    public final ModuleDescriptor getResolvedModuleDescriptor(ModuleRevisionId moduleRevisionId) {
        Object object;
        File file2 = this.getResolvedIvyFileInCache(moduleRevisionId);
        if (!file2.exists()) {
            throw new IllegalStateException("Ivy file not found in cache for " + moduleRevisionId + "!");
        }
        Properties properties = new Properties();
        File file3 = this.getResolvedIvyPropertiesInCache(ModuleRevisionId.newInstance(moduleRevisionId, moduleRevisionId.getRevision() + "-parents"));
        if (file3.exists()) {
            object = new FileInputStream(file3);
            properties.load((InputStream)object);
            ((FileInputStream)object).close();
        }
        object = new DefaultResolutionCacheManager$CacheParserSettings(this.settings, properties);
        URL uRL = file2.toURI().toURL();
        return XmlModuleDescriptorParser.getInstance().parseDescriptor((ParserSettings)object, uRL, false);
    }

    public final void saveResolvedModuleDescriptor(ModuleDescriptor moduleDescriptor) {
        ModuleRevisionId moduleRevisionId = moduleDescriptor.getResolvedModuleRevisionId();
        File file2 = this.getResolvedIvyFileInCache(moduleRevisionId);
        moduleDescriptor.toIvyFile(file2);
        Properties properties = new Properties();
        this.saveLocalParents(moduleRevisionId, moduleDescriptor, file2, properties);
        if (!properties.isEmpty()) {
            File file3 = this.getResolvedIvyPropertiesInCache(ModuleRevisionId.newInstance(moduleRevisionId, moduleRevisionId.getRevision() + "-parents"));
            FileOutputStream fileOutputStream = new FileOutputStream(file3);
            properties.store(fileOutputStream, null);
            fileOutputStream.close();
        }
    }

    private void saveLocalParents(ModuleRevisionId moduleRevisionId, ModuleDescriptor moduleDescriptor, File file2, Properties properties) {
        ExtendsDescriptor[] extendsDescriptorArray = moduleDescriptor.getInheritedDescriptors();
        for (int i = 0; i < extendsDescriptorArray.length; ++i) {
            if (!extendsDescriptorArray[i].isLocal()) continue;
            ModuleDescriptor moduleDescriptor2 = extendsDescriptorArray[i].getParentMd();
            ModuleRevisionId moduleRevisionId2 = ModuleRevisionId.newInstance(moduleRevisionId, moduleRevisionId.getRevision() + "-parent." + properties.size());
            File file3 = this.getResolvedIvyFileInCache(moduleRevisionId2);
            moduleDescriptor2.toIvyFile(file3);
            properties.setProperty(file2.getName() + "|" + extendsDescriptorArray[i].getLocation(), file3.getAbsolutePath());
            this.saveLocalParents(moduleRevisionId, moduleDescriptor2, file3, properties);
        }
    }

    public final String toString() {
        return this.name;
    }
}

