/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.settings;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.NormalRelativeUrlResolver;
import org.apache.ivy.core.RelativeUrlResolver;
import org.apache.ivy.core.cache.CacheUtil;
import org.apache.ivy.core.cache.DefaultRepositoryCacheManager;
import org.apache.ivy.core.cache.DefaultResolutionCacheManager;
import org.apache.ivy.core.cache.RepositoryCacheManager;
import org.apache.ivy.core.cache.ResolutionCacheManager;
import org.apache.ivy.core.check.CheckEngineSettings;
import org.apache.ivy.core.deliver.DeliverEngineSettings;
import org.apache.ivy.core.install.InstallEngineSettings;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.module.id.ModuleRules;
import org.apache.ivy.core.module.status.StatusManager;
import org.apache.ivy.core.publish.PublishEngineSettings;
import org.apache.ivy.core.repository.RepositoryManagementEngineSettings;
import org.apache.ivy.core.resolve.ResolveEngineSettings;
import org.apache.ivy.core.retrieve.RetrieveEngineSettings;
import org.apache.ivy.core.settings.IvyVariableContainer;
import org.apache.ivy.core.settings.IvyVariableContainerImpl;
import org.apache.ivy.core.settings.Validatable;
import org.apache.ivy.core.settings.XmlSettingsParser;
import org.apache.ivy.core.sort.SortEngineSettings;
import org.apache.ivy.plugins.IvySettingsAware;
import org.apache.ivy.plugins.circular.CircularDependencyStrategy;
import org.apache.ivy.plugins.circular.ErrorCircularDependencyStrategy;
import org.apache.ivy.plugins.circular.IgnoreCircularDependencyStrategy;
import org.apache.ivy.plugins.circular.WarnCircularDependencyStrategy;
import org.apache.ivy.plugins.conflict.ConflictManager;
import org.apache.ivy.plugins.conflict.LatestCompatibleConflictManager;
import org.apache.ivy.plugins.conflict.LatestConflictManager;
import org.apache.ivy.plugins.conflict.NoConflictManager;
import org.apache.ivy.plugins.conflict.StrictConflictManager;
import org.apache.ivy.plugins.latest.LatestLexicographicStrategy;
import org.apache.ivy.plugins.latest.LatestRevisionStrategy;
import org.apache.ivy.plugins.latest.LatestStrategy;
import org.apache.ivy.plugins.latest.LatestTimeStrategy;
import org.apache.ivy.plugins.lock.ArtifactLockStrategy;
import org.apache.ivy.plugins.lock.LockStrategy;
import org.apache.ivy.plugins.lock.NoLockStrategy;
import org.apache.ivy.plugins.matcher.ExactOrRegexpPatternMatcher;
import org.apache.ivy.plugins.matcher.ExactPatternMatcher;
import org.apache.ivy.plugins.matcher.MapMatcher;
import org.apache.ivy.plugins.matcher.PatternMatcher;
import org.apache.ivy.plugins.matcher.RegexpPatternMatcher;
import org.apache.ivy.plugins.namespace.Namespace;
import org.apache.ivy.plugins.parser.ParserSettings;
import org.apache.ivy.plugins.report.LogReportOutputter;
import org.apache.ivy.plugins.report.ReportOutputter;
import org.apache.ivy.plugins.report.XmlReportOutputter;
import org.apache.ivy.plugins.resolver.ChainResolver;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.plugins.resolver.DualResolver;
import org.apache.ivy.plugins.resolver.ResolverSettings;
import org.apache.ivy.plugins.signer.SignatureGenerator;
import org.apache.ivy.plugins.version.ChainVersionMatcher;
import org.apache.ivy.plugins.version.ExactVersionMatcher;
import org.apache.ivy.plugins.version.LatestVersionMatcher;
import org.apache.ivy.plugins.version.SubVersionMatcher;
import org.apache.ivy.plugins.version.VersionMatcher;
import org.apache.ivy.plugins.version.VersionRangeMatcher;
import org.apache.ivy.util.Checks;
import org.apache.ivy.util.FileUtil;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.filter.Filter;
import org.apache.ivy.util.url.URLHandlerRegistry;

public class IvySettings
implements CheckEngineSettings,
DeliverEngineSettings,
InstallEngineSettings,
PublishEngineSettings,
RepositoryManagementEngineSettings,
ResolveEngineSettings,
RetrieveEngineSettings,
SortEngineSettings,
ParserSettings,
ResolverSettings {
    private Map typeDefs = new HashMap();
    private Map resolversMap = new HashMap();
    private DependencyResolver defaultResolver;
    private DependencyResolver dictatorResolver = null;
    private String defaultResolverName;
    private File defaultCache;
    private String defaultBranch = null;
    private boolean checkUpToDate = true;
    private ModuleRules moduleSettings = new ModuleRules();
    private Map conflictsManager = new HashMap();
    private Map latestStrategies = new HashMap();
    private Map lockStrategies = new HashMap();
    private Map namespaces = new HashMap();
    private Map matchers = new HashMap();
    private Map reportOutputters = new HashMap();
    private Map versionMatchers = new HashMap();
    private Map circularDependencyStrategies = new HashMap();
    private Map repositoryCacheManagers = new HashMap();
    private Map signatureGenerators = new HashMap();
    private List triggers = new ArrayList();
    private IvyVariableContainer variableContainer = new IvyVariableContainerImpl();
    private boolean validate = true;
    private LatestStrategy defaultLatestStrategy = null;
    private LockStrategy defaultLockStrategy = null;
    private ConflictManager defaultConflictManager = null;
    private CircularDependencyStrategy circularDependencyStrategy = null;
    private RepositoryCacheManager defaultRepositoryCacheManager = null;
    private ResolutionCacheManager resolutionCacheManager = null;
    private List listingIgnore = new ArrayList();
    private boolean repositoriesConfigured;
    private boolean useRemoteConfig = false;
    private File defaultUserDir;
    private File baseDir = new File(".").getAbsoluteFile();
    private List classpathURLs = new ArrayList();
    private ClassLoader classloader;
    private Boolean debugConflictResolution;
    private boolean logNotConvertedExclusionRule;
    private VersionMatcher versionMatcher;
    private StatusManager statusManager;
    private Boolean debugLocking;
    private String defaultCacheIvyPattern;
    private String defaultCacheArtifactPattern;
    private boolean defaultUseOrigin;
    private String defaultResolveMode = "default";

    public IvySettings() {
        this(new IvyVariableContainerImpl());
    }

    public IvySettings(IvyVariableContainer variableContainer) {
        this.setVariableContainer(variableContainer);
        this.setVariable("ivy.default.settings.dir", this.getDefaultSettingsDir(), true);
        this.setVariable("ivy.basedir", this.getBaseDir().getAbsolutePath());
        this.setDeprecatedVariable("ivy.default.conf.dir", "ivy.default.settings.dir");
        String ivyTypeDefs = System.getProperty("ivy.typedef.files");
        if (ivyTypeDefs != null) {
            String[] files = ivyTypeDefs.split("\\,");
            for (int i = 0; i < files.length; ++i) {
                try {
                    this.typeDefs(new FileInputStream(Checks.checkAbsolute(files[i].trim(), "ivy.typedef.files")), true);
                    continue;
                }
                catch (FileNotFoundException e) {
                    Message.warn("typedefs file not found: " + files[i].trim());
                    continue;
                }
                catch (IOException e) {
                    Message.warn("problem with typedef file: " + files[i].trim() + ": " + e.getMessage());
                }
            }
        } else {
            try {
                this.typeDefs(IvySettings.getSettingsURL("typedef.properties").openStream(), true);
            }
            catch (IOException e) {
                Message.warn("impossible to load default type defs");
            }
        }
        LatestLexicographicStrategy latestLexicographicStrategy = new LatestLexicographicStrategy();
        LatestRevisionStrategy latestRevisionStrategy = new LatestRevisionStrategy();
        LatestTimeStrategy latestTimeStrategy = new LatestTimeStrategy();
        this.addLatestStrategy("latest-revision", latestRevisionStrategy);
        this.addLatestStrategy("latest-lexico", latestLexicographicStrategy);
        this.addLatestStrategy("latest-time", latestTimeStrategy);
        this.addLockStrategy("no-lock", new NoLockStrategy());
        this.addLockStrategy("artifact-lock", new ArtifactLockStrategy(this.debugLocking()));
        this.addConflictManager("latest-revision", new LatestConflictManager("latest-revision", latestRevisionStrategy));
        this.addConflictManager("latest-compatible", new LatestCompatibleConflictManager("latest-compatible", latestRevisionStrategy));
        this.addConflictManager("latest-time", new LatestConflictManager("latest-time", latestTimeStrategy));
        this.addConflictManager("all", new NoConflictManager());
        this.addConflictManager("strict", new StrictConflictManager());
        this.addMatcher(ExactPatternMatcher.INSTANCE);
        this.addMatcher(RegexpPatternMatcher.INSTANCE);
        this.addMatcher(ExactOrRegexpPatternMatcher.INSTANCE);
        try {
            Class<?> globClazz = IvySettings.class.getClassLoader().loadClass("org.apache.ivy.plugins.matcher.GlobPatternMatcher");
            Field instanceField = globClazz.getField("INSTANCE");
            this.addMatcher((PatternMatcher)instanceField.get(null));
        }
        catch (Exception e) {
            Message.info("impossible to define glob matcher: org.apache.ivy.plugins.matcher.GlobPatternMatcher was not found.");
        }
        this.addReportOutputter(new LogReportOutputter());
        this.addReportOutputter(new XmlReportOutputter());
        this.configureDefaultCircularDependencyStrategies();
        this.listingIgnore.add(".cvsignore");
        this.listingIgnore.add("CVS");
        this.listingIgnore.add(".svn");
        this.listingIgnore.add("maven-metadata.xml");
        this.listingIgnore.add("maven-metadata.xml.md5");
        this.listingIgnore.add("maven-metadata.xml.sha1");
        this.addSystemProperties();
    }

    private void addSystemProperties() {
        try {
            this.addAllVariables(System.getProperties());
        }
        catch (AccessControlException ex) {
            Message.verbose("access denied to getting all system properties: they won't be available as Ivy variables.\nset " + ex.getPermission() + " permission if you want to access them");
        }
    }

    public void configureRepositories(boolean remote) {
        if (!this.repositoriesConfigured) {
            Properties props;
            block9: {
                props = new Properties();
                boolean configured = false;
                if (this.useRemoteConfig && remote) {
                    try {
                        URL url = new URL("http://ant.apache.org/ivy/repository.properties");
                        Message.verbose("configuring repositories with " + url);
                        props.load(URLHandlerRegistry.getDefault().openStream(url));
                        configured = true;
                    }
                    catch (Exception ex) {
                        Message.verbose("unable to use remote repository configuration: " + ex.getMessage());
                        props = new Properties();
                    }
                }
                if (!configured) {
                    InputStream repositoryPropsStream = null;
                    try {
                        repositoryPropsStream = IvySettings.getSettingsURL("repository.properties").openStream();
                        props.load(repositoryPropsStream);
                    }
                    catch (IOException e) {
                        Message.error("unable to use internal repository configuration: " + e.getMessage());
                        if (repositoryPropsStream == null) break block9;
                        try {
                            repositoryPropsStream.close();
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                }
            }
            this.addAllVariables(props, false);
            this.repositoriesConfigured = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void typeDefs(InputStream stream, boolean silentFail) throws IOException {
        try {
            Properties p = new Properties();
            p.load(stream);
            this.typeDefs(p, silentFail);
        }
        finally {
            stream.close();
        }
    }

    public void typeDefs(Properties p, boolean silentFail) {
        Iterator<Object> iter = p.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            this.typeDef(name, p.getProperty(name), silentFail);
        }
    }

    public void load(URL settingsURL) throws ParseException, IOException {
        Message.info(":: loading settings :: url = " + settingsURL);
        long start = System.currentTimeMillis();
        this.setSettingsVariables(settingsURL);
        if (this.getVariable("ivy.default.ivy.user.dir") != null) {
            this.setDefaultIvyUserDir(Checks.checkAbsolute(this.getVariable("ivy.default.ivy.user.dir"), "ivy.default.ivy.user.dir"));
        } else {
            this.getDefaultIvyUserDir();
        }
        this.loadDefaultProperties();
        new XmlSettingsParser(this).parse(settingsURL);
        this.setVariable("ivy.default.ivy.user.dir", this.getDefaultIvyUserDir().getAbsolutePath(), false);
        Message.verbose("settings loaded (" + (System.currentTimeMillis() - start) + "ms)");
        this.dumpSettings();
    }

    public void loadDefault() throws ParseException, IOException {
        this.load(IvySettings.getDefaultSettingsURL());
    }

    private void loadDefaultProperties() throws IOException {
        this.loadProperties(IvySettings.getDefaultPropertiesURL(), false);
    }

    public static URL getDefaultPropertiesURL() {
        return IvySettings.getSettingsURL("ivy.properties");
    }

    public static URL getDefaultSettingsURL() {
        return IvySettings.getSettingsURL("ivysettings.xml");
    }

    private String getDefaultSettingsDir() {
        String ivysettingsLocation = IvySettings.getDefaultSettingsURL().toExternalForm();
        return ivysettingsLocation.substring(0, ivysettingsLocation.length() - "ivysettings.xml".length() - 1);
    }

    private static URL getSettingsURL(String file2) {
        return XmlSettingsParser.class.getResource(file2);
    }

    public void setSettingsVariables(File settingsFile) {
        try {
            this.setVariable("ivy.settings.dir", new File(settingsFile.getAbsolutePath()).getParent());
            this.setDeprecatedVariable("ivy.conf.dir", "ivy.settings.dir");
            this.setVariable("ivy.settings.file", settingsFile.getAbsolutePath());
            this.setDeprecatedVariable("ivy.conf.file", "ivy.settings.file");
            this.setVariable("ivy.settings.url", settingsFile.toURI().toURL().toExternalForm());
            this.setDeprecatedVariable("ivy.conf.url", "ivy.settings.url");
        }
        catch (MalformedURLException e) {
            IllegalArgumentException iae = new IllegalArgumentException("given file cannot be transformed to url: " + settingsFile);
            iae.initCause(e);
            throw iae;
        }
    }

    private void setDeprecatedVariable(String deprecatedKey, String newKey) {
        this.setVariable(deprecatedKey, this.getVariable(newKey));
    }

    public void setSettingsVariables(URL settingsURL) {
        String settingsURLStr = settingsURL.toExternalForm();
        this.setVariable("ivy.settings.url", settingsURLStr);
        this.setDeprecatedVariable("ivy.conf.url", "ivy.settings.url");
        int slashIndex = settingsURLStr.lastIndexOf(47);
        if (slashIndex != -1) {
            this.setVariable("ivy.settings.dir", settingsURLStr.substring(0, slashIndex));
            this.setDeprecatedVariable("ivy.conf.dir", "ivy.settings.dir");
        } else {
            Message.warn("settings url does not contain any slash (/): ivy.settings.dir variable not set");
        }
    }

    private void dumpSettings() {
        Iterator<Object> iter;
        Message.verbose("\tdefault cache: " + this.getDefaultCache());
        Message.verbose("\tdefault resolver: " + this.getDefaultResolver());
        Message.debug("\tdefault latest strategy: " + this.getDefaultLatestStrategy());
        Message.debug("\tdefault conflict manager: " + this.getDefaultConflictManager());
        Message.debug("\tcircular dependency strategy: " + this.getCircularDependencyStrategy());
        Message.debug("\tvalidate: " + this.doValidate());
        Message.debug("\tcheck up2date: " + this.isCheckUpToDate());
        if (!this.classpathURLs.isEmpty()) {
            Message.verbose("\t-- " + this.classpathURLs.size() + " custom classpath urls:");
            iter = this.classpathURLs.iterator();
            while (iter.hasNext()) {
                Message.debug("\t\t" + iter.next());
            }
        }
        Message.verbose("\t-- " + this.resolversMap.size() + " resolvers:");
        iter = this.resolversMap.values().iterator();
        while (iter.hasNext()) {
            DependencyResolver resolver = (DependencyResolver)iter.next();
            resolver.dumpSettings();
        }
        Message.debug("\tmodule settings:");
        this.moduleSettings.dump("\t\t");
    }

    public void loadProperties(URL url, boolean overwrite) throws IOException {
        this.loadProperties(url.openStream(), overwrite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProperties(InputStream stream, boolean overwrite) throws IOException {
        try {
            Properties properties = new Properties();
            properties.load(stream);
            this.addAllVariables(properties, overwrite);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void setVariable(String varName, String value) {
        this.setVariable(varName, value, true);
    }

    public void setVariable(String varName, String value, boolean overwrite) {
        this.variableContainer.setVariable(varName, value, overwrite);
    }

    public void addAllVariables(Map variables) {
        this.addAllVariables(variables, true);
    }

    public void addAllVariables(Map variables, boolean overwrite) {
        Iterator iter = variables.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String val = (String)variables.get(key);
            this.setVariable(key, val, overwrite);
        }
    }

    public String substitute(String str) {
        return IvyPatternHelper.substituteVariables(str, this.variableContainer);
    }

    public IvyVariableContainer getVariables() {
        return this.variableContainer;
    }

    public Class typeDef(String name, String className) {
        return this.typeDef(name, className, false);
    }

    public Class typeDef(String name, String className, boolean silentFail) {
        Class clazz = this.classForName(className, silentFail);
        if (clazz != null) {
            this.typeDefs.put(name, clazz);
        }
        return clazz;
    }

    private Class classForName(String string, boolean bl) {
        try {
            return this.getClassLoader().loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (bl) {
                Message.info("impossible to define new type: class not found: " + string + " in " + this.classpathURLs + " nor Ivy classloader");
                return null;
            }
            throw new RuntimeException("impossible to define new type: class not found: " + string + " in " + this.classpathURLs + " nor Ivy classloader");
        }
    }

    private ClassLoader getClassLoader() {
        if (this.classloader == null) {
            this.classloader = this.classpathURLs.isEmpty() ? Ivy.class.getClassLoader() : new URLClassLoader(this.classpathURLs.toArray(new URL[this.classpathURLs.size()]), Ivy.class.getClassLoader());
        }
        return this.classloader;
    }

    public void addClasspathURL(URL url) {
        this.classpathURLs.add(url);
        this.classloader = null;
    }

    public Map getTypeDefs() {
        return this.typeDefs;
    }

    public SignatureGenerator getSignatureGenerator(String name) {
        return (SignatureGenerator)this.signatureGenerators.get(name);
    }

    public void addResolver(DependencyResolver dependencyResolver) {
        if (dependencyResolver == null) {
            throw new NullPointerException("null resolver");
        }
        this.init(dependencyResolver);
        this.resolversMap.put(dependencyResolver.getName(), dependencyResolver);
        if (dependencyResolver instanceof ChainResolver) {
            List list = ((ChainResolver)dependencyResolver).getResolvers();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                DependencyResolver dependencyResolver2 = (DependencyResolver)iterator.next();
                this.addResolver(dependencyResolver2);
            }
        } else if (dependencyResolver instanceof DualResolver) {
            DependencyResolver dependencyResolver3;
            DependencyResolver dependencyResolver4 = ((DualResolver)dependencyResolver).getIvyResolver();
            if (dependencyResolver4 != null) {
                this.addResolver(dependencyResolver4);
            }
            if ((dependencyResolver3 = ((DualResolver)dependencyResolver).getArtifactResolver()) != null) {
                this.addResolver(dependencyResolver3);
            }
        }
    }

    public void setDefaultCache(File file2) {
        this.setVariable("ivy.cache.dir", file2.getAbsolutePath(), false);
        this.defaultCache = file2;
        if (this.defaultRepositoryCacheManager != null && "default-cache".equals(this.defaultRepositoryCacheManager.getName()) && this.defaultRepositoryCacheManager instanceof DefaultRepositoryCacheManager) {
            ((DefaultRepositoryCacheManager)this.defaultRepositoryCacheManager).setBasedir(this.defaultCache);
        }
    }

    public void setDefaultResolver(String resolverName) {
        this.checkResolverName(resolverName);
        if (resolverName != null && !resolverName.equals(this.defaultResolverName)) {
            this.defaultResolver = null;
        }
        this.defaultResolverName = resolverName;
    }

    private void checkResolverName(String string) {
        if (string != null && !this.resolversMap.containsKey(string)) {
            throw new IllegalArgumentException("no resolver found called " + string + ": check your settings");
        }
    }

    public void addModuleConfiguration(Map attributes, PatternMatcher matcher, String resolverName, String branch, String conflictManager, String resolveMode) {
        this.checkResolverName(resolverName);
        this.moduleSettings.defineRule(new MapMatcher(attributes, matcher), new ModuleSettings(resolverName, branch, conflictManager, resolveMode));
    }

    public File resolveFile(String fileName) {
        return FileUtil.resolveFile(this.baseDir, fileName);
    }

    public void setBaseDir(File file2) {
        this.baseDir = file2.getAbsoluteFile();
        this.setVariable("ivy.basedir", this.baseDir.getAbsolutePath());
        this.setVariable("basedir", this.baseDir.getAbsolutePath(), false);
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public File getDefaultIvyUserDir() {
        if (this.defaultUserDir == null) {
            if (this.getVariable("ivy.home") != null) {
                this.setDefaultIvyUserDir(Checks.checkAbsolute(this.getVariable("ivy.home"), "ivy.home"));
                Message.verbose("using ivy.default.ivy.user.dir variable for default ivy user dir: " + this.defaultUserDir);
            } else {
                this.setDefaultIvyUserDir(new File(System.getProperty("user.home"), ".ivy2"));
                Message.verbose("no default ivy user dir defined: set to " + this.defaultUserDir);
            }
        }
        return this.defaultUserDir;
    }

    public void setDefaultIvyUserDir(File file2) {
        this.defaultUserDir = file2;
        this.setVariable("ivy.default.ivy.user.dir", this.defaultUserDir.getAbsolutePath());
        this.setVariable("ivy.home", this.defaultUserDir.getAbsolutePath());
    }

    public File getDefaultCache() {
        if (this.defaultCache == null) {
            String string = this.getVariable("ivy.cache.dir");
            if (string != null) {
                this.defaultCache = Checks.checkAbsolute(string, "ivy.cache.dir");
            } else {
                this.setDefaultCache(new File(this.getDefaultIvyUserDir(), "cache"));
                Message.verbose("no default cache defined: set to " + this.defaultCache);
            }
        }
        return this.defaultCache;
    }

    public void setDefaultRepositoryCacheBasedir(String string) {
        this.setVariable("ivy.cache.repository", string, true);
        if (this.defaultRepositoryCacheManager != null && "default-cache".equals(this.defaultRepositoryCacheManager.getName()) && this.defaultRepositoryCacheManager instanceof DefaultRepositoryCacheManager) {
            ((DefaultRepositoryCacheManager)this.defaultRepositoryCacheManager).setBasedir(this.getDefaultRepositoryCacheBasedir());
        }
    }

    public void setDefaultResolutionCacheBasedir(String string) {
        this.setVariable("ivy.cache.resolution", string, true);
        if (this.resolutionCacheManager != null && this.resolutionCacheManager instanceof DefaultResolutionCacheManager) {
            ((DefaultResolutionCacheManager)this.resolutionCacheManager).setBasedir(this.getDefaultResolutionCacheBasedir());
        }
    }

    public File getDefaultRepositoryCacheBasedir() {
        String string = this.getVariable("ivy.cache.repository");
        if (string != null) {
            return Checks.checkAbsolute(string, "ivy.cache.repository");
        }
        return this.getDefaultCache();
    }

    public File getDefaultResolutionCacheBasedir() {
        String string = this.getVariable("ivy.cache.resolution");
        if (string != null) {
            return Checks.checkAbsolute(string, "ivy.cache.resolution");
        }
        return this.getDefaultCache();
    }

    public void setDictatorResolver(DependencyResolver resolver) {
        this.dictatorResolver = resolver;
    }

    public DependencyResolver getResolver(ModuleRevisionId mrid) {
        if (this.dictatorResolver != null) {
            return this.dictatorResolver;
        }
        String resolverName = this.getResolverName(mrid);
        return this.getResolver(resolverName);
    }

    public DependencyResolver getResolver(String string) {
        if (this.dictatorResolver != null) {
            return this.dictatorResolver;
        }
        DependencyResolver dependencyResolver = (DependencyResolver)this.resolversMap.get(string);
        if (dependencyResolver == null) {
            Message.error("unknown resolver " + string);
        }
        return dependencyResolver;
    }

    public DependencyResolver getDefaultResolver() {
        if (this.dictatorResolver != null) {
            return this.dictatorResolver;
        }
        if (this.defaultResolver == null) {
            this.defaultResolver = (DependencyResolver)this.resolversMap.get(this.defaultResolverName);
        }
        return this.defaultResolver;
    }

    public String getResolverName(ModuleRevisionId mrid) {
        ModuleSettings ms = (ModuleSettings)this.moduleSettings.getRule(mrid, new Filter(){

            public boolean accept(Object o) {
                return ((ModuleSettings)o).getResolverName() != null;
            }
        });
        return ms == null ? this.defaultResolverName : ms.getResolverName();
    }

    public String getDefaultBranch(ModuleId moduleId) {
        ModuleSettings ms = (ModuleSettings)this.moduleSettings.getRule(moduleId, new Filter(){

            public boolean accept(Object o) {
                return ((ModuleSettings)o).getBranch() != null;
            }
        });
        return ms == null ? this.getDefaultBranch() : ms.getBranch();
    }

    public String getDefaultBranch() {
        return this.defaultBranch;
    }

    public void setDefaultBranch(String defaultBranch) {
        this.defaultBranch = defaultBranch;
    }

    public ConflictManager getConflictManager(ModuleId moduleId) {
        ModuleSettings moduleSettings = (ModuleSettings)this.moduleSettings.getRule(moduleId, new Filter(){

            public boolean accept(Object o) {
                return ((ModuleSettings)o).getConflictManager() != null;
            }
        });
        if (moduleSettings == null) {
            return this.getDefaultConflictManager();
        }
        ConflictManager conflictManager = this.getConflictManager(moduleSettings.getConflictManager());
        if (conflictManager == null) {
            throw new IllegalStateException("ivy badly configured: unknown conflict manager " + moduleSettings.getConflictManager());
        }
        return conflictManager;
    }

    public String getResolveMode(ModuleId moduleId) {
        ModuleSettings ms = (ModuleSettings)this.moduleSettings.getRule(moduleId, new Filter(){

            public boolean accept(Object o) {
                return ((ModuleSettings)o).getResolveMode() != null;
            }
        });
        return ms == null ? this.getDefaultResolveMode() : ms.getResolveMode();
    }

    public String getDefaultResolveMode() {
        return this.defaultResolveMode;
    }

    public void setDefaultResolveMode(String defaultResolveMode) {
        this.defaultResolveMode = defaultResolveMode;
    }

    public ConflictManager getConflictManager(String name) {
        if ("default".equals(name)) {
            return this.getDefaultConflictManager();
        }
        return (ConflictManager)this.conflictsManager.get(name);
    }

    public void addConflictManager(String name, ConflictManager cm) {
        this.init(cm);
        this.conflictsManager.put(name, cm);
    }

    public LatestStrategy getLatestStrategy(String name) {
        if ("default".equals(name)) {
            return this.getDefaultLatestStrategy();
        }
        return (LatestStrategy)this.latestStrategies.get(name);
    }

    public void addLatestStrategy(String name, LatestStrategy latest) {
        this.init(latest);
        this.latestStrategies.put(name, latest);
    }

    public LockStrategy getLockStrategy(String name) {
        if ("default".equals(name)) {
            return this.getDefaultLockStrategy();
        }
        return (LockStrategy)this.lockStrategies.get(name);
    }

    public void addLockStrategy(String name, LockStrategy lockStrategy) {
        this.init(lockStrategy);
        this.lockStrategies.put(name, lockStrategy);
    }

    public Namespace getNamespace(String string) {
        if ("system".equals(string)) {
            return this.getSystemNamespace();
        }
        return (Namespace)this.namespaces.get(string);
    }

    public Namespace getSystemNamespace() {
        return Namespace.SYSTEM_NAMESPACE;
    }

    public PatternMatcher getMatcher(String name) {
        return (PatternMatcher)this.matchers.get(name);
    }

    public void addMatcher(PatternMatcher m) {
        this.init(m);
        this.matchers.put(m.getName(), m);
    }

    public RepositoryCacheManager getRepositoryCacheManager(String name) {
        return (RepositoryCacheManager)this.repositoryCacheManagers.get(name);
    }

    public void addRepositoryCacheManager(RepositoryCacheManager c) {
        this.init(c);
        this.repositoryCacheManagers.put(c.getName(), c);
    }

    public RepositoryCacheManager[] getRepositoryCacheManagers() {
        return this.repositoryCacheManagers.values().toArray(new RepositoryCacheManager[this.repositoryCacheManagers.size()]);
    }

    public void addReportOutputter(ReportOutputter outputter) {
        this.init(outputter);
        this.reportOutputters.put(outputter.getName(), outputter);
    }

    public ReportOutputter[] getReportOutputters() {
        return this.reportOutputters.values().toArray(new ReportOutputter[this.reportOutputters.size()]);
    }

    public void addVersionMatcher(VersionMatcher vmatcher) {
        this.init(vmatcher);
        this.versionMatchers.put(vmatcher.getName(), vmatcher);
        if (this.versionMatcher == null) {
            this.versionMatcher = new ChainVersionMatcher();
            this.addVersionMatcher(new ExactVersionMatcher());
        }
        if (this.versionMatcher instanceof ChainVersionMatcher) {
            ChainVersionMatcher chain = (ChainVersionMatcher)this.versionMatcher;
            chain.add(vmatcher);
        }
    }

    public VersionMatcher getVersionMatcher() {
        if (this.versionMatcher == null) {
            this.configureDefaultVersionMatcher();
        }
        return this.versionMatcher;
    }

    public void configureDefaultVersionMatcher() {
        this.addVersionMatcher(new LatestVersionMatcher());
        this.addVersionMatcher(new SubVersionMatcher());
        this.addVersionMatcher(new VersionRangeMatcher());
    }

    public CircularDependencyStrategy getCircularDependencyStrategy() {
        if (this.circularDependencyStrategy == null) {
            this.circularDependencyStrategy = this.getCircularDependencyStrategy("default");
        }
        return this.circularDependencyStrategy;
    }

    public CircularDependencyStrategy getCircularDependencyStrategy(String string) {
        if ("default".equals(string)) {
            string = "warn";
        }
        return (CircularDependencyStrategy)this.circularDependencyStrategies.get(string);
    }

    public void setCircularDependencyStrategy(CircularDependencyStrategy strategy) {
        this.circularDependencyStrategy = strategy;
    }

    private void addCircularDependencyStrategy(CircularDependencyStrategy strategy) {
        this.circularDependencyStrategies.put(strategy.getName(), strategy);
    }

    private void configureDefaultCircularDependencyStrategies() {
        this.addCircularDependencyStrategy(WarnCircularDependencyStrategy.getInstance());
        this.addCircularDependencyStrategy(ErrorCircularDependencyStrategy.getInstance());
        this.addCircularDependencyStrategy(IgnoreCircularDependencyStrategy.getInstance());
    }

    public StatusManager getStatusManager() {
        if (this.statusManager == null) {
            this.statusManager = StatusManager.newDefaultInstance();
        }
        return this.statusManager;
    }

    public void setStatusManager(StatusManager statusManager) {
        this.statusManager = statusManager;
    }

    public String[] getIgnorableFilenames() {
        return this.listingIgnore.toArray(new String[this.listingIgnore.size()]);
    }

    public void filterIgnore(Collection names) {
        names.removeAll(this.listingIgnore);
    }

    public boolean isCheckUpToDate() {
        return this.checkUpToDate;
    }

    public void setCheckUpToDate(boolean checkUpToDate) {
        this.checkUpToDate = checkUpToDate;
    }

    public boolean doValidate() {
        return this.validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public String getVariable(String name) {
        return this.variableContainer.getVariable(name);
    }

    public ConflictManager getDefaultConflictManager() {
        if (this.defaultConflictManager == null) {
            this.defaultConflictManager = new LatestConflictManager(this.getDefaultLatestStrategy());
            ((LatestConflictManager)this.defaultConflictManager).setSettings(this);
        }
        return this.defaultConflictManager;
    }

    public void setDefaultConflictManager(ConflictManager defaultConflictManager) {
        this.defaultConflictManager = defaultConflictManager;
    }

    public LatestStrategy getDefaultLatestStrategy() {
        if (this.defaultLatestStrategy == null) {
            this.defaultLatestStrategy = new LatestRevisionStrategy();
        }
        return this.defaultLatestStrategy;
    }

    public void setDefaultLatestStrategy(LatestStrategy defaultLatestStrategy) {
        this.defaultLatestStrategy = defaultLatestStrategy;
    }

    public LockStrategy getDefaultLockStrategy() {
        if (this.defaultLockStrategy == null) {
            this.defaultLockStrategy = new NoLockStrategy();
        }
        return this.defaultLockStrategy;
    }

    public void setDefaultLockStrategy(LockStrategy defaultLockStrategy) {
        this.defaultLockStrategy = defaultLockStrategy;
    }

    public RepositoryCacheManager getDefaultRepositoryCacheManager() {
        if (this.defaultRepositoryCacheManager == null) {
            this.defaultRepositoryCacheManager = new DefaultRepositoryCacheManager("default-cache", this, this.getDefaultRepositoryCacheBasedir());
            this.addRepositoryCacheManager(this.defaultRepositoryCacheManager);
        }
        return this.defaultRepositoryCacheManager;
    }

    public void setDefaultRepositoryCacheManager(RepositoryCacheManager cache) {
        this.defaultRepositoryCacheManager = cache;
    }

    public ResolutionCacheManager getResolutionCacheManager() {
        if (this.resolutionCacheManager == null) {
            this.resolutionCacheManager = new DefaultResolutionCacheManager(this.getDefaultResolutionCacheBasedir());
        }
        return this.resolutionCacheManager;
    }

    public List getTriggers() {
        return this.triggers;
    }

    public void setUseRemoteConfig(boolean useRemoteConfig) {
        this.useRemoteConfig = useRemoteConfig;
    }

    public boolean logModulesInUse() {
        String string = this.getVariable("ivy.log.modules.in.use");
        return string == null || Boolean.valueOf(string) != false;
    }

    public boolean logModuleWhenFound() {
        String string = this.getVariable("ivy.log.module.when.found");
        return string == null || Boolean.valueOf(string) != false;
    }

    public boolean logResolvedRevision() {
        String string = this.getVariable("ivy.log.resolved.revision");
        return string == null || Boolean.valueOf(string) != false;
    }

    public boolean debugConflictResolution() {
        if (this.debugConflictResolution == null) {
            String string = this.getVariable("ivy.log.conflict.resolution");
            this.debugConflictResolution = string != null && Boolean.valueOf(string) != false;
        }
        return this.debugConflictResolution;
    }

    public final boolean debugLocking() {
        if (this.debugLocking == null) {
            String string = this.getVariable("ivy.log.locking");
            this.debugLocking = string != null && Boolean.valueOf(string) != false;
        }
        return this.debugLocking;
    }

    public boolean logNotConvertedExclusionRule() {
        return this.logNotConvertedExclusionRule;
    }

    private void init(Object obj) {
        if (obj instanceof IvySettingsAware) {
            ((IvySettingsAware)obj).setSettings(this);
        } else if (obj instanceof DependencyResolver) {
            ((DependencyResolver)obj).setSettings(this);
        }
    }

    public Collection getResolvers() {
        return this.resolversMap.values();
    }

    public IvyVariableContainer getVariableContainer() {
        return this.variableContainer;
    }

    public void setVariableContainer(IvyVariableContainer variables) {
        this.variableContainer = variables;
    }

    public RelativeUrlResolver getRelativeUrlResolver() {
        return new NormalRelativeUrlResolver();
    }

    public void setDefaultCacheIvyPattern(String defaultCacheIvyPattern) {
        CacheUtil.checkCachePattern(defaultCacheIvyPattern);
        this.defaultCacheIvyPattern = defaultCacheIvyPattern;
    }

    public String getDefaultCacheIvyPattern() {
        return this.defaultCacheIvyPattern;
    }

    public void setDefaultCacheArtifactPattern(String defaultCacheArtifactPattern) {
        CacheUtil.checkCachePattern(defaultCacheArtifactPattern);
        this.defaultCacheArtifactPattern = defaultCacheArtifactPattern;
    }

    public String getDefaultCacheArtifactPattern() {
        return this.defaultCacheArtifactPattern;
    }

    public void setDefaultUseOrigin(boolean useOrigin) {
        this.defaultUseOrigin = useOrigin;
    }

    public boolean isDefaultUseOrigin() {
        return this.defaultUseOrigin;
    }

    public void validate() {
        this.validateAll(this.resolversMap.values());
        this.validateAll(this.conflictsManager.values());
        this.validateAll(this.latestStrategies.values());
        this.validateAll(this.lockStrategies.values());
        this.validateAll(this.repositoryCacheManagers.values());
        this.validateAll(this.reportOutputters.values());
        this.validateAll(this.circularDependencyStrategies.values());
        this.validateAll(this.versionMatchers.values());
        this.validateAll(this.namespaces.values());
    }

    private void validateAll(Collection values) {
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Validatable)) continue;
            ((Validatable)object).validate();
        }
    }

    public Namespace getContextNamespace() {
        return Namespace.SYSTEM_NAMESPACE;
    }

    private static class ModuleSettings {
        private String resolverName;
        private String branch;
        private String conflictManager;
        private String resolveMode;

        public ModuleSettings(String resolver, String branchName, String conflictMgr, String resolveMode) {
            this.resolverName = resolver;
            this.branch = branchName;
            this.conflictManager = conflictMgr;
            this.resolveMode = resolveMode;
        }

        public String toString() {
            return (this.resolverName != null ? "resolver: " + this.resolverName : "") + (this.branch != null ? "branch: " + this.branch : "") + (this.conflictManager != null ? "conflictManager: " + this.conflictManager : "") + (this.resolveMode != null ? "resolveMode: " + this.resolveMode : "");
        }

        public String getBranch() {
            return this.branch;
        }

        public String getResolverName() {
            return this.resolverName;
        }

        public String getConflictManager() {
            return this.conflictManager;
        }

        public String getResolveMode() {
            return this.resolveMode;
        }
    }
}

