/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.BindingReference;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.instruct.DocumentInstr;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.GeneralVariable;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.style.Declaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLGlobalParam;
import net.sf.saxon.style.XSLLocalParam;
import net.sf.saxon.style.XSLWithParam;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceBinding {
    private StyleElement sourceElement;
    private StructuredQName name;
    private Expression select = null;
    private SequenceType declaredType = null;
    private SequenceType inferredType = null;
    protected String constantText = null;
    protected SlotManager slotManager = null;
    protected GeneralVariable compiledVariable = null;
    private boolean textonly;
    private int properties;
    public static final int PRIVATE = 1;
    public static final int GLOBAL = 2;
    public static final int PARAM = 4;
    public static final int TUNNEL = 8;
    public static final int REQUIRED = 16;
    public static final int IMPLICITLY_REQUIRED = 32;
    public static final int ASSIGNABLE = 64;
    public static final int SELECT = 128;
    public static final int AS = 256;
    public static final int DISALLOWS_CONTENT = 512;
    public static final int GROUP = 1024;
    public static final int STATIC = 2048;
    private List<BindingReference> references = new ArrayList<BindingReference>(10);

    public SourceBinding(StyleElement sourceElement) {
        this.sourceElement = sourceElement;
    }

    public void prepareAttributes(int permittedAttributes) throws XPathException {
        AttributeCollection atts = this.sourceElement.getAttributeList();
        String selectAtt = null;
        String asAtt = null;
        String requiredAtt = null;
        String tunnelAtt = null;
        String assignableAtt = null;
        String staticAtt = null;
        for (int a = 0; a < atts.getLength(); ++a) {
            String f = atts.getQName(a);
            if (f.equals("name")) {
                if (this.name != null && !this.name.equals(this.errorName())) continue;
                this.processVariableName(atts.getValue(a));
                continue;
            }
            if (f.equals("select")) {
                if ((permittedAttributes & 0x80) != 0) {
                    selectAtt = atts.getValue(a);
                    continue;
                }
                this.sourceElement.compileError("The select attribute is not permitted on a function parameter", "XTSE0760");
                continue;
            }
            if (f.equals("as") && (permittedAttributes & 0x100) != 0) {
                asAtt = atts.getValue(a);
                continue;
            }
            if (f.equals("required") && (permittedAttributes & 0x10) != 0) {
                requiredAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("tunnel")) {
                tunnelAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("static") && (permittedAttributes & 0x800) != 0) {
                staticAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (atts.getLocalName(a).equals("assignable") && "http://saxon.sf.net/".equals(atts.getURI(a)) && (permittedAttributes & 0x40) != 0) {
                assignableAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            this.sourceElement.checkUnknownAttribute(atts.getNodeName(a));
        }
        if (this.name == null) {
            this.sourceElement.reportAbsence("name");
            this.name = this.errorName();
        }
        if (selectAtt != null) {
            this.select = this.sourceElement.makeExpression(selectAtt);
        }
        if (requiredAtt != null) {
            if (requiredAtt.equals("yes")) {
                this.setProperty(16, true);
            } else if (requiredAtt.equals("no")) {
                this.setProperty(16, false);
            } else {
                this.sourceElement.compileError("The attribute 'required' must be set to 'yes' or 'no'", "XTSE0020");
            }
        }
        if (tunnelAtt != null) {
            if (tunnelAtt.equals("yes")) {
                if ((permittedAttributes & 8) == 0) {
                    this.sourceElement.compileError("The only permitted value of the 'tunnel' attribute is 'no'", "XTSE0020");
                } else {
                    this.setProperty(8, true);
                }
            } else if (tunnelAtt.equals("no")) {
                this.setProperty(8, false);
            } else {
                this.sourceElement.compileError("The attribute 'tunnel' must be set to 'yes' or 'no'", "XTSE0020");
            }
        }
        if (assignableAtt != null) {
            if (assignableAtt.equals("yes")) {
                this.setProperty(64, true);
            } else if (assignableAtt.equals("no")) {
                this.setProperty(64, false);
            } else {
                this.sourceElement.compileError("The attribute 'saxon:assignable' must be set to 'yes' or 'no'", "XTSE0020");
            }
        }
        if (staticAtt != null) {
            if (this.sourceElement.isXslt30Processor()) {
                if (staticAtt.equals("yes")) {
                    this.setProperty(2048, true);
                    this.setProperty(512, true);
                } else if (staticAtt.equals("no")) {
                    this.setProperty(2048, false);
                }
            } else if (!this.sourceElement.forwardsCompatibleModeIsEnabled()) {
                this.sourceElement.compileError("The attribute 'static' is not allowed", "XTSE0020");
            }
        }
        if (asAtt != null) {
            this.declaredType = this.sourceElement.makeSequenceType(asAtt);
        }
    }

    public StyleElement getSourceElement() {
        return this.sourceElement;
    }

    public void setVariableQName(StructuredQName name) {
        this.name = name;
    }

    private void processVariableName(String nameAttribute) throws XPathException {
        try {
            if (nameAttribute != null) {
                this.name = this.sourceElement.makeQName(nameAttribute);
            }
        }
        catch (NamespaceException err) {
            this.name = this.errorName();
            throw new XPathException("Invalid variable name: " + err.getMessage(), "XTSE0020");
        }
        catch (XPathException err) {
            this.name = this.errorName();
            throw new XPathException("Invalid variable name: " + err.getMessage() + (nameAttribute.startsWith("$") ? " (No '$' sign needed)" : ""), "XTSE0020");
        }
    }

    private StructuredQName errorName() {
        return new StructuredQName("saxon", "http://saxon.sf.net/", "error-variable-name");
    }

    public void validate() throws XPathException {
        if (this.select != null && this.sourceElement.hasChildNodes()) {
            this.sourceElement.compileError("An " + this.name.getDisplayName() + " element with a select attribute must be empty", "XTSE0620");
        }
        if (this.hasProperty(512) && this.sourceElement.hasChildNodes()) {
            this.sourceElement.compileError("The xsl:param child of xsl:function must have no content", "XTSE0620");
        }
    }

    public void postValidate() throws XPathException {
        this.checkAgainstRequiredType(this.declaredType);
        if (this.select == null && !this.hasProperty(512)) {
            this.textonly = true;
            AxisIterator kids = this.sourceElement.iterateAxis((byte)3);
            Object first = kids.next();
            if (first == null) {
                if (this.declaredType == null) {
                    this.select = new StringLiteral(StringValue.EMPTY_STRING);
                } else if (this.sourceElement instanceof XSLLocalParam || this.sourceElement instanceof XSLGlobalParam) {
                    if (!this.hasProperty(16)) {
                        if (Cardinality.allowsZero(this.declaredType.getCardinality())) {
                            this.select = Literal.makeEmptySequence();
                        } else {
                            this.setProperty(32, true);
                        }
                    }
                } else if (Cardinality.allowsZero(this.declaredType.getCardinality())) {
                    this.select = Literal.makeEmptySequence();
                } else {
                    this.sourceElement.compileError("The implicit value () is not valid for the declared type", "XTTE0570");
                }
            } else {
                if (kids.next() == null && first.getNodeKind() == 3) {
                    this.constantText = first.getStringValue();
                }
                this.textonly = this.sourceElement.getCommonChildItemType() == NodeKindTest.TEXT;
            }
        }
        this.select = this.sourceElement.typeCheck("select", this.select);
    }

    public boolean isStatic() {
        return this.hasProperty(2048);
    }

    public void checkAgainstRequiredType(SequenceType required) throws XPathException {
        try {
            if (required != null && this.select != null) {
                int category = 3;
                String errorCode = "XTTE0570";
                if (this.sourceElement instanceof XSLLocalParam) {
                    category = 8;
                    errorCode = "XTTE0600";
                } else if (this.sourceElement instanceof XSLWithParam) {
                    category = 8;
                    errorCode = "XTTE0590";
                }
                RoleLocator role = new RoleLocator(category, this.name.getDisplayName(), 0);
                role.setErrorCode(errorCode);
                this.select = TypeChecker.staticTypeCheck(this.select, required, false, role, this.sourceElement.makeExpressionVisitor());
            }
        }
        catch (XPathException err) {
            err.setLocator(this.sourceElement);
            this.sourceElement.compileError(err);
            this.select = new ErrorExpression(err);
        }
    }

    public StructuredQName getVariableQName() {
        if (this.name == null) {
            try {
                this.processVariableName(this.sourceElement.getAttributeValue("", "name"));
            }
            catch (XPathException e) {
                return this.errorName();
            }
        }
        return this.name;
    }

    public void setProperty(int prop, boolean flag) {
        this.properties = flag ? (this.properties |= prop) : (this.properties &= ~prop);
    }

    public boolean hasProperty(int prop) {
        return (this.properties & prop) != 0;
    }

    public List<BindingReference> getReferences() {
        return this.references;
    }

    public SlotManager getSlotManager() {
        return this.slotManager;
    }

    public void handleSequenceConstructor(Executable exec, Declaration decl) throws XPathException {
        if (this.sourceElement.hasChildNodes()) {
            if (this.declaredType == null) {
                DocumentInstr doc = new DocumentInstr(this.textonly, this.constantText, this.sourceElement.getBaseURI());
                Expression b = this.sourceElement.compileSequenceConstructor(exec, decl, this.sourceElement.iterateAxis((byte)3), true);
                if (b == null) {
                    b = Literal.makeEmptySequence();
                }
                doc.setContentExpression(b);
                this.select = doc;
            } else {
                this.select = this.sourceElement.compileSequenceConstructor(exec, decl, this.sourceElement.iterateAxis((byte)3), true);
                if (this.select == null) {
                    this.select = Literal.makeEmptySequence();
                }
                try {
                    assert (this.select != null);
                    this.select.setContainer(this.sourceElement);
                    RoleLocator role = new RoleLocator(3, this.name.getDisplayName(), 0);
                    role.setErrorCode("XTTE0570");
                    this.select = this.sourceElement.makeExpressionVisitor().simplify(this.select);
                    this.select = TypeChecker.staticTypeCheck(this.select, this.declaredType, false, role, this.sourceElement.makeExpressionVisitor());
                }
                catch (XPathException err) {
                    err.setLocator(this.sourceElement);
                    this.sourceElement.compileError(err);
                    this.select = new ErrorExpression(err);
                }
            }
        }
    }

    public SequenceType getDeclaredType() {
        if (this.declaredType == null) {
            String asAtt = this.sourceElement.getAttributeValue("", "as");
            if (asAtt == null) {
                return null;
            }
            try {
                this.declaredType = this.sourceElement.makeSequenceType(asAtt);
            }
            catch (XPathException xPathException) {
                // empty catch block
            }
        }
        return this.declaredType;
    }

    public Expression getSelectExpression() {
        return this.select;
    }

    public SequenceType getInferredType(boolean useContentRules) {
        if (this.inferredType != null) {
            return this.inferredType;
        }
        if (this.hasProperty(4) || this.hasProperty(64)) {
            this.inferredType = this.declaredType == null ? SequenceType.ANY_SEQUENCE : this.declaredType;
            return this.inferredType;
        }
        if (this.select != null) {
            TypeHierarchy th = this.sourceElement.getConfiguration().getTypeHierarchy();
            if (Literal.isEmptySequence(this.select)) {
                this.inferredType = this.declaredType == null ? SequenceType.ANY_SEQUENCE : this.declaredType;
                return this.inferredType;
            }
            ItemType actual = this.select.getItemType(th);
            int card = this.select.getCardinality();
            if (this.declaredType != null) {
                if (!th.isSubType(actual, this.declaredType.getPrimaryType())) {
                    actual = this.declaredType.getPrimaryType();
                }
                if (!Cardinality.subsumes(this.declaredType.getCardinality(), card)) {
                    card = this.declaredType.getCardinality();
                }
            }
            this.inferredType = SequenceType.makeSequenceType(actual, card);
            return this.inferredType;
        }
        if (useContentRules) {
            if (this.sourceElement.hasChildNodes()) {
                if (this.declaredType == null) {
                    return SequenceType.makeSequenceType(NodeKindTest.DOCUMENT, 16384);
                }
                return this.declaredType;
            }
            if (this.declaredType == null) {
                return SequenceType.SINGLE_STRING;
            }
            return this.declaredType;
        }
        return this.declaredType;
    }

    public void registerReference(BindingReference ref) {
        this.references.add(ref);
    }

    public void fixupReferences() throws XPathException {
        SequenceType type = this.getInferredType(true);
        TypeHierarchy th = this.sourceElement.getConfiguration().getTypeHierarchy();
        GroundedValue constantValue = null;
        int properties = 0;
        if (!this.hasProperty(64) && !this.hasProperty(4)) {
            int relation;
            if (this.select instanceof Literal && ((relation = th.relationship(this.select.getItemType(th), type.getPrimaryType())) == 0 || relation == 2)) {
                constantValue = ((Literal)this.select).getValue();
            }
            if (this.select != null) {
                properties = this.select.getSpecialProperties();
            }
        }
        for (BindingReference reference : this.references) {
            reference.setStaticType(type, constantValue, properties);
        }
    }

    protected void fixupBinding(Binding binding) {
        for (BindingReference reference : this.references) {
            reference.fixup(binding);
        }
    }

    protected void setReferenceCount(GeneralVariable var) {
        var.setReferenceCount(10);
    }

    public GeneralVariable getCompiledVariable() {
        return this.compiledVariable;
    }
}

