/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.TransformerException;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.instruct.AttributeSet;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.FixedAttribute;
import net.sf.saxon.expr.instruct.FixedElement;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.TraceExpression;
import net.sf.saxon.expr.instruct.UseAttributeSets;
import net.sf.saxon.lib.Validation;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.CodedName;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NoNamespaceName;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.Declaration;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StyleNodeFactory;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.linked.DocumentImpl;
import net.sf.saxon.tree.linked.LinkedTreeBuilder;
import net.sf.saxon.tree.util.NamespaceIterator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Untyped;

public class LiteralResultElement
extends StyleElement {
    private int resultNameCode;
    private NodeName[] attributeNames;
    private Expression[] attributeValues;
    private Expression onEmpty;
    private int numberOfAttributes;
    private boolean toplevel;
    private List<NamespaceBinding> namespaceCodes = new ArrayList<NamespaceBinding>();
    private AttributeSet[] attributeSets;
    private SchemaType schemaType = null;
    private int validation = 4;
    private boolean inheritNamespaces = true;

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public boolean isInstruction() {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        int num = atts.getLength();
        if (num == 0) {
            this.numberOfAttributes = 0;
        } else {
            NamePool namePool = this.getNamePool();
            this.attributeNames = new NodeName[num];
            this.attributeValues = new Expression[num];
            this.numberOfAttributes = 0;
            for (int i = 0; i < num; ++i) {
                Expression exp;
                int anameCode = atts.getNameCode(i);
                short attURIcode = namePool.getURICode(anameCode);
                if (attURIcode == 2) {
                    int fp = anameCode & 0xFFFFF;
                    if (fp == 235 || fp == 228 || fp == 231 || fp == 229 || fp == 230 || fp == 238 || fp == 239 || fp == 234 || fp == 236 || fp == 237) continue;
                    if (fp == 232) {
                        String inheritAtt = atts.getValue(i);
                        if (inheritAtt.equals("yes")) {
                            this.inheritNamespaces = true;
                            continue;
                        }
                        if (inheritAtt.equals("no")) {
                            this.inheritNamespaces = false;
                            continue;
                        }
                        this.compileError("The xsl:inherit-namespaces attribute has permitted values (yes, no)", "XTSE0020");
                        continue;
                    }
                    if (fp == 233) {
                        if (!this.isXslt30Processor()) {
                            this.compileError("The 'xsl:on-empty' attribute requires XSLT 3.0");
                        }
                        this.onEmpty = this.makeExpression(atts.getValue(i));
                        continue;
                    }
                    this.compileError("Unknown XSL attribute " + namePool.getDisplayName(anameCode), "XTSE0805");
                    continue;
                }
                this.attributeNames[this.numberOfAttributes] = new FingerprintedQName(atts.getPrefix(i), atts.getURI(i), atts.getLocalName(i), anameCode);
                this.attributeValues[this.numberOfAttributes] = exp = this.makeAttributeValueTemplate(atts.getValue(i));
                ++this.numberOfAttributes;
            }
            if (this.numberOfAttributes < this.attributeNames.length) {
                NodeName[] attributeNames2 = new NodeName[this.numberOfAttributes];
                System.arraycopy(this.attributeNames, 0, attributeNames2, 0, this.numberOfAttributes);
                this.attributeNames = attributeNames2;
                Expression[] attributeValues2 = new Expression[this.numberOfAttributes];
                System.arraycopy(this.attributeValues, 0, attributeValues2, 0, this.numberOfAttributes);
                this.attributeValues = attributeValues2;
            }
        }
    }

    public void validate(Declaration decl) throws XPathException {
        this.toplevel = this.getParent() instanceof XSLStylesheet;
        this.resultNameCode = this.getNameCode();
        NamePool namePool = this.getNamePool();
        String elementURI = namePool.getURI(this.resultNameCode);
        if (this.toplevel) {
            if (elementURI.length() == 0) {
                this.compileError("Top level elements must have a non-null namespace URI", "XTSE0130");
            }
        } else {
            String validate;
            String useAttSets;
            Iterator<NamespaceBinding> inscope = NamespaceIterator.iterateNamespaces(this);
            while (inscope.hasNext()) {
                this.namespaceCodes.add(inscope.next());
            }
            PrincipalStylesheetModule sheet = this.getPrincipalStylesheetModule();
            if (sheet.hasNamespaceAliases()) {
                for (int i = 0; i < this.namespaceCodes.size(); ++i) {
                    String suri = this.namespaceCodes.get(i).getURI();
                    NamespaceBinding ncode = sheet.getNamespaceAlias(suri);
                    if (ncode == null || ncode.getURI().equals(suri)) continue;
                    this.namespaceCodes.set(i, ncode);
                }
                NamespaceBinding elementAlias = sheet.getNamespaceAlias(elementURI);
                if (elementAlias != null && !elementAlias.getURI().equals(elementURI)) {
                    this.resultNameCode = namePool.allocate(elementAlias.getPrefix(), elementAlias.getURI(), this.getLocalPart());
                }
            }
            if ((useAttSets = this.getAttributeValue("http://www.w3.org/1999/XSL/Transform", "use-attribute-sets")) != null) {
                this.attributeSets = this.getAttributeSets(useAttSets, null);
            }
            this.validation = this.getContainingStylesheet().getDefaultValidation();
            String type = this.getAttributeValue("http://www.w3.org/1999/XSL/Transform", "type");
            if (type != null) {
                if (!this.getPreparedStylesheet().isSchemaAware()) {
                    this.compileError("The xsl:type attribute is available only with a schema-aware XSLT processor", "XTSE1660");
                }
                this.schemaType = this.getSchemaType(type);
                this.validation = 8;
            }
            if ((validate = this.getAttributeValue("http://www.w3.org/1999/XSL/Transform", "validation")) != null) {
                this.validation = Validation.getCode(validate);
                if (this.validation != 4 && !this.getPreparedStylesheet().isSchemaAware()) {
                    this.validation = 4;
                    this.compileError("To perform validation, a schema-aware XSLT processor is needed", "XTSE1660");
                }
                if (this.validation == -1) {
                    this.compileError("Invalid value for xsl:validation. Permitted values are (strict, lax, preserve, strip)", "XTSE0020");
                }
                if (this.schemaType != null) {
                    this.compileError("The attributes xsl:type and xsl:validation are mutually exclusive", "XTSE1505");
                }
            }
            if (this.numberOfAttributes > 0) {
                for (int i = 0; i < this.numberOfAttributes; ++i) {
                    NamespaceBinding newBinding;
                    NodeName anameCode;
                    NodeName alias = anameCode = this.attributeNames[i];
                    String attURI = anameCode.getURI();
                    if (attURI.length() != 0 && (newBinding = sheet.getNamespaceAlias(attURI)) != null && !newBinding.getURI().equals(attURI)) {
                        alias = new FingerprintedQName(newBinding.getPrefix(), newBinding.getURI(), this.getAttributeList().getLocalName(i));
                    }
                    this.attributeNames[i] = alias;
                    this.attributeValues[i] = this.typeCheck(alias.getDisplayName(), this.attributeValues[i]);
                }
            }
            for (int n = this.namespaceCodes.size() - 1; n >= 0; --n) {
                String uri = this.namespaceCodes.get(n).getURI();
                if (!this.isExcludedNamespace(uri) || sheet.isAliasResultNamespace(uri)) continue;
                this.namespaceCodes.remove(n);
            }
        }
    }

    protected void validateChildren(Declaration decl) throws XPathException {
        if (!this.toplevel) {
            super.validateChildren(decl);
        }
    }

    public Expression compile(Executable exec, Declaration decl) throws XPathException {
        if (this.toplevel) {
            return null;
        }
        NamespaceBinding[] bindings = this.namespaceCodes.toArray(new NamespaceBinding[this.namespaceCodes.size()]);
        FixedElement inst = new FixedElement(new CodedName(this.resultNameCode, this.getNamePool()), bindings, this.inheritNamespaces, this.schemaType, this.validation);
        inst.setBaseURI(this.getBaseURI());
        if (this.onEmpty != null) {
            inst.setOnEmpty(this.onEmpty);
        }
        Expression content = this.compileSequenceConstructor(exec, decl, this.iterateAxis((byte)3), true);
        if (this.numberOfAttributes > 0) {
            for (int i = this.attributeNames.length - 1; i >= 0; --i) {
                FixedAttribute att = new FixedAttribute(this.attributeNames[i], 4, null);
                att.setSelect(this.attributeValues[i], exec.getConfiguration());
                att.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
                Instruction exp = att;
                if (this.getConfiguration().isCompileWithTracing()) {
                    TraceExpression trace = new TraceExpression(exp);
                    trace.setNamespaceResolver(this.getNamespaceResolver());
                    trace.setConstructType(2007);
                    trace.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
                    trace.setObjectName(this.attributeNames[i].getStructuredQName());
                    exp = trace;
                }
                if (content == null) {
                    content = exp;
                    continue;
                }
                content = Block.makeBlock(exp, content);
                content.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
            }
        }
        if (this.attributeSets != null) {
            UseAttributeSets use = new UseAttributeSets(this.attributeSets);
            if (content == null) {
                content = use;
            } else {
                content = Block.makeBlock(use, content);
                content.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
            }
        }
        if (content == null) {
            content = Literal.makeEmptySequence();
        }
        inst.setContentExpression(content);
        return inst;
    }

    public DocumentImpl makeStylesheet(PreparedStylesheet pss) throws XPathException {
        StyleNodeFactory nodeFactory = pss.getStyleNodeFactory();
        NamePool pool = this.getNamePool();
        String xslPrefix = this.getPrefixForURI("http://www.w3.org/1999/XSL/Transform");
        if (xslPrefix == null) {
            String message = this.getLocalPart().equals("stylesheet") || this.getLocalPart().equals("transform") ? (this.getPrefixForURI("http://www.w3.org/TR/WD-xsl") != null ? "Saxon is not able to process Microsoft's WD-xsl dialect" : "Namespace for stylesheet element should be http://www.w3.org/1999/XSL/Transform") : "The supplied file does not appear to be a stylesheet";
            XPathException err = new XPathException(message);
            err.setLocator(this);
            err.setErrorCode("XTSE0150");
            err.setIsStaticError(true);
            try {
                pss.reportError(err);
            }
            catch (TransformerException err2) {
                // empty catch block
            }
            throw err;
        }
        String version = this.getAttributeValue("http://www.w3.org/1999/XSL/Transform", "version");
        if (version == null) {
            XPathException err = new XPathException("Simplified stylesheet: xsl:version attribute is missing");
            err.setErrorCode("XTSE0150");
            err.setIsStaticError(true);
            err.setLocator(this);
            try {
                pss.reportError(err);
            }
            catch (TransformerException err2) {
                // empty catch block
            }
            throw err;
        }
        try {
            DocumentImpl oldRoot = (DocumentImpl)this.getDocumentRoot();
            LinkedTreeBuilder builder = new LinkedTreeBuilder(pss.getConfiguration().makePipelineConfiguration());
            builder.setNodeFactory(nodeFactory);
            builder.setSystemId(this.getSystemId());
            builder.open();
            builder.startDocument(0);
            int st = 199;
            builder.startElement(new CodedName(st, this.getNamePool()), Untyped.getInstance(), 0, 0);
            builder.namespace(new NamespaceBinding("xsl", "http://www.w3.org/1999/XSL/Transform"), 0);
            builder.attribute(new NoNamespaceName("version"), BuiltInAtomicType.UNTYPED_ATOMIC, version, 0, 0);
            builder.startContent();
            int te = 200;
            builder.startElement(new CodedName(te, this.getNamePool()), Untyped.getInstance(), 0, 0);
            builder.attribute(new NoNamespaceName("match"), BuiltInAtomicType.UNTYPED_ATOMIC, "/", 0, 0);
            builder.startContent();
            builder.graftElement(this);
            builder.endElement();
            builder.endElement();
            builder.endDocument();
            builder.close();
            DocumentImpl newRoot = (DocumentImpl)builder.getCurrentRoot();
            newRoot.graftLocationMap(oldRoot);
            return newRoot;
        }
        catch (XPathException err) {
            err.setLocator(this);
            throw err;
        }
    }

    public int getConstructType() {
        return 2006;
    }

    public StructuredQName getObjectName() {
        return new StructuredQName(this.getPrefix(), this.getURI(), this.getLocalPart());
    }

    public Object getProperty(String name) {
        if (name.equals("name")) {
            return this.getDisplayName();
        }
        return null;
    }
}

