/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.processor;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.pmd.PMDConfiguration;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.RuleSets;
import net.sourceforge.pmd.RulesetsFactoryUtils;
import net.sourceforge.pmd.SourceCodeProcessor;
import net.sourceforge.pmd.annotation.InternalApi;
import net.sourceforge.pmd.benchmark.TimeTracker;
import net.sourceforge.pmd.benchmark.TimedOperation;
import net.sourceforge.pmd.benchmark.TimedOperationCategory;
import net.sourceforge.pmd.processor.PmdRunnable;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.util.IOUtil;
import net.sourceforge.pmd.util.datasource.DataSource;
import org.apache.commons.lang3.exception.ContextedRuntimeException;

@Deprecated
@InternalApi
public abstract class AbstractPMDProcessor {
    private static final Logger LOG = Logger.getLogger(AbstractPMDProcessor.class.getName());
    protected final PMDConfiguration configuration;

    public AbstractPMDProcessor(PMDConfiguration configuration) {
        this.configuration = configuration;
    }

    public void renderReports(List<Renderer> renderers, Report report) {
        try (TimedOperation to = TimeTracker.startOperation(TimedOperationCategory.REPORTING);){
            for (Renderer r : renderers) {
                r.renderFileReport(report);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Deprecated
    protected String filenameFrom(DataSource dataSource) {
        return dataSource.getNiceFileName(this.configuration.isReportShortNames(), this.configuration.getInputPaths());
    }

    @Deprecated
    protected RuleSets createRuleSets(RuleSetFactory factory, Report report) {
        RuleSets rs = RulesetsFactoryUtils.getRuleSets(this.configuration.getRuleSets(), factory);
        AbstractPMDProcessor.reportBrokenRules(report, rs);
        return rs;
    }

    @Deprecated
    public static void reportBrokenRules(Report report, RuleSets rs) {
        Set<Rule> brokenRules = AbstractPMDProcessor.removeBrokenRules(rs);
        for (Rule rule : brokenRules) {
            report.addConfigError(new Report.ConfigurationError(rule, rule.dysfunctionReason()));
        }
    }

    private static Set<Rule> removeBrokenRules(RuleSets ruleSets) {
        HashSet<Rule> brokenRules = new HashSet<Rule>();
        ruleSets.removeDysfunctionalRules(brokenRules);
        for (Rule rule : brokenRules) {
            if (!LOG.isLoggable(Level.WARNING)) continue;
            LOG.log(Level.WARNING, "Removed misconfigured rule: " + rule.getName() + "  cause: " + rule.dysfunctionReason());
        }
        return brokenRules;
    }

    @Deprecated
    public void processFiles(RuleSetFactory ruleSetFactory, List<DataSource> files, RuleContext ctx, List<Renderer> renderers) {
        RuleSets rs = this.createRuleSets(ruleSetFactory, ctx.getReport());
        this.processFiles(rs, files, ctx, renderers);
    }

    public void processFiles(RuleSets rulesets, List<DataSource> files, RuleContext ctx, List<Renderer> renderers) {
        try {
            AbstractPMDProcessor.reportBrokenRules(ctx.getReport(), rulesets);
            this.renderReports(renderers, ctx.getReport());
            this.configuration.getAnalysisCache().checkValidity(rulesets, this.configuration.getClassLoader());
            SourceCodeProcessor processor = new SourceCodeProcessor(this.configuration);
            for (DataSource dataSource : files) {
                String realFileName = dataSource.getNiceFileName(false, null);
                this.runAnalysis(new PmdRunnable(dataSource, realFileName, renderers, ctx, rulesets, processor));
            }
            this.collectReports(renderers);
        }
        catch (RuntimeException e) {
            try {
                throw new ContextedRuntimeException((Throwable)e).addContextValue("filename", (Object)String.valueOf(ctx.getSourceCodeFile()));
            }
            catch (Throwable throwable) {
                for (DataSource dataSource : files) {
                    IOUtil.closeQuietly(dataSource);
                }
                throw throwable;
            }
        }
        for (DataSource dataSource : files) {
            IOUtil.closeQuietly(dataSource);
        }
    }

    protected abstract void runAnalysis(PmdRunnable var1);

    protected abstract void collectReports(List<Renderer> var1);
}

