/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.PMDConfiguration;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetLoader;
import net.sourceforge.pmd.RuleSets;
import net.sourceforge.pmd.annotation.InternalApi;
import net.sourceforge.pmd.benchmark.TimeTracker;
import net.sourceforge.pmd.benchmark.TimedOperation;
import net.sourceforge.pmd.benchmark.TimedOperationCategory;
import net.sourceforge.pmd.internal.util.FileCollectionUtil;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.LanguageVersionDiscoverer;
import net.sourceforge.pmd.lang.document.FileCollector;
import net.sourceforge.pmd.processor.AbstractPMDProcessor;
import net.sourceforge.pmd.processor.MonoThreadProcessor;
import net.sourceforge.pmd.processor.MultiThreadProcessor;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.util.ClasspathClassLoader;
import net.sourceforge.pmd.util.IOUtil;
import net.sourceforge.pmd.util.datasource.DataSource;
import net.sourceforge.pmd.util.log.MessageReporter;
import net.sourceforge.pmd.util.log.internal.SimpleMessageReporter;

public final class PmdAnalysis
implements AutoCloseable {
    private final FileCollector collector;
    private final List<Renderer> renderers = new ArrayList<Renderer>();
    private final List<RuleSet> ruleSets = new ArrayList<RuleSet>();
    private final PMDConfiguration configuration;
    private final SimpleMessageReporter reporter = new SimpleMessageReporter(Logger.getLogger("net.sourceforge.pmd"));
    private boolean closed;

    private PmdAnalysis(PMDConfiguration config) {
        this.configuration = config;
        this.collector = FileCollector.newCollector(config.getLanguageVersionDiscoverer(), this.reporter);
        MessageReporter.Level logLevel = this.configuration.isDebug() ? MessageReporter.Level.TRACE : MessageReporter.Level.INFO;
        this.reporter.setLevel(logLevel);
    }

    public static PmdAnalysis create(PMDConfiguration config) {
        PmdAnalysis pmd = new PmdAnalysis(config);
        FileCollectionUtil.collectFiles(config, pmd.files());
        if (config.getReportFormat() != null) {
            Renderer renderer = config.createRenderer(true);
            pmd.addRenderer(renderer);
        }
        if (!config.getRuleSetPaths().isEmpty()) {
            RuleSetLoader ruleSetLoader = pmd.newRuleSetLoader();
            List<RuleSet> ruleSets = ruleSetLoader.loadRuleSetsWithoutException(config.getRuleSetPaths());
            pmd.addRuleSets(ruleSets);
        }
        return pmd;
    }

    @InternalApi
    static PmdAnalysis createWithoutCollectingFiles(PMDConfiguration config) {
        return new PmdAnalysis(config);
    }

    List<RuleSet> rulesets() {
        return this.ruleSets;
    }

    List<Renderer> renderers() {
        return this.renderers;
    }

    public FileCollector files() {
        return this.collector;
    }

    public RuleSetLoader newRuleSetLoader() {
        RuleSetLoader loader = RuleSetLoader.fromPmdConfig(this.configuration);
        loader.setReporter(this.reporter);
        return loader;
    }

    public void addRenderer(Renderer renderer) {
        this.renderers.add(Objects.requireNonNull(renderer));
    }

    public void addRenderers(Collection<Renderer> renderers) {
        for (Renderer r : renderers) {
            this.addRenderer(r);
        }
    }

    public void addRuleSet(RuleSet ruleSet) {
        this.ruleSets.add(Objects.requireNonNull(ruleSet));
    }

    public void addRuleSets(Collection<RuleSet> ruleSets) {
        for (RuleSet rs : ruleSets) {
            this.addRuleSet(rs);
        }
    }

    public List<RuleSet> getRulesets() {
        return Collections.unmodifiableList(this.ruleSets);
    }

    public void performAnalysis() {
        this.performAnalysisAndCollectReport();
    }

    public Report performAnalysisAndCollectReport() {
        try (FileCollector files = this.collector;){
            files.filterLanguages(this.getApplicableLanguages());
            List<DataSource> dataSources = FileCollectionUtil.collectorToDataSource(files);
            this.startRenderers();
            Report report = this.performAnalysisImpl(dataSources);
            this.finishRenderers();
            Report report2 = report;
            return report2;
        }
    }

    Report performAnalysisImpl(List<DataSource> sortedFiles) {
        try (TimedOperation ignored = TimeTracker.startOperation(TimedOperationCategory.FILE_PROCESSING);){
            PMD.encourageToUseIncrementalAnalysis(this.configuration);
            Report report = new Report();
            report.addListener(this.configuration.getAnalysisCache());
            RuleContext ctx = new RuleContext();
            ctx.setReport(report);
            PmdAnalysis.newFileProcessor(this.configuration).processFiles(new RuleSets(this.ruleSets), sortedFiles, ctx, this.renderers);
            this.configuration.getAnalysisCache().persist();
            Report report2 = report;
            return report2;
        }
    }

    private void startRenderers() {
        try (TimedOperation ignored = TimeTracker.startOperation(TimedOperationCategory.REPORTING);){
            for (Renderer renderer : this.renderers) {
                try {
                    renderer.start();
                }
                catch (IOException e) {
                    this.reporter.errorEx("Error while starting renderer " + renderer.getName(), e);
                }
            }
        }
    }

    private void finishRenderers() {
        try (TimedOperation ignored = TimeTracker.startOperation(TimedOperationCategory.REPORTING);){
            for (Renderer renderer : this.renderers) {
                try {
                    renderer.end();
                    renderer.flush();
                }
                catch (IOException e) {
                    this.reporter.errorEx("Error while finishing renderer " + renderer.getName(), e);
                }
            }
        }
    }

    private Set<Language> getApplicableLanguages() {
        HashSet<Language> languages = new HashSet<Language>();
        LanguageVersionDiscoverer discoverer = this.configuration.getLanguageVersionDiscoverer();
        for (RuleSet ruleSet : this.ruleSets) {
            for (Rule rule : ruleSet.getRules()) {
                LanguageVersion version;
                Language ruleLanguage = rule.getLanguage();
                if (languages.contains(ruleLanguage) || !RuleSet.applies(rule, version = discoverer.getDefaultLanguageVersion(ruleLanguage))) continue;
                languages.add(ruleLanguage);
                this.reporter.trace("Using {0} version ''{1}''", new Object[]{version.getLanguage().getName(), version.getTerseName()});
            }
        }
        return languages;
    }

    private static AbstractPMDProcessor newFileProcessor(PMDConfiguration configuration) {
        return configuration.getThreads() > 0 ? new MultiThreadProcessor(configuration) : new MonoThreadProcessor(configuration);
    }

    public MessageReporter getReporter() {
        return this.reporter;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.collector.close();
        if (this.configuration.getClassLoader() instanceof ClasspathClassLoader) {
            IOUtil.tryCloseClassLoader(this.configuration.getClassLoader());
        }
    }
}

