/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.html.ast;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.SourceCodePositioner;
import net.sourceforge.pmd.lang.html.ast.ASTHtmlCDataNode;
import net.sourceforge.pmd.lang.html.ast.ASTHtmlComment;
import net.sourceforge.pmd.lang.html.ast.ASTHtmlDocument;
import net.sourceforge.pmd.lang.html.ast.ASTHtmlDocumentType;
import net.sourceforge.pmd.lang.html.ast.ASTHtmlElement;
import net.sourceforge.pmd.lang.html.ast.ASTHtmlTextNode;
import net.sourceforge.pmd.lang.html.ast.ASTHtmlXmlDeclaration;
import net.sourceforge.pmd.lang.html.ast.AbstractHtmlNode;

class LineNumbers {
    private final ASTHtmlDocument document;
    private String htmlString;
    private SourceCodePositioner sourceCodePositioner;

    LineNumbers(ASTHtmlDocument document, String htmlString) {
        this.document = document;
        this.htmlString = htmlString;
        this.sourceCodePositioner = new SourceCodePositioner(htmlString);
    }

    public void determine() {
        this.determineLocation(this.document, 0);
    }

    private int determineLocation(AbstractHtmlNode<?> n, int index) {
        boolean isAutoClose;
        int nextIndex = index;
        int nodeLength = 0;
        int textLength = 0;
        if (n instanceof ASTHtmlDocument) {
            nextIndex = index;
        } else if (n instanceof ASTHtmlComment) {
            nextIndex = this.htmlString.indexOf("<!--", nextIndex);
        } else if (n instanceof ASTHtmlElement) {
            nextIndex = this.htmlString.indexOf("<" + n.getXPathNodeName(), nextIndex);
            nodeLength = this.htmlString.indexOf(">", nextIndex) - nextIndex + 1;
        } else if (n instanceof ASTHtmlCDataNode) {
            nextIndex = this.htmlString.indexOf("<![CDATA[", nextIndex);
        } else if (n instanceof ASTHtmlXmlDeclaration) {
            nextIndex = this.htmlString.indexOf("<?", nextIndex);
        } else if (n instanceof ASTHtmlTextNode) {
            textLength = ((ASTHtmlTextNode)n).getText().length();
        } else if (n instanceof ASTHtmlDocumentType) {
            nextIndex = index;
        }
        this.setBeginLocation(n, nextIndex);
        nextIndex += nodeLength;
        for (Node node : n.children()) {
            nextIndex = this.determineLocation((AbstractHtmlNode)node, nextIndex);
        }
        boolean bl = isAutoClose = n.getNumChildren() == 0 && n instanceof ASTHtmlElement && this.htmlString.startsWith("/>", nextIndex - 2);
        if (n instanceof ASTHtmlDocument) {
            nextIndex = this.htmlString.length();
        } else if (n instanceof ASTHtmlElement && !isAutoClose) {
            nextIndex += 2 + n.getXPathNodeName().length() + 1;
        } else if (n instanceof ASTHtmlComment) {
            nextIndex += 7;
            nextIndex += ((ASTHtmlComment)n).getData().length();
        } else if (n instanceof ASTHtmlTextNode) {
            nextIndex += textLength;
        } else if (n instanceof ASTHtmlCDataNode) {
            nextIndex += "<![CDATA[".length() + ((ASTHtmlCDataNode)n).getText().length() + "]]>".length();
        } else if (n instanceof ASTHtmlXmlDeclaration) {
            nextIndex = this.htmlString.indexOf("?>", nextIndex) + 2;
        } else if (n instanceof ASTHtmlDocumentType) {
            nextIndex = this.htmlString.indexOf(">", nextIndex) + 1;
        }
        this.setEndLocation(n, nextIndex - 1);
        return nextIndex;
    }

    private void setBeginLocation(AbstractHtmlNode<?> n, int index) {
        if (n != null) {
            int line = this.sourceCodePositioner.lineNumberFromOffset(index);
            int column = this.sourceCodePositioner.columnFromOffset(line, index);
            n.setBeginLine(line);
            n.setBeginColumn(column);
        }
    }

    private void setEndLocation(AbstractHtmlNode<?> n, int index) {
        if (n != null) {
            int line = this.sourceCodePositioner.lineNumberFromOffset(index);
            int column = this.sourceCodePositioner.columnFromOffset(line, index);
            n.setEndLine(line);
            n.setEndColumn(column);
        }
    }
}

