/*
 * Decompiled with CFR 0.152.
 */
package apex.common.base;

import apex.common.base.Initializer;

public final class Initializers {
    private Initializers() {
    }

    public static <T, I> Initializer<T, I> memoize(Initializer<T, I> initializer) {
        return initializer instanceof MemoizingInitializer || initializer instanceof OfInstanceInitializer ? initializer : new MemoizingInitializer(initializer);
    }

    public static <T, I> Initializer<T, I> ofInstance(T value) {
        return new OfInstanceInitializer(value);
    }

    private static final class OfInstanceInitializer<T, I>
    implements Initializer<T, I> {
        private final T value;

        OfInstanceInitializer(T value) {
            this.value = value;
        }

        @Override
        public T get(I type) {
            return this.value;
        }

        public String toString() {
            return "Initializers.ofInstance(" + this.value + ")";
        }
    }

    private static final class MemoizingInitializer<T, I>
    implements Initializer<T, I> {
        private Initializer<T, I> initializer;
        private volatile boolean initialized;
        private T value;

        MemoizingInitializer(Initializer<T, I> initializer) {
            assert (initializer != null);
            this.initializer = initializer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get(I init) {
            if (!this.initialized) {
                MemoizingInitializer memoizingInitializer = this;
                synchronized (memoizingInitializer) {
                    if (!this.initialized) {
                        this.value = this.initializer.get(init);
                        this.initialized = true;
                        this.initializer = null;
                        return this.value;
                    }
                }
            }
            return this.value;
        }

        public String toString() {
            return this.value != null ? this.value.toString() : "Initializers.memoize(" + this.initializer + ")";
        }
    }
}

