/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type.common;

import apex.jorje.data.ast.TypeRef;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.common.SfdcCalled;
import apex.jorje.semantic.symbol.resolver.Distance;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.VersionedTypeInfos;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Set;

public class ExceptionTypeInfoUtil {
    private static final Set<String> EXCEPTIONS_THAT_CANNOT_BE_CAUGHT = ImmutableSet.of("com/salesforce/api/exception/FinalException", "com/salesforce/api/exception/ProcedureException", "com/salesforce/api/exception/AssertException", "com/salesforce/api/exception/UnexpectedException", "com/salesforce/api/exception/LimitException", "com/salesforce/api/exception/LicenseException", new String[0]);

    private ExceptionTypeInfoUtil() {
    }

    public static boolean isException(TypeInfo type) {
        return ExceptionTypeInfoUtil.isException(type, type);
    }

    public static boolean isException(TypeInfo referencingType, TypeInfo type) {
        return Distance.get().canAssign(referencingType, type, TypeInfos.EXCEPTION);
    }

    public static boolean isException(Emitter emitter) {
        return ExceptionTypeInfoUtil.isException(emitter.getType());
    }

    public static boolean canExceptionBeCaught(TypeInfo type) {
        return ExceptionTypeInfoUtil.canExceptionBeCaught(type.getBytecodeName());
    }

    public static boolean canExceptionBeCaught(TypeInfo type, TypeRef typeRef) {
        return ExceptionTypeInfoUtil.canExceptionBeCaught(type.getBytecodeName()) && (type != VersionedTypeInfos.EXCEPTION_PRE_V156 || ExceptionTypeInfoUtil.isSystemExceptionRef(typeRef));
    }

    private static boolean isSystemExceptionRef(TypeRef typeRef) {
        return "exception".equalsIgnoreCase(Iterables.getLast(typeRef.getNames()).getValue());
    }

    @SfdcCalled
    public static boolean canExceptionBeCaught(String apexName) {
        return !EXCEPTIONS_THAT_CANNOT_BE_CAUGHT.contains(apexName);
    }
}

