/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.typings;

import apex.jorje.lsp.impl.typings.ModuleGenerator;
import apex.jorje.lsp.impl.typings.TypeDefinitionGenerator;
import apex.jorje.lsp.impl.typings.TypeDefinitionModule;
import apex.jorje.semantic.ast.member.Field;
import apex.jorje.semantic.ast.visitor.AdditionalPassScope;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.compiler.CodeUnit;
import apex.jorje.semantic.symbol.type.ScalarTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.common.CollectionTypeInfoUtil;
import apex.jorje.semantic.symbol.type.visitor.TypeInfoVisitor;
import com.google.common.collect.Lists;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Optional;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;

public class SObjectModuleGenerator
implements ModuleGenerator {
    private static final String SOBJECT_TYPE_DEFINITION_STG = "sobject_typeDefinition.stg";
    private static final String MODULE_RULE = "module";
    private static final String SOBJECT_NAME = "sobjectName";
    private static final String FIELD_NAME = "fieldName";
    private static final String FIELD_TYPE = "fieldType";
    private final CodeUnit codeUnit;

    SObjectModuleGenerator(CodeUnit codeUnit) {
        this.codeUnit = codeUnit;
    }

    private static String normalizeFieldType(TypeInfo type) {
        return type.accept(new TypeInfoVisitor.Default<String>(){

            @Override
            protected String _default(TypeInfo type) {
                return "any";
            }

            @Override
            public String visit(ScalarTypeInfo type) {
                switch (type.getBasicType()) {
                    case INTEGER: 
                    case LONG: 
                    case DOUBLE: 
                    case DECIMAL: {
                        return TYPESCRIPT_TYPES.NUMBER.type;
                    }
                    case BOOLEAN: {
                        return TYPESCRIPT_TYPES.BOOLEAN.type;
                    }
                    case STRING: {
                        return TYPESCRIPT_TYPES.STRING.type;
                    }
                    case VOID: 
                    case APEX_OBJECT: 
                    case LIST: 
                    case LIST_ITERATOR: 
                    case SET: 
                    case MAP: 
                    case TIME: 
                    case DATE: 
                    case DATE_TIME: 
                    case OBJECT: 
                    case ID: 
                    case BLOB: 
                    case NULL: 
                    case ANNOTATION: 
                    case SOBJECT: 
                    case JAVA: 
                    case CURRENCY: 
                    case VF_COMPONENT: 
                    case FLOW_INTERVIEW: 
                    case MODIFIER: {
                        return TYPESCRIPT_TYPES.ANY.type;
                    }
                }
                return TYPESCRIPT_TYPES.ANY.type;
            }
        });
    }

    private static String getModule(Field node) {
        try {
            InputStream resource = TypeDefinitionGenerator.class.getClassLoader().getResourceAsStream(SOBJECT_TYPE_DEFINITION_STG);
            StringTemplateGroup templates = new StringTemplateGroup((Reader)new InputStreamReader(resource));
            StringTemplate module = templates.getInstanceOf(MODULE_RULE);
            module.setAttribute(SOBJECT_NAME, (Object)node.getDefiningType().getApexName());
            module.setAttribute(FIELD_NAME, (Object)node.getFieldInfo().getName());
            module.setAttribute(FIELD_TYPE, (Object)SObjectModuleGenerator.normalizeFieldType(node.getFieldInfo().getType()));
            return module.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public Optional<TypeDefinitionModule> generateModulesIfApplicable() {
        SObjectFieldsVisitor visitor = new SObjectFieldsVisitor();
        this.codeUnit.additionalValidate(visitor);
        if (!visitor.getFields().isEmpty()) {
            return Optional.of(new TypeDefinitionModule(TypeDefinitionGenerator.generateTypeDefinitionFileName(this.codeUnit), visitor.getFields().stream().filter(field -> !CollectionTypeInfoUtil.isMapOrCollection(field.getFieldInfo().getType())).map(SObjectModuleGenerator::getModule).reduce("", String::concat), TypeDefinitionModule.Kind.SOBJECT));
        }
        return Optional.empty();
    }

    public static class SObjectFieldsVisitor
    extends AstVisitor<AdditionalPassScope> {
        private final List<Field> fields = Lists.newArrayList();

        @Override
        protected boolean defaultVisit() {
            return true;
        }

        @Override
        public void visitEnd(Field node, AdditionalPassScope scope) {
            super.visitEnd(node, scope);
            this.fields.add(node);
        }

        List<Field> getFields() {
            return this.fields;
        }
    }

    static enum TYPESCRIPT_TYPES {
        NUMBER("number"),
        STRING("string"),
        BOOLEAN("boolean"),
        ANY("any");

        private final String type;

        private TYPESCRIPT_TYPES(String type) {
            this.type = type;
        }
    }
}

