/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.services.printers.sosl;

import apex.jorje.data.Identifier;
import apex.jorje.data.sosl.SearchWithClause;
import apex.jorje.data.sosl.SearchWithClauseValue;
import apex.jorje.services.printers.PrintContext;
import apex.jorje.services.printers.Printer;
import apex.jorje.services.printers.ast.IdentifierPrinter;
import apex.jorje.services.printers.ast.OptionalPrinter;
import apex.jorje.services.printers.sosl.SearchWithValuePrinter;
import java.util.Optional;

public class SearchWithPrinter
implements Printer<SearchWithClause> {
    private static final Printer<SearchWithClause> INSTANCE = new SearchWithPrinter(IdentifierPrinter.get(), SearchWithValuePrinter.get());
    private final Printer<Identifier> identifierPrinter;
    private final Printer<Optional<SearchWithClauseValue>> valuePrinter;

    private SearchWithPrinter(Printer<Identifier> identifierPrinter, Printer<SearchWithClauseValue> valuePrinter) {
        this.identifierPrinter = identifierPrinter;
        this.valuePrinter = OptionalPrinter.create(valuePrinter, "", " ", "");
    }

    public static Printer<SearchWithClause> get() {
        return INSTANCE;
    }

    @Override
    public String print(SearchWithClause x, PrintContext ctx) {
        return " WITH " + this.identifierPrinter.print(x.name, ctx) + this.valuePrinter.print(x.value, ctx);
    }
}

