/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.visitor.reference;

import apex.common.base.MoreStrings;
import apex.common.collect.MoreIterables;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.ReferenceContext;
import apex.jorje.semantic.ast.expression.ReferenceExpression;
import apex.jorje.semantic.ast.visitor.reference.ReferenceInfo;
import apex.jorje.semantic.ast.visitor.reference.ReferenceVisitor;
import apex.jorje.semantic.symbol.member.variable.Variable;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.SObjectTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.common.SObjectTypeInfoUtil;

class SObjectReferenceUtil {
    private static final SObjectReferenceUtil INSTANCE = new SObjectReferenceUtil();

    private SObjectReferenceUtil() {
    }

    static SObjectReferenceUtil get() {
        return INSTANCE;
    }

    private static boolean isSameName(String firstNameFromUser, TypeInfo sObjectType) {
        return MoreStrings.equalsIgnoreCase(firstNameFromUser, sObjectType.getApexName()) || MoreStrings.equalsIgnoreCase(sObjectType.getNamespace() + "__" + firstNameFromUser, sObjectType.getApexName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void addSObjectTypeIfStaticReference(ReferenceExpression node, ReferenceVisitor referenceVisitor) {
        TypeInfo firstType;
        if (node.getDottedExpression() != Expression.NOOP) {
            return;
        }
        if (node.getSpecialStatic() == null) {
            if (node.getVariables().isEmpty()) {
                firstType = node.getType();
            } else {
                Variable variable = MoreIterables.getFirst(node.getVariables());
                if (TypeInfoEquivalence.isEquivalent(variable.getType(), InternalTypeInfos.SCHEMA_SOBJECT_ROW_CAUSE)) {
                    return;
                }
                if (!variable.getModifiers().has(ModifierTypeInfos.STATIC)) return;
                firstType = variable.getDefiningType();
            }
        } else {
            firstType = node.getSpecialStatic().getDefiningType();
        }
        if (!SObjectTypeInfoUtil.isConcreteSObject(firstType)) return;
        SObjectReferenceUtil.get().addSObjectTypeIfStaticReference(node, SObjectTypeInfoUtil.getSObjectTypeInfoFromType(firstType), referenceVisitor);
    }

    private void addSObjectTypeIfStaticReference(ReferenceContext referenceContext, SObjectTypeInfo sObjectType, ReferenceVisitor referenceVisitor) {
        String firstNameFromUser = MoreIterables.getFirst(referenceContext.getNames()).getValue();
        if (SObjectReferenceUtil.isSameName(firstNameFromUser, sObjectType)) {
            referenceVisitor.checkAndAddVariableRelationship(sObjectType, referenceContext.getDottedExpression().getLoc(), ReferenceInfo.empty());
        }
    }
}

