/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.services;

import apex.jorje.lsp.api.document.Document;
import apex.jorje.lsp.api.services.ApexCompilerService;
import apex.jorje.lsp.api.services.DocumentationService;
import apex.jorje.lsp.api.visitors.VisitorFactory;
import apex.jorje.lsp.api.workspace.ApexDocumentService;
import apex.jorje.lsp.impl.visitors.DocCommentScope;
import apex.jorje.semantic.compiler.CodeUnit;
import apex.jorje.semantic.symbol.member.Member;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.variable.Variable;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.details.CodeUnitDetailsProvider;
import com.google.inject.Inject;
import java.net.URI;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class StandardDocumentationService
implements DocumentationService {
    public static final String BEGIN_CODE_BLOCK = "```apex\n";
    public static final String END_CODE_BLOCK = "\n```\n";
    private static final String MARKDOWN_NEW_LINE = "  \n";
    private static final String REGEX_NEW_LINE = "\\r?\\n";
    private final ApexCompilerService compilerService;
    private final ApexDocumentService documentService;
    private final VisitorFactory visitorFactory;

    @Inject
    public StandardDocumentationService(ApexCompilerService compilerService, ApexDocumentService documentService, VisitorFactory visitorFactory) {
        this.compilerService = compilerService;
        this.documentService = documentService;
        this.visitorFactory = visitorFactory;
    }

    public static MarkupContent getMarkupForSymbol(Either<TypeInfo, Member> typeInfoMemberEither) {
        String markupValue = BEGIN_CODE_BLOCK + StandardDocumentationService.getSymbolText(typeInfoMemberEither) + END_CODE_BLOCK;
        MarkupContent content = new MarkupContent();
        content.setKind("markdown");
        content.setValue(markupValue);
        return content;
    }

    public static String getSymbolText(Either<TypeInfo, Member> typeInfoMemberEither) {
        return typeInfoMemberEither.isLeft() ? ((TypeInfo)typeInfoMemberEither.getLeft()).getApexName() : StandardDocumentationService.getStringForMember((Member)typeInfoMemberEither.getRight());
    }

    private static String getStringForMember(Member member) {
        if (member.getMemberType() == Member.Type.METHOD) {
            MethodInfo m = (MethodInfo)member;
            String params = m.getParameters().stream().map(p -> p.getType().getApexName() + " " + p.getName().getValue()).collect(Collectors.joining(", "));
            StringBuilder fullName = new StringBuilder(m.getReturnType().getApexName()).append(" ").append(m.getDefiningType().getApexName()).append(".").append(m.getCanonicalName()).append("(").append(params).append(")");
            return fullName.toString();
        }
        Variable variable = (Variable)member;
        String fullName = member.getMemberType() == Member.Type.LOCAL ? variable.getName() : variable.getDefiningType().getApexName() + "." + variable.getName();
        return variable.getType().getApexName() + " " + fullName;
    }

    @Override
    public MarkupContent getDocumentation(Either<TypeInfo, Member> reference, boolean withSymbol) {
        String commentString = this.getDocComment(reference).orElse("");
        String commentAsMarkdown = Arrays.stream(commentString.split(REGEX_NEW_LINE)).map(this::stripLeadingCommentCharTokens).filter(s -> !s.isEmpty()).collect(Collectors.joining(MARKDOWN_NEW_LINE));
        StringBuilder markupValue = new StringBuilder();
        if (withSymbol) {
            markupValue.append(StandardDocumentationService.getMarkupForSymbol(reference).getValue());
        }
        markupValue.append(commentAsMarkdown);
        MarkupContent content = new MarkupContent();
        content.setValue(markupValue.toString());
        content.setKind("markdown");
        return content;
    }

    @Override
    public MarkupContent getDocumentation(TypeInfo reference) {
        return this.getDocumentation((Either<TypeInfo, Member>)Either.forLeft((Object)reference), false);
    }

    @Override
    public MarkupContent getDocumentation(Member reference) {
        return this.getDocumentation((Either<TypeInfo, Member>)Either.forRight((Object)reference), false);
    }

    private String stripLeadingCommentCharTokens(String token) {
        String newToken = token.trim();
        if (newToken.startsWith("/**") || newToken.startsWith("**/")) {
            newToken = newToken.substring(3);
        } else if (newToken.startsWith("/*") || newToken.startsWith("*/") || newToken.startsWith("**")) {
            newToken = newToken.substring(2);
        } else if (newToken.startsWith("*")) {
            newToken = newToken.substring(1);
        }
        return newToken.replace("*", "\\*").trim();
    }

    private Optional<String> getDocComment(Either<TypeInfo, Member> refSymbol) {
        TypeInfo type;
        TypeInfo typeInfo = type = refSymbol.isLeft() ? (TypeInfo)refSymbol.getLeft() : ((Member)refSymbol.getRight()).getDefiningType();
        if (type.getCodeUnitDetails() instanceof CodeUnitDetailsProvider.NonSourceCodeUnitDetails) {
            return Optional.empty();
        }
        Optional<Document> document = this.documentService.retrieve(URI.create(type.getCodeUnitDetails().getSource().getKnownName()));
        if (!document.isPresent()) {
            return Optional.empty();
        }
        CodeUnit codeUnit = this.compilerService.compile(document.get());
        DocCommentScope scope = new DocCommentScope(refSymbol, codeUnit.getHiddenTokenMap());
        codeUnit.getNode().traverse(this.visitorFactory.createDocCommentVisitor(), scope);
        return scope.getComment();
    }
}

