/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.utils;

import apex.jorje.lsp.api.document.Document;
import apex.jorje.lsp.impl.completions.CompletionActivationFactory;
import apex.jorje.lsp.impl.completions.SObjectCompletionActivationStrategy;
import apex.jorje.lsp.impl.document.BadLocationException;
import apex.jorje.semantic.symbol.type.TypeInfo;
import com.google.inject.Inject;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.eclipse.lsp4j.Position;

public class ConstructorContextUtil {
    private final CompletionActivationFactory factory;

    @Inject
    public ConstructorContextUtil(CompletionActivationFactory factory) {
        this.factory = factory;
    }

    public boolean isConstructorContext(Document doc, Position position) throws BadLocationException {
        MutableBoolean inConstructor = new MutableBoolean(false);
        this.constructorContext(doc, position, (typeInfo, usedParams) -> inConstructor.setValue(true));
        return inConstructor.getValue();
    }

    public void constructorContext(Document doc, Position position, BiConsumer<TypeInfo, Set<String>> delegate) throws BadLocationException {
        SObjectCompletionActivationStrategy strategy = this.factory.createSObjectBasedStrategy(doc, position);
        strategy.analyze();
        if (strategy.getType().isPresent()) {
            delegate.accept(strategy.getType().get(), strategy.getUsedParams());
        }
    }
}

